/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.solsticePronouns.modules.pronouns;

import cc.reconnected.solsticePronouns.modules.pronouns.commands.PronounsCommand;
import cc.reconnected.solsticePronouns.modules.pronouns.data.PronounsConfig;
import cc.reconnected.solsticePronouns.modules.pronouns.data.PronounsLocale;
import cc.reconnected.solsticePronouns.modules.pronouns.data.PronounsPlayerData;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PronounsModule
extends ModuleBase.Toggleable {
    public static final String ID = "pronouns";

    public PronounsModule() {
        super(ID);
    }

    public void init() {
        Solstice.configManager.registerData(ID, PronounsConfig.class, PronounsConfig::new);
        Solstice.localeManager.registerModule(ID, PronounsLocale.MODULE);
        Solstice.playerData.registerData(ID, PronounsPlayerData.class, PronounsPlayerData::new);
        this.commands.add(new PronounsCommand(this));
        Placeholders.register((class_2960)new class_2960("player", ID), (context, args) -> {
            if (!context.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            return PlaceholderResult.value((class_2561)this.getPlayerTag(context.player().method_5667()));
        });
    }

    public PronounsConfig getConfig() {
        return (PronounsConfig)Solstice.configManager.getData(PronounsConfig.class);
    }

    public List<String> getFirstAndMeta() {
        PronounsConfig config = this.getConfig();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(config.first);
        list.addAll(config.meta);
        return list;
    }

    public List<String> getSecondMatching(String first) {
        List<String> firstAndMeta = this.getFirstAndMeta();
        int index = firstAndMeta.indexOf(first);
        if (index == -1) {
            return List.of();
        }
        PronounsConfig config = this.getConfig();
        if (index >= config.first.size()) {
            return List.of();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(config.second.get(index));
        list.addAll(config.first.stream().filter(s -> !s.equals(first)).toList());
        return list;
    }

    public PronounsPlayerData getPlayer(UUID uuid) {
        return (PronounsPlayerData)Solstice.playerData.get(uuid).getData(PronounsPlayerData.class);
    }

    public class_2561 getPronouns(String first, @Nullable String second) {
        String format;
        Map<String, class_2561> map;
        PronounsConfig config = this.getConfig();
        if (second == null) {
            map = Map.of("pronoun", class_2561.method_30163((String)first));
            format = config.metaFormat;
        } else {
            map = Map.of("first", class_2561.method_30163((String)first), "second", class_2561.method_30163((String)second));
            format = config.nominativeFormat;
        }
        return Format.parse((String)format, map);
    }

    public class_2561 getTag(class_2561 pronouns) {
        PronounsConfig config = this.getConfig();
        Map<String, class_2561> map = Map.of(ID, pronouns);
        return Format.parse((String)config.tagFormat, map);
    }

    public boolean hasPronouns(UUID uuid) {
        return this.getPlayer((UUID)uuid).first != null;
    }

    public class_2561 getPlayerPronouns(UUID uuid) {
        PronounsPlayerData data = this.getPlayer(uuid);
        return this.getPronouns(data.first, data.second);
    }

    public class_2561 getPlayerTag(UUID uuid) {
        if (this.hasPronouns(uuid)) {
            class_2561 pronouns = this.getPlayerPronouns(uuid);
            return this.getTag(pronouns);
        }
        PronounsConfig config = this.getConfig();
        return Format.parse((String)config.emptyTag);
    }
}

