/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.modsupport.BlockModel;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public abstract class BlockModelImpl
implements BlockModel {
    private int[] ids = new int[0];
    private String[] names = new String[0];
    private BitSet meta = null;
    private List<Map<String, String>> blockstates = null;
    protected final ModModelDefinitionImpl mdf;

    @Deprecated
    public BlockModelImpl(int blkid, ModModelDefinitionImpl mdf) {
        this.addBlockID(blkid);
        this.mdf = mdf;
    }

    public BlockModelImpl(String blkname, ModModelDefinitionImpl mdf) {
        this.addBlockName(blkname);
        this.mdf = mdf;
    }

    @Override
    @Deprecated
    public void addBlockID(int blockID) {
        if (blockID > 0) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    @Override
    public void addBlockName(String blockname) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(blockname)) continue;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = blockname;
    }

    @Override
    @Deprecated
    public int[] getBlockIDs() {
        return this.ids;
    }

    @Override
    public String[] getBlockNames() {
        return this.names;
    }

    @Override
    @Deprecated
    public void setMetaValue(int data) {
        if (this.meta == null) {
            this.meta = new BitSet();
        }
        this.meta.set(data);
    }

    @Override
    @Deprecated
    public int getMetaValueMask() {
        if (this.meta == null) {
            return -1;
        }
        return (int)this.meta.toLongArray()[0];
    }

    @Override
    public void setBlockStateMapping(Map<String, String> statemap) {
        if (this.blockstates == null) {
            this.blockstates = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> nmap = new HashMap<String, String>();
        nmap.putAll(statemap);
        this.blockstates.add(nmap);
    }

    @Override
    public List<Map<String, String>> getBlockStateMappings() {
        return this.blockstates;
    }

    public abstract String getLine();

    protected String getIDsAndMeta() {
        int i;
        if (this.ids.length == 0 && this.names.length == 0) {
            return null;
        }
        String s = "";
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
        }
        for (i = 0; i < this.names.length; ++i) {
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + "id=%" + this.names[i];
        }
        if (this.blockstates != null) {
            for (Map<String, String> rec : this.blockstates) {
                if (rec.size() == 0) continue;
                s = s + ",state=";
                boolean first = true;
                for (Map.Entry<String, String> r : rec.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        s = s + '/';
                    }
                    s = s + r.getKey() + ":" + r.getValue();
                }
            }
        }
        if (this.meta != null) {
            int i2 = this.meta.nextSetBit(0);
            while (i2 != -1) {
                s = s + ",data=" + i2;
                i2 = this.meta.nextSetBit(i2 + 1);
            }
        }
        if (this.meta == null && this.blockstates == null) {
            s = s + ",state=*";
        }
        return s;
    }
}

