/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.List;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.config.StatisticsLoggingLevel;
import me.cortex.nvidium.config.TranslucencySortingLevel;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.IDeviceMappedBuffer;
import me.cortex.nvidium.gl.buffers.PersistentSparseAddressableBuffer;
import me.cortex.nvidium.managers.RegionManager;
import me.cortex.nvidium.managers.RegionVisibilityTracker;
import me.cortex.nvidium.managers.SectionManager;
import me.cortex.nvidium.renderers.PrimaryTerrainRasterizer;
import me.cortex.nvidium.renderers.RegionRasterizer;
import me.cortex.nvidium.renderers.SectionRasterizer;
import me.cortex.nvidium.renderers.SortRegionSectionPhase;
import me.cortex.nvidium.renderers.TemporalTerrainRasterizer;
import me.cortex.nvidium.renderers.TranslucentTerrainRasterizer;
import me.cortex.nvidium.util.DownloadTaskStream;
import me.cortex.nvidium.util.TickableManager;
import me.cortex.nvidium.util.UploadingBufferStream;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4i;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.NVVertexBufferUnifiedMemory;
import org.lwjgl.system.MemoryUtil;

public class RenderPipeline {
    public static final int GL_DRAW_INDIRECT_UNIFIED_NV = 36672;
    public static final int GL_DRAW_INDIRECT_ADDRESS_NV = 36673;
    private final RenderDevice device;
    private final UploadingBufferStream uploadStream;
    private final DownloadTaskStream downloadStream;
    private final SectionManager sectionManager;
    public final RegionVisibilityTracker regionVisibilityTracking;
    private PrimaryTerrainRasterizer terrainRasterizer;
    private RegionRasterizer regionRasterizer;
    private SectionRasterizer sectionRasterizer;
    private TemporalTerrainRasterizer temporalRasterizer;
    private TranslucentTerrainRasterizer translucencyTerrainRasterizer;
    private SortRegionSectionPhase regionSectionSorter;
    private final IDeviceMappedBuffer sceneUniform;
    private static final int SCENE_SIZE = (int)PersistentSparseAddressableBuffer.alignUp(295L, 2L);
    private final IDeviceMappedBuffer regionVisibility;
    private final IDeviceMappedBuffer sectionVisibility;
    private final IDeviceMappedBuffer terrainCommandBuffer;
    private final IDeviceMappedBuffer translucencyCommandBuffer;
    private final IDeviceMappedBuffer regionSortingList;
    private final IDeviceMappedBuffer statisticsBuffer;
    private final IDeviceMappedBuffer transformationArray;
    private final IDeviceMappedBuffer originOffsetArray;
    private final BitSet regionVisibilityTracker;
    private final IntSet regionsToSort = new IntOpenHashSet();
    private final Statistics stats;
    private int prevRegionCount;
    private int frameId;
    private boolean compiledForFog = false;

    public RenderPipeline(RenderDevice device, UploadingBufferStream uploadStream, DownloadTaskStream downloadStream, SectionManager sectionManager) {
        this.device = device;
        this.uploadStream = uploadStream;
        this.downloadStream = downloadStream;
        this.sectionManager = sectionManager;
        this.compiledForFog = Nvidium.config.render_fog;
        this.terrainRasterizer = new PrimaryTerrainRasterizer();
        this.regionRasterizer = new RegionRasterizer();
        this.sectionRasterizer = new SectionRasterizer();
        this.temporalRasterizer = new TemporalTerrainRasterizer();
        this.translucencyTerrainRasterizer = new TranslucentTerrainRasterizer();
        this.regionSectionSorter = new SortRegionSectionPhase();
        int maxRegions = sectionManager.getRegionManager().maxRegions();
        this.sceneUniform = device.createDeviceOnlyMappedBuffer((long)SCENE_SIZE + (long)maxRegions * 2L);
        this.regionVisibility = device.createDeviceOnlyMappedBuffer(maxRegions);
        this.sectionVisibility = device.createDeviceOnlyMappedBuffer((long)maxRegions * 256L);
        this.terrainCommandBuffer = device.createDeviceOnlyMappedBuffer((long)maxRegions * 8L);
        this.translucencyCommandBuffer = device.createDeviceOnlyMappedBuffer((long)maxRegions * 8L);
        this.regionSortingList = device.createDeviceOnlyMappedBuffer((long)maxRegions * 2L);
        this.transformationArray = device.createDeviceOnlyMappedBuffer(65536L);
        this.originOffsetArray = device.createDeviceOnlyMappedBuffer(8192L);
        this.regionVisibilityTracker = new BitSet(maxRegions);
        this.regionVisibilityTracking = new RegionVisibilityTracker(downloadStream, maxRegions);
        this.statisticsBuffer = device.createDeviceOnlyMappedBuffer(16L);
        this.stats = new Statistics();
        long ptr = this.uploadStream.upload(this.transformationArray, 0L, 65536L);
        Matrix4f transform = new Matrix4f().identity();
        for (int i = 0; i < 1024; ++i) {
            transform.getToAddress(ptr);
            ptr += 64L;
        }
        ARBDirectStateAccess.nglClearNamedBufferData((int)this.originOffsetArray.getId(), (int)33330, (int)36244, (int)5121, (long)0L);
    }

    public void setTransformation(int id, Matrix4fc transform) {
        if (id < 0 || id >= 1024) {
            throw new IllegalArgumentException("Id out of bounds: " + id);
        }
        long ptr = this.uploadStream.upload(this.transformationArray, id * 64, 64L);
        transform.getToAddress(ptr);
    }

    public void setOrigin(int id, int x, int y, int z) {
        if (id < 0 || id >= 1024) {
            throw new IllegalArgumentException("Id out of bounds: " + id);
        }
        long ptr = this.uploadStream.upload(this.originOffsetArray, id * 8, 8L);
        long pos = 0L;
        pos |= (long)(x & 0x1FFFFFF);
        pos |= (long)(z & 0x1FFFFFF) << 25;
        MemoryUtil.memPutLong((long)ptr, (long)(pos |= (long)(y & 0x3FFF) << 50));
    }

    public void renderFrame(Viewport frustum, ChunkRenderMatrices crm, double px, double py, double pz) {
        int regionSortSize;
        long addr;
        if (this.sectionManager.getRegionManager().regionCount() == 0) {
            return;
        }
        boolean DEBUG_RENDER_LEVEL = false;
        boolean WRITE_DEPTH = false;
        Vector3i blockPos = new Vector3i((int)Math.floor(px), (int)Math.floor(py), (int)Math.floor(pz));
        Vector3i chunkPos = new Vector3i(blockPos.x >> 4, blockPos.y >> 4, blockPos.z >> 4);
        int screenWidth = class_310.method_1551().method_22683().method_4489();
        int screenHeight = class_310.method_1551().method_22683().method_4506();
        int visibleRegions = 0;
        long queryAddr = 0L;
        RegionManager rm = this.sectionManager.getRegionManager();
        IntAVLTreeSet regions = new IntAVLTreeSet();
        for (int i = 0; i < rm.maxRegionIndex(); ++i) {
            if (!rm.regionExists(i)) continue;
            if (Nvidium.config.region_keep_distance != 256 && Nvidium.config.region_keep_distance != 32 && !rm.withinSquare(Nvidium.config.region_keep_distance + 4, i, chunkPos.x, chunkPos.y, chunkPos.z)) {
                this.removeRegion(i);
                continue;
            }
            if (rm.isRegionVisible(frustum, i)) {
                regions.add(rm.distance(i, chunkPos.x, chunkPos.y, chunkPos.z) << 16 | i);
                ++visibleRegions;
                this.regionVisibilityTracker.set(i);
                if (!rm.isRegionInACameraAxis(i, px, py, pz)) continue;
                this.regionsToSort.add(i);
                continue;
            }
            if (this.regionVisibilityTracker.get(i) && Nvidium.config.enable_temporal_coherence) {
                ARBDirectStateAccess.nglClearNamedBufferSubData((int)this.sectionVisibility.getId(), (int)33330, (long)((long)i << 8), (long)255L, (int)36244, (int)5121, (long)0L);
            }
            this.regionVisibilityTracker.clear(i);
        }
        short[] regionMap = new short[regions.size()];
        if (visibleRegions == 0) {
            return;
        }
        queryAddr = addr = this.uploadStream.upload(this.sceneUniform, SCENE_SIZE, visibleRegions * 2);
        int j = 0;
        IntBidirectionalIterator intBidirectionalIterator = regions.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int i = (Integer)intBidirectionalIterator.next();
            regionMap[j] = (short)i;
            MemoryUtil.memPutShort((long)(addr + ((long)j << 1)), (short)((short)i));
            ++j;
        }
        if (Nvidium.config.statistics_level != StatisticsLoggingLevel.NONE) {
            this.stats.frustumCount = regions.size();
        }
        Vector3f delta = new Vector3f((float)(px - (double)(chunkPos.x << 4)), (float)(py - (double)(chunkPos.y << 4)), (float)(pz - (double)(chunkPos.z << 4)));
        delta.negate();
        addr = this.uploadStream.upload(this.sceneUniform, 0L, SCENE_SIZE);
        new Matrix4f(crm.projection()).mul(crm.modelView()).translate((Vector3fc)delta).getToAddress(addr);
        addr += 64L;
        if (this.compiledForFog) {
            new Matrix4f(crm.projection()).mul(crm.modelView()).invert().getToAddress(addr);
            addr += 64L;
        }
        new Vector4i(chunkPos.x, chunkPos.y, chunkPos.z, 0).getToAddress(addr);
        new Vector4f((Vector3fc)delta, 0.0f).getToAddress(addr += 16L);
        new Vector4f(RenderSystem.getShaderFogColor()).getToAddress(addr += 16L);
        MemoryUtil.memPutLong((long)(addr += 16L), (long)(this.sceneUniform.getDeviceAddress() + (long)SCENE_SIZE));
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.sectionManager.getRegionManager().getRegionBufferAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.sectionManager.getRegionManager().getSectionBufferAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.regionVisibility.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.sectionVisibility.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.terrainCommandBuffer.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.translucencyCommandBuffer.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.regionSortingList.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.sectionManager.terrainAreana.buffer.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.transformationArray.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)this.originOffsetArray.getDeviceAddress());
        MemoryUtil.memPutLong((long)(addr += 8L), (long)(this.statisticsBuffer == null ? 0L : this.statisticsBuffer.getDeviceAddress()));
        MemoryUtil.memPutFloat((long)(addr += 8L), (float)((float)screenWidth / 2.0f));
        MemoryUtil.memPutFloat((long)(addr += 4L), (float)((float)screenHeight / 2.0f));
        MemoryUtil.memPutFloat((long)(addr += 4L), (float)RenderSystem.getShaderFogStart());
        MemoryUtil.memPutFloat((long)(addr += 4L), (float)RenderSystem.getShaderFogEnd());
        MemoryUtil.memPutInt((long)(addr += 4L), (int)RenderSystem.getShaderFogShape().method_40036());
        MemoryUtil.memPutShort((long)(addr += 4L), (short)((short)visibleRegions));
        MemoryUtil.memPutByte((long)(addr += 2L), (byte)((byte)this.frameId++));
        if (Nvidium.config.translucency_sorting_level == TranslucencySortingLevel.NONE) {
            this.regionsToSort.clear();
        }
        if ((regionSortSize = this.regionsToSort.size()) != 0) {
            long regionSortUpload = this.uploadStream.upload(this.regionSortingList, 0L, regionSortSize * 2);
            IntIterator intIterator = this.regionsToSort.iterator();
            while (intIterator.hasNext()) {
                int region = (Integer)intIterator.next();
                MemoryUtil.memPutShort((long)regionSortUpload, (short)((short)region));
                regionSortUpload += 2L;
            }
            this.regionsToSort.clear();
        }
        this.sectionManager.commitChanges();
        this.uploadStream.commit();
        TickableManager.TickAll();
        GL42.glEnableClientState((int)37742);
        GL42.glEnableClientState((int)36638);
        GL42.glEnableClientState((int)36639);
        GL42.glEnableClientState((int)36672);
        NVVertexBufferUnifiedMemory.glBufferAddressRangeNV((int)37743, (int)0, (long)this.sceneUniform.getDeviceAddress(), (long)SCENE_SIZE);
        if (this.prevRegionCount != 0) {
            GL42.glEnable((int)2929);
            this.terrainRasterizer.raster(this.prevRegionCount, this.terrainCommandBuffer.getDeviceAddress());
            GL42.glMemoryBarrier((int)1024);
        }
        GL42.glEnable((int)2929);
        GL42.glDepthFunc((int)515);
        GL42.glDepthMask((boolean)false);
        GL42.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL42.glEnable((int)37759);
        this.regionRasterizer.raster(visibleRegions);
        GL42.glMemoryBarrier((int)8192);
        this.sectionRasterizer.raster(visibleRegions);
        GL42.glDisable((int)37759);
        GL42.glDepthMask((boolean)true);
        GL42.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL42.glMemoryBarrier((int)8192);
        this.prevRegionCount = visibleRegions;
        if (Nvidium.config.enable_temporal_coherence) {
            GL42.glMemoryBarrier((int)64);
            this.temporalRasterizer.raster(visibleRegions, this.terrainCommandBuffer.getDeviceAddress());
        }
        GL42.glDepthMask((boolean)false);
        GL42.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL42.glEnable((int)37759);
        this.regionVisibilityTracking.computeVisibility(visibleRegions, this.regionVisibility, regionMap);
        GL42.glDisable((int)37759);
        GL42.glDepthMask((boolean)true);
        GL42.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (regionSortSize != 0) {
            GL42.glMemoryBarrier((int)8192);
            this.regionSectionSorter.dispatch(regionSortSize);
            GL42.glMemoryBarrier((int)8192);
        }
        GL42.glDisableClientState((int)37742);
        GL42.glDisableClientState((int)36638);
        GL42.glDisableClientState((int)36639);
        GL42.glDisableClientState((int)36672);
        GL42.glDepthFunc((int)515);
        GL42.glDisable((int)2929);
    }

    void enqueueRegionSort(int regionId) {
        this.regionsToSort.add(regionId);
    }

    private void removeRegion(int id) {
        this.sectionManager.removeRegionById(id);
        this.regionVisibilityTracking.resetRegion(id);
    }

    public void removeARegion() {
        this.removeRegion(this.regionVisibilityTracking.findMostLikelyLeastSeenRegion(this.sectionManager.getRegionManager().maxRegionIndex()));
    }

    public void renderTranslucent() {
        GL42.glEnableClientState((int)37742);
        GL42.glEnableClientState((int)36638);
        GL42.glEnableClientState((int)36639);
        GL42.glEnableClientState((int)36672);
        NVVertexBufferUnifiedMemory.glBufferAddressRangeNV((int)37743, (int)0, (long)this.sceneUniform.getDeviceAddress(), (long)SCENE_SIZE);
        GL42.glEnable((int)2929);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        this.translucencyTerrainRasterizer.raster(this.prevRegionCount, this.translucencyCommandBuffer.getDeviceAddress());
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        GL42.glDisable((int)2929);
        GL42.glDisableClientState((int)37742);
        GL42.glDisableClientState((int)36638);
        GL42.glDisableClientState((int)36639);
        GL42.glDisableClientState((int)36672);
        if (Nvidium.config.statistics_level.ordinal() > StatisticsLoggingLevel.FRUSTUM.ordinal()) {
            this.downloadStream.download(this.statisticsBuffer, 0L, 16, addr -> {
                this.stats.regionCount = MemoryUtil.memGetInt((long)addr);
                this.stats.sectionCount = MemoryUtil.memGetInt((long)(addr + 4L));
                this.stats.quadCount = MemoryUtil.memGetInt((long)(addr + 8L));
            });
        }
        if (Nvidium.config.statistics_level.ordinal() > StatisticsLoggingLevel.FRUSTUM.ordinal()) {
            long upload = this.uploadStream.upload(this.statisticsBuffer, 0L, 16L);
            MemoryUtil.memSet((long)upload, (int)0, (long)16L);
        }
    }

    public void delete() {
        this.regionVisibilityTracking.delete();
        this.sceneUniform.delete();
        this.regionVisibility.delete();
        this.sectionVisibility.delete();
        this.terrainCommandBuffer.delete();
        this.translucencyCommandBuffer.delete();
        this.regionSortingList.delete();
        this.terrainRasterizer.delete();
        this.regionRasterizer.delete();
        this.sectionRasterizer.delete();
        this.temporalRasterizer.delete();
        this.translucencyTerrainRasterizer.delete();
        this.regionSectionSorter.delete();
        this.transformationArray.delete();
        this.originOffsetArray.delete();
        if (this.statisticsBuffer != null) {
            this.statisticsBuffer.delete();
        }
    }

    public void addDebugInfo(List<String> info) {
        if (Nvidium.config.statistics_level != StatisticsLoggingLevel.NONE) {
            StringBuilder builder = new StringBuilder();
            builder.append("Statistics: ");
            if (Nvidium.config.statistics_level.ordinal() >= StatisticsLoggingLevel.FRUSTUM.ordinal()) {
                builder.append("F: ").append(this.stats.frustumCount);
            }
            if (Nvidium.config.statistics_level.ordinal() >= StatisticsLoggingLevel.REGIONS.ordinal()) {
                builder.append(", R: ").append(this.stats.regionCount);
            }
            if (Nvidium.config.statistics_level.ordinal() >= StatisticsLoggingLevel.SECTIONS.ordinal()) {
                builder.append(", S: ").append(this.stats.sectionCount);
            }
            if (Nvidium.config.statistics_level.ordinal() >= StatisticsLoggingLevel.QUADS.ordinal()) {
                builder.append(", Q: ").append(this.stats.quadCount);
            }
            info.addAll(List.of(builder.toString().split("\n")));
        }
    }

    public void reloadShaders() {
        this.compiledForFog = Nvidium.config.render_fog;
        this.terrainRasterizer.delete();
        this.regionRasterizer.delete();
        this.sectionRasterizer.delete();
        this.temporalRasterizer.delete();
        this.translucencyTerrainRasterizer.delete();
        this.regionSectionSorter.delete();
        this.terrainRasterizer = new PrimaryTerrainRasterizer();
        this.regionRasterizer = new RegionRasterizer();
        this.sectionRasterizer = new SectionRasterizer();
        this.temporalRasterizer = new TemporalTerrainRasterizer();
        this.translucencyTerrainRasterizer = new TranslucentTerrainRasterizer();
        this.regionSectionSorter = new SortRegionSectionPhase();
    }

    private static final class Statistics {
        public int frustumCount;
        public int regionCount;
        public int sectionCount;
        public int quadCount;

        private Statistics() {
        }
    }
}

