/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge.parser;

import cc.reconnected.discordbridge.ChatComponents;
import cc.reconnected.discordbridge.Colors;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.class_2561;

public class MentionNodeParser
implements NodeParser {
    public static final Pattern mentionPattern = Pattern.compile("(<@[!&]?\\d+>|<#\\d+>)");
    public static final Pattern integerPattern = Pattern.compile("\\d+");
    private Message message;

    public MentionNodeParser(Message message) {
        this.message = message;
    }

    public List<TextNode> parseMentions() {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        String messageContent = this.message.getContentRaw();
        List<String> splitContent = MentionNodeParser.splitMessage(messageContent);
        List memberMentions = this.message.getMentions().getMembers();
        List roleMentions = this.message.getMentions().getRoles();
        for (String part : splitContent) {
            if (part.matches(mentionPattern.pattern())) {
                Matcher matcher = integerPattern.matcher(part);
                if (matcher.find()) {
                    String snowflakeId = matcher.group();
                    if (part.startsWith("<@&")) {
                        Optional<Role> mentionedRoleOpt = roleMentions.stream().filter(p -> p.getId().equals(snowflakeId)).findFirst();
                        if (mentionedRoleOpt.isPresent()) {
                            Role mentionedRole = mentionedRoleOpt.get();
                            int color = mentionedRole.getColorRaw();
                            if (color == 0) {
                                color = 10070709;
                            }
                            list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser(mentionedRole.getName(), mentionedRole.getAsMention() + ": ", color, ChatComponents.mentionIcon)));
                            continue;
                        }
                        list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser("unknown-role", String.format("<@&%s>: ", snowflakeId), NamedTextColor.WHITE.value(), ChatComponents.mentionIcon)));
                        continue;
                    }
                    if (part.startsWith("<@") || part.startsWith("<@!")) {
                        Optional<Member> mentionedOpt = memberMentions.stream().filter(p -> p.getId().equals(snowflakeId)).findFirst();
                        if (mentionedOpt.isPresent()) {
                            Member mentioned = mentionedOpt.get();
                            list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser(mentioned.getEffectiveName(), mentioned.getAsMention() + ": ", Colors.MENTION.value(), ChatComponents.mentionIcon)));
                            continue;
                        }
                        list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser("unknown-user", String.format("<@%s>: ", snowflakeId), Colors.MENTION.value(), ChatComponents.mentionIcon)));
                        continue;
                    }
                    if (!part.startsWith("<#")) continue;
                    GuildChannel mentionedChannel = this.message.getJDA().getGuildChannelById(snowflakeId);
                    if (mentionedChannel != null && ChannelType.guildTypes().contains(mentionedChannel.getType())) {
                        list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser(mentionedChannel.getName(), mentionedChannel.getAsMention() + ": ", Colors.MENTION.value(), ChatComponents.channelIcon)));
                        continue;
                    }
                    list.add(MentionNodeParser.toTextNode(ChatComponents.makeUser("unknown", String.format("<#%s>: ", snowflakeId), Colors.MENTION.value(), ChatComponents.channelIcon)));
                    continue;
                }
                list.add(TextNode.of((String)part));
                continue;
            }
            list.add(TextNode.of((String)part));
        }
        return list;
    }

    public TextNode[] parseNodes(TextNode input) {
        return this.parseMentions().toArray(new TextNode[0]);
    }

    public static List<String> splitMessage(String message) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = mentionPattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                parts.add(message.substring(lastEnd, matcher.start()));
            }
            parts.add(matcher.group(1));
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            parts.add(message.substring(lastEnd));
        }
        return parts;
    }

    private static TextNode toTextNode(class_2561 text) {
        return TextNode.convert((class_2561)text);
    }

    private static TextNode toTextNode(Component component) {
        return TextNode.convert((class_2561)ChatComponents.toText(component));
    }
}

