/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.peripherals.prints.printer;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.sc3.library.ext.BoxExtKt;
import io.sc3.peripherals.config.ScPeripheralsConfig;
import io.sc3.peripherals.prints.PrintData;
import io.sc3.peripherals.prints.Shape;
import io.sc3.peripherals.prints.Shapes;
import io.sc3.peripherals.prints.printer.PrinterBlockEntity;
import io.sc3.peripherals.util.InventoryPeripheral;
import io.sc3.peripherals.util.LuaTableExtKt;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u000f\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005Ji\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00132\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0016H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b!\u0010\u001dJ\u0019\u0010$\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020(H\u0007\u00a2\u0006\u0004\b+\u0010*J\u0011\u0010,\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b0\u0010/J\u000f\u00101\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b1\u0010/J\u000f\u00102\u001a\u00020(H\u0007\u00a2\u0006\u0004\b2\u0010*J\u000f\u00103\u001a\u00020(H\u0007\u00a2\u0006\u0004\b3\u0010*J\u000f\u00104\u001a\u00020(H\u0007\u00a2\u0006\u0004\b4\u0010*J\u000f\u00105\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b5\u00106J\u0011\u00107\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b7\u0010-J\u000f\u00108\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b8\u0010-J\u000f\u00109\u001a\u00020(H\u0007\u00a2\u0006\u0004\b9\u0010*J\u000f\u0010:\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010A\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010E\u001a\u00020\u00132\u0006\u0010D\u001a\u00020CH\u0007\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010H\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\bH\u0010IJ\u0017\u0010K\u001a\u00020\u00132\u0006\u0010J\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\bK\u0010IJ9\u0010P\u001a\u00020\u00132\f\u0010M\u001a\b\u0012\u0004\u0012\u00020L0\r2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020L0\r2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020L0\rH\u0007\u00a2\u0006\u0004\bP\u0010QJ\u001f\u0010T\u001a\u00020\u00132\u0006\u0010R\u001a\u00020\u00102\u0006\u0010S\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\bT\u0010BJ\u0017\u0010U\u001a\u00020\u00132\u0006\u0010D\u001a\u00020CH\u0007\u00a2\u0006\u0004\bU\u0010FJ\u000f\u0010V\u001a\u00020(H\u0007\u00a2\u0006\u0004\bV\u0010*J\u000f\u0010W\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\bW\u0010;R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010X\u001a\u0004\bY\u00106\u00a8\u0006["}, d2={"Lio/sc3/peripherals/prints/printer/PrinterPeripheral;", "Lio/sc3/peripherals/util/InventoryPeripheral;", "Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;", "be", "<init>", "(Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;)V", "", "minX", "minY", "minZ", "maxX", "maxY", "maxZ", "Ljava/util/Optional;", "", "texture", "", "state", "tint", "", "addShape", "(IIIIIILjava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;)V", "", "shapes", "addShapes", "(Ljava/util/Map;)V", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "attach", "(Ldan200/computercraft/api/peripheral/IComputerAccess;)V", "count", "commit", "(I)Z", "detach", "Ldan200/computercraft/api/peripheral/IPeripheral;", "other", "equals", "(Ldan200/computercraft/api/peripheral/IPeripheral;)Z", "getButtonMode", "()Z", "Ldan200/computercraft/api/lua/MethodResult;", "getChameliumLevel", "()Ldan200/computercraft/api/lua/MethodResult;", "getInkLevel", "getLabel", "()Ljava/lang/String;", "getLightLevel", "()I", "getMaxShapeCount", "getRedstoneLevel", "getSeatPos", "getShapeCount", "getStateLighting", "getTarget", "()Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;", "getTooltip", "getType", "isCollidable", "reset", "()V", "isButton", "setButtonMode", "(Z)V", "collideWhenOff", "collideWhenOn", "setCollidable", "(ZZ)V", "Ldan200/computercraft/api/lua/IArguments;", "args", "setLabel", "(Ldan200/computercraft/api/lua/IArguments;)V", "lightLevel", "setLightLevel", "(I)V", "redstoneLevel", "setRedstoneLevel", "", "x", "y", "z", "setSeatPos", "(Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;)V", "lightWhenOff", "lightWhenOn", "setStateLighting", "setTooltip", "status", "stop", "Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;", "getBe", "Companion", "sc-peripherals"})
@SourceDebugExtension(value={"SMAP\nPrinterPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrinterPeripheral.kt\nio/sc3/peripherals/prints/printer/PrinterPeripheral\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,240:1\n1#2:241\n215#3,2:242\n*S KotlinDebug\n*F\n+ 1 PrinterPeripheral.kt\nio/sc3/peripherals/prints/printer/PrinterPeripheral\n*L\n155#1:242,2\n*E\n"})
public final class PrinterPeripheral
extends InventoryPeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrinterBlockEntity be;
    @NotNull
    private static final String printStatusEvent = "3d_printer_state";
    @NotNull
    private static final String printCompleteEvent = "3d_printer_complete";
    private static final int maxBaseLightLevel;
    private static final int maxShapes;

    public PrinterPeripheral(@NotNull PrinterBlockEntity be2) {
        Intrinsics.checkNotNullParameter((Object)be2, (String)"be");
        super(be2);
        this.be = be2;
    }

    @NotNull
    public final PrinterBlockEntity getBe() {
        return this.be;
    }

    @NotNull
    public String getType() {
        return "3d_printer";
    }

    @NotNull
    public PrinterBlockEntity getTarget() {
        return this.be;
    }

    @LuaFunction(mainThread=true)
    public final void reset() {
        this.be.setData(new PrintData(null, null, false, false, false, false, false, 0, 0, false, false, null, null, null, 16383, null));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getLabel() {
        return this.be.getData().getLabel();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    public final void setLabel(@NotNull IArguments args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        PrintData printData2 = this.be.getData();
        String string2 = PrinterPeripheral.Companion.optUtf8String(args, 0);
        if (string2 != null) {
            void it;
            String string3 = string2;
            PrintData printData3 = printData2;
            boolean bl = false;
            string = PrintData.Companion.sanitiseLabel((String)it);
            printData2 = printData3;
        } else {
            string = null;
        }
        printData2.setLabel(string);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getTooltip() {
        return this.be.getData().getTooltip();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    public final void setTooltip(@NotNull IArguments args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        PrintData printData2 = this.be.getData();
        String string2 = PrinterPeripheral.Companion.optUtf8String(args, 0);
        if (string2 != null) {
            void it;
            String string3 = string2;
            PrintData printData3 = printData2;
            boolean bl = false;
            string = PrintData.Companion.sanitiseTooltip((String)it);
            printData2 = printData3;
        } else {
            string = null;
        }
        printData2.setTooltip(string);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    public final int getLightLevel() {
        return this.be.getData().getLightLevel();
    }

    @LuaFunction(mainThread=true)
    public final void setLightLevel(int lightLevel) {
        this.be.getData().setLightLevel(RangesKt.coerceIn((int)lightLevel, (int)0, (int)maxBaseLightLevel));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    public final int getRedstoneLevel() {
        return this.be.getData().getRedstoneLevel();
    }

    @LuaFunction(mainThread=true)
    public final void setRedstoneLevel(int redstoneLevel) {
        this.be.getData().setRedstoneLevel(RangesKt.coerceIn((int)redstoneLevel, (int)0, (int)15));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    public final boolean getButtonMode() {
        return this.be.getData().isButton();
    }

    @LuaFunction(mainThread=true)
    public final void setButtonMode(boolean isButton) {
        this.be.getData().setButton(isButton);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult isCollidable() {
        Object[] objectArray = new Object[]{this.be.getData().getCollideWhenOff(), this.be.getData().getCollideWhenOn()};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    public final void setCollidable(boolean collideWhenOff, boolean collideWhenOn) {
        this.be.getData().setCollideWhenOff(collideWhenOff);
        this.be.getData().setCollideWhenOn(collideWhenOn);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getStateLighting() {
        Object[] objectArray = new Object[]{this.be.getData().getLightWhenOff(), this.be.getData().getLightWhenOn()};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    public final void setStateLighting(boolean lightWhenOff, boolean lightWhenOn) {
        this.be.getData().setLightWhenOff(lightWhenOff);
        this.be.getData().setLightWhenOn(lightWhenOn);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getSeatPos() {
        MethodResult methodResult;
        MethodResult methodResult2;
        class_243 class_2432 = this.be.getData().getSeatPos();
        if (class_2432 != null) {
            class_243 it = class_2432;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.field_1352, it.field_1351, it.field_1350};
            methodResult2 = MethodResult.of((Object[])objectArray);
        } else {
            methodResult2 = methodResult = null;
        }
        if (methodResult2 == null) {
            Object[] objectArray = new Object[]{null, null, null};
            MethodResult methodResult3 = MethodResult.of((Object[])objectArray);
            methodResult = methodResult3;
            Intrinsics.checkNotNullExpressionValue((Object)methodResult3, (String)"of(...)");
        }
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    public final void setSeatPos(@NotNull Optional<Double> x, @NotNull Optional<Double> y, @NotNull Optional<Double> z) {
        class_243 class_2432;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        Intrinsics.checkNotNullParameter(z, (String)"z");
        if (x.isPresent() && y.isPresent() && z.isPresent()) {
            class_243 class_2433;
            Double d = x.orElse(0.5);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"orElse(...)");
            double d2 = ((Number)d).doubleValue();
            Double d3 = y.orElse(0.5);
            Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"orElse(...)");
            double d4 = ((Number)d3).doubleValue();
            Double d5 = z.orElse(0.5);
            Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"orElse(...)");
            class_243 it = class_2433 = new class_243(d2, d4, ((Number)d5).doubleValue());
            boolean bl = false;
            if (!PrintData.Companion.isValidSeatPos(it)) {
                throw new LuaException("Seat position must be between 0.1 and 0.9 on all axes");
            }
            class_2432 = class_2433;
        } else {
            class_2432 = null;
        }
        class_243 pos = class_2432;
        this.be.getData().setSeatPos(pos);
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getShapeCount() {
        Object[] objectArray = new Object[]{this.be.getData().getShapesOff().size(), this.be.getData().getShapesOn().size()};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction
    public final int getMaxShapeCount() {
        return maxShapes;
    }

    @LuaFunction(mainThread=true)
    public final void addShape(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @NotNull Optional<String> texture, @NotNull Optional<Boolean> state, @NotNull Optional<Integer> tint) {
        class_2960 class_29602;
        Intrinsics.checkNotNullParameter(texture, (String)"texture");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter(tint, (String)"tint");
        if (this.be.getData().getShapesOff().size() >= maxShapes || this.be.getData().getShapesOn().size() >= maxShapes) {
            throw new LuaException("Too many shapes");
        }
        class_238 box = BoxExtKt.intBox((int)RangesKt.coerceIn((int)minX, (int)0, (int)16), (int)RangesKt.coerceIn((int)minY, (int)0, (int)16), (int)RangesKt.coerceIn((int)minZ, (int)0, (int)16), (int)RangesKt.coerceIn((int)maxX, (int)0, (int)16), (int)RangesKt.coerceIn((int)maxY, (int)0, (int)16), (int)RangesKt.coerceIn((int)maxZ, (int)0, (int)16));
        if (box.method_17939() <= 0.0 || box.method_17940() <= 0.0 || box.method_17941() <= 0.0) {
            throw new LuaException("Empty block");
        }
        String string = texture.orElse(null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            class_29602 = ((CharSequence)it).length() > 0 ? new class_2960(StringsKt.take((String)it, (int)64)) : null;
        } else {
            class_29602 = null;
        }
        class_2960 textureId = class_29602;
        int fixedTint = ((Number)tint.orElse(0xFFFFFF)).intValue() & 0xFFFFFF;
        Boolean bl = state.orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        Shapes shapes = bl != false ? this.be.getData().getShapesOn() : this.be.getData().getShapesOff();
        shapes.add(new Shape(box, textureId, fixedTint));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    public final void addShapes(@NotNull Map<?, ?> shapes) {
        Intrinsics.checkNotNullParameter(shapes, (String)"shapes");
        Map<?, ?> $this$forEach$iv = shapes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            double d;
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> entry = element$iv = iterator.next();
            boolean bl = false;
            Object i2 = entry.getKey();
            Object shape = entry.getValue();
            if (!(i2 instanceof Double) || !(!Double.isInfinite(d = ((Number)i2).doubleValue()) && !Double.isNaN(d))) {
                throw new LuaException("Invalid shape table");
            }
            if (!(shape instanceof Map)) {
                LuaException luaException = LuaValues.badTableItem((int)((int)((Number)i2).doubleValue()), (String)"table", (String)LuaValues.getType(shape));
                Intrinsics.checkNotNullExpressionValue((Object)luaException, (String)"badTableItem(...)");
                throw (Throwable)luaException;
            }
            if (((Map)shape).get("texture") != null) {
                Object it;
                boolean bl2 = false;
                string = it instanceof String ? (String)it : null;
                if (string == null) {
                    LuaException luaException = LuaValues.badField((String)"texture", (String)"string", (String)LuaValues.getType(it));
                    Intrinsics.checkNotNullExpressionValue((Object)luaException, (String)"badField(...)");
                    throw (Throwable)luaException;
                }
            } else {
                string = null;
            }
            String texture = string;
            int n = LuaTableExtKt.getTableInt((Map)shape, 1);
            int n2 = LuaTableExtKt.getTableInt((Map)shape, 2);
            int n3 = LuaTableExtKt.getTableInt((Map)shape, 3);
            int n4 = LuaTableExtKt.getTableInt((Map)shape, 4);
            int n5 = LuaTableExtKt.getTableInt((Map)shape, 5);
            int n6 = LuaTableExtKt.getTableInt((Map)shape, 6);
            Optional<String> optional = Optional.ofNullable(texture);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            Object v = ((Map)shape).get("state");
            Boolean bl3 = v instanceof Boolean ? (Boolean)v : null;
            Optional<Boolean> optional2 = Optional.of(bl3 != null ? bl3 : false);
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
            Optional<Integer> optional3 = ((Map)shape).containsKey("tint") ? Optional.of(LuaTableExtKt.getTableInt((Map)shape, "tint")) : Optional.empty();
            Intrinsics.checkNotNull(optional3);
            this.addShape(n, n2, n3, n4, n5, n6, optional, optional2, optional3);
        }
    }

    @LuaFunction(mainThread=true)
    public final boolean commit(int count) {
        boolean bl;
        if (!this.be.getCanPrint()) {
            throw new LuaException("Model is invalid");
        }
        this.be.setPrintCount(RangesKt.coerceIn((int)count, (int)0, (int)Integer.MAX_VALUE));
        boolean it = bl = this.be.getPrintCount() > 0;
        boolean bl2 = false;
        this.be.setPrinting(it);
        return bl;
    }

    @LuaFunction(mainThread=true)
    public final void stop() {
        this.be.setPrintCount(0);
        this.be.setPrinting(false);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult status() {
        Pair<String, Object> pair = Companion.printerStatus(this.be);
        String status = (String)pair.component1();
        Object progress = pair.component2();
        Object[] objectArray = new Object[]{status, progress};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getChameliumLevel() {
        Object[] objectArray = new Object[]{this.be.getChamelium(), 256000};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getInkLevel() {
        Object[] objectArray = new Object[]{this.be.getInk(), 100000};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    public void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.be.getComputers().add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.be.getComputers().remove(computer);
    }

    public boolean equals(@Nullable IPeripheral other) {
        return Intrinsics.areEqual((Object)this, (Object)other);
    }

    static {
        Object object = ScPeripheralsConfig.INSTANCE.getConfig$sc_peripherals().get("printer.max_base_light_level");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        maxBaseLightLevel = ((Number)object).intValue();
        Object object2 = ScPeripheralsConfig.INSTANCE.getConfig$sc_peripherals().get("printer.max_shapes");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        maxShapes = ((Number)object2).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\fJ\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u0007*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lio/sc3/peripherals/prints/printer/PrinterPeripheral$Companion;", "", "<init>", "()V", "Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;", "be", "Lkotlin/Pair;", "", "printerStatus", "(Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;)Lkotlin/Pair;", "", "sendPrintCompleteEvent", "(Lio/sc3/peripherals/prints/printer/PrinterBlockEntity;)V", "sendPrintStatusEvent", "Ldan200/computercraft/api/lua/IArguments;", "", "index", "optUtf8String", "(Ldan200/computercraft/api/lua/IArguments;I)Ljava/lang/String;", "maxBaseLightLevel", "I", "getMaxBaseLightLevel", "()I", "maxShapes", "getMaxShapes", "printCompleteEvent", "Ljava/lang/String;", "printStatusEvent", "sc-peripherals"})
    @SourceDebugExtension(value={"SMAP\nPrinterPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrinterPeripheral.kt\nio/sc3/peripherals/prints/printer/PrinterPeripheral$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1855#2,2:241\n1855#2,2:243\n*S KotlinDebug\n*F\n+ 1 PrinterPeripheral.kt\nio/sc3/peripherals/prints/printer/PrinterPeripheral$Companion\n*L\n226#1:241,2\n231#1:243,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaxBaseLightLevel() {
            return maxBaseLightLevel;
        }

        public final int getMaxShapes() {
            return maxShapes;
        }

        @NotNull
        public final Pair<String, Object> printerStatus(@NotNull PrinterBlockEntity be2) {
            Intrinsics.checkNotNullParameter((Object)be2, (String)"be");
            return be2.getPrinting() || be2.getPrintProgress() > 0 ? new Pair((Object)"busy", (Object)be2.getPrintProgress()) : (be2.getCanPrint() ? new Pair((Object)"idle", (Object)true) : new Pair((Object)"idle", (Object)false));
        }

        public final void sendPrintStatusEvent(@NotNull PrinterBlockEntity be2) {
            Intrinsics.checkNotNullParameter((Object)be2, (String)"be");
            String status = (String)this.printerStatus(be2).component1();
            Iterable $this$forEach$iv = be2.getComputers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IComputerAccess it = (IComputerAccess)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{status};
                it.queueEvent(PrinterPeripheral.printStatusEvent, objectArray);
            }
        }

        public final void sendPrintCompleteEvent(@NotNull PrinterBlockEntity be2) {
            Intrinsics.checkNotNullParameter((Object)be2, (String)"be");
            int remaining = be2.getPrintCount();
            Iterable $this$forEach$iv = be2.getComputers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IComputerAccess it = (IComputerAccess)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{remaining};
                it.queueEvent(PrinterPeripheral.printCompleteEvent, objectArray);
            }
        }

        private final String optUtf8String(IArguments $this$optUtf8String, int index) {
            ByteBuffer byteBuffer = $this$optUtf8String.optBytes(index).orElse(null);
            if (byteBuffer == null) {
                return null;
            }
            ByteBuffer buf = byteBuffer;
            return StandardCharsets.UTF_8.decode(buf).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

