/*
 * Decompiled with CFR 0.152.
 */
package ct.pronouns;

import ct.server.CtServer;
import ct.server.database.PlayerData;
import ct.server.database.PlayerTable;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.event.player.PlayerLoadEvent;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pronouns {
    static MinecraftServer server;
    static Logger LOGGER;

    public static void onServerStart(MinecraftServer server) {
        Pronouns.server = server;
        Objects.requireNonNull(TabAPI.getInstance().getEventBus()).register(PlayerLoadEvent.class, event -> {
            TabPlayer tabPlayer = event.getPlayer();
            String pronouns = Pronouns.getPronouns(tabPlayer.getUniqueId());
            if (pronouns == null) {
                return;
            }
            Objects.requireNonNull(TabAPI.getInstance().getTabListFormatManager()).setSuffix(tabPlayer, " [" + pronouns + "]");
        });
    }

    public static Boolean validatePronoun(String pronoun) {
        return Pattern.matches("^(he|him|she|her|it|its|they|them|any|ask|avoid|other)$", pronoun);
    }

    public static String setPronouns(class_2168 player, String pronoun) {
        LOGGER.info("Pronouns command called");
        if (Objects.equals(pronoun, "clear")) {
            Objects.requireNonNull(TabAPI.getInstance().getTabListFormatManager()).setSuffix(TabAPI.getInstance().getPlayer(player.method_9214()), "");
            PlayerTable table = CtServer.getInstance().playerTable();
            PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
            if (pData == null) {
                return "Warning: Player Data Missing, this change will not survive a server restart.";
            }
            pData.pronouns("");
            table.updatePlayerData(pData);
            return "Your pronouns have been cleared";
        }
        if (!Pronouns.validatePronoun(pronoun).booleanValue()) {
            return "The pronouns that you provided are not settable by everyone. Please contact staff if you want these to be added manually.";
        }
        Objects.requireNonNull(TabAPI.getInstance().getTabListFormatManager()).setSuffix(TabAPI.getInstance().getPlayer(player.method_9214()), " [" + pronoun + "]");
        PlayerTable table = CtServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
        if (pData == null) {
            return "Warning: Player Data Missing, this change will not survive a server restart.";
        }
        pData.pronouns(pronoun);
        table.updatePlayerData(pData);
        return "Your pronouns have been updated";
    }

    public static String setPronouns(class_2168 player, String pronoun1, String pronoun2) {
        LOGGER.info("Pronouns2 command called");
        if (!Pronouns.validatePronoun(pronoun1).booleanValue() || !Pronouns.validatePronoun(pronoun2).booleanValue()) {
            return "The pronouns that you provided are not settable by everyone. Please contact staff if you want these to be added manually.";
        }
        Objects.requireNonNull(TabAPI.getInstance().getTabListFormatManager()).setSuffix(TabAPI.getInstance().getPlayer(player.method_9214()), "&7[&r" + pronoun1 + "/" + pronoun2 + "&7]&r");
        PlayerTable table = CtServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player.method_44023()).method_5667());
        if (pData == null) {
            return "Warning: Player Data Missing, this change will not survive a server restart.";
        }
        pData.pronouns(pronoun1 + "/" + pronoun2);
        table.updatePlayerData(pData);
        return "Your pronouns have been updated";
    }

    public static String getPronouns(UUID player) {
        PlayerTable table = CtServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(player);
        if (pData == null) {
            return null;
        }
        return pData.pronouns();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"ct-pronouns");
    }
}

