/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus;

import cc.tweaked.prometheus.Config;
import cc.tweaked.prometheus.MetricContext;
import cc.tweaked.prometheus.collectors.ComputerCollector;
import cc.tweaked.prometheus.collectors.ComputerFieldCollector;
import cc.tweaked.prometheus.collectors.ThreadGroupCollector;
import cc.tweaked.prometheus.collectors.VanillaCollector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMetrics.class);
    private static HTTPServer server;
    private static List<Runnable> toTick;

    private ServerMetrics() {
    }

    public static void onServerStart(MinecraftServer server, Config config) {
        CollectorRegistry collectorRegistry = new CollectorRegistry(true);
        toTick = new ArrayList<Runnable>();
        ArrayList<Runnable> ticking = toTick;
        MetricContext registry = new MetricContext(server, collectorRegistry, ticking::add);
        if (ServerMetrics.classExists("dan200.computercraft.api.ComputerCraftAPI")) {
            ComputerCollector.register(registry);
            ComputerFieldCollector.register(registry);
            ThreadGroupCollector.register(registry);
        }
        if (config.vanilla()) {
            VanillaCollector.export(registry);
        }
        if (config.jvm()) {
            DefaultExports.register((CollectorRegistry)collectorRegistry);
        }
        if (!collectorRegistry.metricFamilySamples().hasMoreElements()) {
            LOG.warn("Warning: no collectors are enabled! Check the configuration.");
        }
        try {
            ServerMetrics.server = new HTTPServer.Builder().withHostname(config.host()).withPort(config.port()).withDaemonThreads(true).withRegistry(collectorRegistry).build();
            LOG.info("Serving Prometheus metrics on http://{}:{}", (Object)config.host(), (Object)config.port());
        }
        catch (IOException e) {
            LOG.error("Failed to start HTTP server", (Throwable)e);
            ServerMetrics.server = null;
        }
    }

    public static void onServerStop() {
        if (server != null) {
            server.close();
        }
        server = null;
        toTick = null;
        LOG.info("Server stopped, no longer hosting metrics");
    }

    public static void onServerTick() {
        for (Runnable action : toTick) {
            action.run();
        }
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name, false, ServerMetrics.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

