/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus.collectors;

import cc.tweaked.prometheus.MetricContext;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class VanillaCollector {
    private static final String NAMESPACE = "minecraft";

    public static void export(MetricContext context) {
        MinecraftServer server = context.server();
        Gauge averageTickTime = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace(NAMESPACE)).name("average_tick_time")).unit("s")).help("The average tick time as defined by the MC server")).register(context.registry());
        Histogram tickTime = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace(NAMESPACE)).name("tick_time")).unit("s")).buckets(new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0}).help("The average tick time as defined by the MC server")).register(context.registry());
        Gauge playerCount = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace(NAMESPACE)).name("players")).unit("count")).help("The number of players in each dimension.")).labelNames(new String[]{"dimension"})).register(context.registry());
        Gauge totalPlayerCount = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace(NAMESPACE)).name("total_players")).unit("count")).help("The number of players on the server.")).register(context.registry());
        Gauge chunksLoaded = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace(NAMESPACE)).name("chunks_loaded")).unit("count")).help("The number of chunks loaded in each dimension.")).labelNames(new String[]{"dimension"})).register(context.registry());
        context.onTick(() -> {
            for (class_3218 level : server.method_3738()) {
                String name = level.method_27983().method_29177().toString();
                ((Gauge.Child)playerCount.labels(new String[]{name})).set((double)level.method_18456().size());
                ((Gauge.Child)chunksLoaded.labels(new String[]{name})).set((double)level.method_14178().method_14151());
            }
            totalPlayerCount.set((double)server.method_3788());
        });
        ((MinecraftServerTimings)server).prometheus$setTimingObserver((time, averageTime) -> {
            averageTickTime.set((double)averageTime * 0.001);
            tickTime.observe((double)time * 1.0E-9);
        });
    }

    public static interface MinecraftServerTimings {
        public void prometheus$setTimingObserver(TimingObserver var1);
    }

    public static interface TimingObserver {
        public void onServerTick(long var1, float var3);
    }
}

