/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.rccWebApi;

import cc.reconnected.rccWebApi.RccWebApi;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.server.MinecraftServer;

public class HttpApiServer {
    private static HttpApiServer instance;
    private static float currentTps;
    private static float currentMspt;
    private static int currentPlayerCount;
    private final HttpServer server;

    public static HttpApiServer getInstance() {
        return instance;
    }

    public static void register() {
        if (!RccWebApi.CONFIG.enableHttpApi) {
            return;
        }
        try {
            instance = new HttpApiServer();
        }
        catch (IOException e) {
            RccWebApi.LOGGER.error("Could not start HTTP API server", (Throwable)e);
            return;
        }
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            RccWebApi.LOGGER.info("Starting HTTP API server on {}", (Object)instance.httpServer().getAddress().toString());
            instance.httpServer().start();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            RccWebApi.LOGGER.info("Stopping HTTP services");
            instance.httpServer().stop(0);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            currentMspt = server.method_3830();
            if (currentMspt != 0.0f) {
                currentTps = Math.min(20.0f, 1000.0f / currentMspt);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> instance.updatePlayerCount(server));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> instance.updatePlayerCount(server));
    }

    private void updatePlayerCount(MinecraftServer server) {
        RccWebApi.schedule(() -> {
            currentPlayerCount = server.method_3788();
        });
    }

    public HttpServer httpServer() {
        return this.server;
    }

    private HttpApiServer() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(RccWebApi.CONFIG.httpPort), 0);
        this.server.createContext("/tps", new TPSHandler());
        this.server.createContext("/mspt", new MSPTHandler());
        this.server.createContext("/players", new PlayerCountHandler());
        this.server.setExecutor(null);
    }

    static {
        currentTps = 0.0f;
        currentMspt = 0.0f;
        currentPlayerCount = 0;
    }

    static class TPSHandler
    implements HttpHandler {
        TPSHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(currentTps);
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }

    static class MSPTHandler
    implements HttpHandler {
        MSPTHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String mspt = String.valueOf(currentMspt);
            t.sendResponseHeaders(200, mspt.length());
            OutputStream body = t.getResponseBody();
            body.write(mspt.getBytes());
            body.close();
        }
    }

    static class PlayerCountHandler
    implements HttpHandler {
        PlayerCountHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String count = String.valueOf(currentPlayerCount);
            t.sendResponseHeaders(200, count.length());
            OutputStream body = t.getResponseBody();
            body.write(count.getBytes());
            body.close();
        }
    }
}

