/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.rccWebApi;

import cc.reconnected.library.config.ConfigManager;
import cc.reconnected.rccWebApi.HttpApiServer;
import cc.reconnected.rccWebApi.RccWebApiConfig;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccWebApi
implements ModInitializer {
    public static final String MOD_ID = "rcc-webapi";
    public static RccWebApiConfig CONFIG;
    public static Logger LOGGER;
    private static final ConcurrentLinkedQueue<Runnable> tickQueue;

    public void onInitialize() {
        try {
            RccWebApi.loadConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpApiServer.register();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            tickQueue.forEach(Runnable::run);
            tickQueue.clear();
        });
    }

    public static void loadConfig() throws IOException {
        CONFIG = (RccWebApiConfig)ConfigManager.load(RccWebApiConfig.class);
    }

    public static void schedule(Runnable runnable) {
        tickQueue.add(runnable);
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        tickQueue = new ConcurrentLinkedQueue();
    }
}

