/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials;

import cc.reconnected.essentials.RccEssentialsConfig;
import cc.reconnected.essentials.api.events.WorldSave;
import cc.reconnected.essentials.commands.CommandInitializer;
import cc.reconnected.essentials.core.AfkTracker;
import cc.reconnected.essentials.core.AutoAnnouncements;
import cc.reconnected.essentials.core.AutoRestart;
import cc.reconnected.essentials.core.BackTracker;
import cc.reconnected.essentials.core.BossBarManager;
import cc.reconnected.essentials.core.CommandSpy;
import cc.reconnected.essentials.core.MailManager;
import cc.reconnected.essentials.core.Motd;
import cc.reconnected.essentials.core.MuteManager;
import cc.reconnected.essentials.core.TabList;
import cc.reconnected.essentials.core.TeleportTracker;
import cc.reconnected.essentials.core.customChat.CustomChatMessage;
import cc.reconnected.essentials.data.StateManager;
import cc.reconnected.library.config.ConfigManager;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7471;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccEssentials
implements ModInitializer {
    public static final String MOD_ID = "rcc-essentials";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-essentials");
    public static RccEssentialsConfig CONFIG;
    public static final StateManager state;
    private static RccEssentials INSTANCE;
    public static MinecraftServer server;
    public static ScheduledExecutorService scheduler;
    private volatile FabricServerAudiences adventure;
    public static final class_5321<class_2556> CHAT_TYPE;
    private static boolean warnedAboutUnsignedMessages;

    public static RccEssentials getInstance() {
        return INSTANCE;
    }

    public FabricServerAudiences adventure() {
        FabricServerAudiences ret = this.adventure;
        if (ret == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ret;
    }

    public RccEssentials() {
        INSTANCE = this;
    }

    public void onInitialize() {
        LOGGER.info("Starting RccEssentials");
        try {
            CONFIG = (RccEssentialsConfig)ConfigManager.load(RccEssentialsConfig.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config. Refusing to continue.", (Throwable)e);
            return;
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            RccEssentials.server = server;
            state.register(server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID));
            this.adventure = FabricServerAudiences.of((MinecraftServer)server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.adventure = null;
            scheduler.shutdownNow();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> scheduler.shutdown());
        WorldSave.EVENT.register((server1, suppressLogs, flush, force) -> state.save());
        CommandInitializer.register();
        AfkTracker.register();
        TeleportTracker.register();
        BackTracker.register();
        TabList.register();
        BossBarManager.register();
        AutoRestart.register();
        MailManager.register();
        CommandSpy.register();
        AutoAnnouncements.register();
        Motd.register();
        MuteManager.register();
    }

    public void broadcastComponent(MinecraftServer server, Component message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.sendMessage(message);
        }
    }

    public void broadcast(class_2561 text) {
        server.method_3760().method_43514(text, false);
    }

    public void sendChatAsPlayer(class_3222 player, String message) {
        class_2556 msgType = (class_2556)server.method_30611().method_30530(class_7924.field_41237).method_31140(class_2556.field_11737);
        class_7471 signedMessage = class_7471.method_45098((UUID)player.method_5667(), (String)message);
        class_2556.class_7602 pars = new class_2556.class_7602(msgType, class_2561.method_30163((String)message), class_2561.method_30163((String)message));
        boolean allowed = ((ServerMessageEvents.AllowChatMessage)ServerMessageEvents.ALLOW_CHAT_MESSAGE.invoker()).allowChatMessage(signedMessage, player, pars);
        if (!allowed) {
            return;
        }
        ((ServerMessageEvents.ChatMessage)ServerMessageEvents.CHAT_MESSAGE.invoker()).onChatMessage(signedMessage, player, pars);
        class_2561 formatted = CustomChatMessage.getFormattedMessage(signedMessage, player);
        for (class_3222 pl : server.method_3760().method_14571()) {
            pl.method_43496(formatted);
        }
    }

    public static void warnUnsignedMessages() {
        if (warnedAboutUnsignedMessages) {
            return;
        }
        warnedAboutUnsignedMessages = true;
        LOGGER.warn("!!! --- WARNING --- !!!\nCannot retrieve message sender UUID!\n\nIf you are using FabricProxy-Lite, consider disabling\nthe `hackMessageChain` configuration!\n");
    }

    static {
        state = new StateManager();
        scheduler = Executors.newScheduledThreadPool(1);
        CHAT_TYPE = class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)new class_2960(MOD_ID, "chat"));
        warnedAboutUnsignedMessages = false;
    }
}

