/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.commands.tell;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.util.Components;
import cc.reconnected.library.RccLibrary;
import cc.reconnected.library.text.Placeholder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.HashMap;
import java.util.Map;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.platform.PlayerAdapter;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class TellCommand {
    public static final HashMap<String, String> lastSender = new HashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode messageNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msg").requires(Permissions.require((String)"rcc.command.tell", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9253((String[])playerManager.method_14580(), (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(TellCommand::execute))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tell").redirect((CommandNode)messageNode));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"w").redirect((CommandNode)messageNode));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"dm").redirect((CommandNode)messageNode));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String targetName = StringArgumentType.getString(context, (String)"player");
        String message = StringArgumentType.getString(context, (String)"message");
        TellCommand.sendDirectMessage(targetName, source, message);
        return 1;
    }

    public static void sendDirectMessage(String targetName, class_2168 source, String message) {
        class_2561 targetDisplayName;
        class_3222 targetPlayer = null;
        if (targetName.equalsIgnoreCase("server")) {
            targetDisplayName = class_2561.method_30163((String)"Server");
        } else {
            targetPlayer = source.method_9211().method_3760().method_14566(targetName);
            if (targetPlayer == null) {
                Map<String, class_2561> placeholders = Map.of("targetPlayer", class_2561.method_30163((String)targetName));
                PlaceholderContext sourceContext = PlaceholderContext.of((class_2168)source);
                source.method_9226(() -> Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.playerNotFound, (PlaceholderContext)sourceContext, (Map)placeholders), false);
                return;
            }
            targetDisplayName = targetPlayer.method_5476();
        }
        class_2561 parsedMessage = Components.chat(message, source);
        PlaceholderContext serverContext = PlaceholderContext.of((MinecraftServer)source.method_9211());
        PlaceholderContext sourceContext = PlaceholderContext.of((class_2168)source);
        PlaceholderContext targetContext = targetPlayer == null ? serverContext : PlaceholderContext.of((class_3222)targetPlayer);
        class_2561 you = Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.you);
        Map<String, class_2561> placeholdersToSource = Map.of("sourcePlayer", you, "targetPlayer", targetDisplayName, "message", parsedMessage);
        Map<String, class_2561> placeholdersToTarget = Map.of("sourcePlayer", source.method_9223(), "targetPlayer", you, "message", parsedMessage);
        Map<String, class_2561> placeholders = Map.of("sourcePlayer", source.method_9223(), "targetPlayer", targetDisplayName, "message", parsedMessage);
        class_2561 sourceText = Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.message, (PlaceholderContext)sourceContext, placeholdersToSource);
        class_2561 targetText = Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.message, (PlaceholderContext)targetContext, placeholdersToTarget);
        class_2561 genericText = Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.message, (PlaceholderContext)serverContext, placeholders);
        class_2561 spyText = Placeholder.parse((String)RccEssentials.CONFIG.textFormats.commands.tell.messageSpy, (PlaceholderContext)serverContext, placeholders);
        lastSender.put(targetName, source.method_9214());
        lastSender.put(source.method_9214(), targetName);
        if (!source.method_9214().equals(targetName)) {
            source.method_45068(sourceText);
        }
        if (targetPlayer != null) {
            targetPlayer.method_43496(targetText);
            if (source.method_43737()) {
                source.method_9211().method_43496(genericText);
            }
        } else {
            source.method_9211().method_43496(targetText);
        }
        LuckPerms lp = RccLibrary.getInstance().luckPerms();
        PlayerAdapter playerAdapter = lp.getPlayerAdapter(class_3222.class);
        source.method_9211().method_3760().method_14571().forEach(player -> {
            String playerName = player.method_7334().getName();
            if (playerName.equals(targetName) || playerName.equals(source.method_9214())) {
                return;
            }
            CachedPermissionData playerPerms = playerAdapter.getPermissionData(player);
            if (playerPerms.checkPermission("rcc.tell.spy").asBoolean()) {
                player.method_43496(spyText);
            }
        });
    }
}

