/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.core;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.api.events.BossBarEvents;
import cc.reconnected.essentials.api.events.RccEvents;
import cc.reconnected.essentials.api.events.RestartEvents;
import cc.reconnected.essentials.core.BossBarManager;
import cc.reconnected.library.event.ReadyEvent;
import cc.reconnected.library.text.Placeholder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AutoRestart {
    private static BossBarManager.TimeBar restartBar = null;
    private static class_3414 sound;
    private static ScheduledFuture<?> currentSchedule;

    public static void register() {
        ReadyEvent.EVENT.register((server, lib) -> {
            if (RccEssentials.CONFIG.autoRestart.enableAutoRestart) {
                AutoRestart.scheduleNextRestart();
            }
        });
        BossBarEvents.PROGRESS.register((timeBar, server) -> {
            if (restartBar == null || !timeBar.getUuid().equals(restartBar.getUuid())) {
                return;
            }
            ArrayList<Integer> notificationTimes = RccEssentials.CONFIG.autoRestart.restartNotifications;
            int remainingSeconds = restartBar.getRemainingSeconds();
            if (notificationTimes.contains(remainingSeconds)) {
                AutoRestart.notifyRestart(server, restartBar);
            }
        });
        BossBarEvents.END.register((timeBar, server) -> {
            if (restartBar == null || !timeBar.getUuid().equals(restartBar.getUuid())) {
                return;
            }
            server.method_3760().method_14571().forEach(player -> player.field_13987.method_14367(Placeholder.parse((String)RccEssentials.CONFIG.autoRestart.restartKickMessage)));
            server.method_3747(false);
        });
        AutoRestart.setup();
        RccEvents.RELOAD.register(instance -> AutoRestart.setup());
    }

    private static void setup() {
        String soundName = RccEssentials.CONFIG.autoRestart.restartSound;
        class_2960 id = class_2960.method_12829((String)soundName);
        if (id == null) {
            RccEssentials.LOGGER.error("Invalid restart notification sound name {}", (Object)soundName);
            sound = (class_3414)class_3417.field_14793.comp_349();
        }
        sound = class_3414.method_47908((class_2960)id);
    }

    public static void schedule(int seconds, String message) {
        restartBar = BossBarManager.getInstance().startTimeBar(message, seconds, class_1259.class_1260.field_5784, class_1259.class_1261.field_5790, true);
        ((RestartEvents.Schedule)RestartEvents.SCHEDULED.invoker()).onSchedule(restartBar);
    }

    public static boolean isScheduled() {
        return restartBar != null || currentSchedule != null && !currentSchedule.isCancelled();
    }

    public static void cancel() {
        if (restartBar != null) {
            BossBarManager.getInstance().cancelTimeBar(restartBar);
            ((RestartEvents.Cancel)RestartEvents.CANCELED.invoker()).onCancel(restartBar);
            restartBar = null;
        }
        if (currentSchedule != null) {
            currentSchedule.cancel(false);
            currentSchedule = null;
        }
    }

    private static void notifyRestart(MinecraftServer server, BossBarManager.TimeBar bar) {
        RccEssentials rcc = RccEssentials.getInstance();
        class_2561 text = bar.parseLabel(RccEssentials.CONFIG.autoRestart.restartChatMessage);
        rcc.broadcast(text);
        float pitch = RccEssentials.CONFIG.autoRestart.restartSoundPitch;
        server.method_3760().method_14571().forEach(player -> player.method_17356(sound, class_3419.field_15250, 1.0f, pitch));
    }

    @Nullable
    public static Long scheduleNextRestart() {
        Long delay = AutoRestart.getNextDelay();
        if (delay == null) {
            return null;
        }
        int barTime = 600;
        long barStartTime = delay - (long)barTime;
        currentSchedule = RccEssentials.scheduler.schedule(() -> AutoRestart.schedule(barTime, RccEssentials.CONFIG.autoRestart.restartBarLabel), barStartTime, TimeUnit.SECONDS);
        RccEssentials.LOGGER.info("Restart scheduled for in {} seconds", (Object)delay);
        return delay;
    }

    @Nullable
    private static Long getNextDelay() {
        ArrayList<String> restartTimeStrings = RccEssentials.CONFIG.autoRestart.restartAt;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextRunTime = null;
        long shortestDelay = Long.MAX_VALUE;
        for (String timeString : restartTimeStrings) {
            long delay;
            LocalTime targetTime = LocalTime.parse(timeString);
            LocalDateTime targetDateTime = now.with(targetTime);
            if (targetDateTime.isBefore(now)) {
                targetDateTime = targetDateTime.plusDays(1L);
            }
            if ((delay = Duration.between(now, targetDateTime).toSeconds()) >= shortestDelay) continue;
            shortestDelay = delay;
            nextRunTime = targetDateTime;
        }
        if (nextRunTime != null) {
            return shortestDelay;
        }
        return null;
    }

    static {
        currentSchedule = null;
    }
}

