/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.essentials.core;

import cc.reconnected.essentials.RccEssentials;
import cc.reconnected.essentials.api.events.RccEvents;
import cc.reconnected.essentials.util.Components;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TabList {
    private static MinecraftServer server;
    private static final MiniMessage miniMessage;
    private static ScheduledFuture<?> scheduledFuture;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(mcServer -> {
            server = mcServer;
            TabList.schedule();
        });
        RccEvents.RELOAD.register(instance -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            TabList.schedule();
        });
    }

    private static void schedule() {
        if (!RccEssentials.CONFIG.customTabList.enableTabList) {
            return;
        }
        scheduledFuture = RccEssentials.scheduler.scheduleAtFixedRate(TabList::updateTab, 0L, RccEssentials.CONFIG.customTabList.tabListDelay, TimeUnit.MILLISECONDS);
    }

    public static void updateTab() {
        double period = Math.max(RccEssentials.CONFIG.customTabList.tabPhasePeriod, 1.0);
        double phase = (Math.sin((double)server.method_3780() * Math.PI * 2.0 / period) + 1.0) / 2.0;
        server.method_3760().method_14571().forEach(player -> {
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            TextComponent headerComponent = Component.empty();
            for (int i = 0; i < RccEssentials.CONFIG.customTabList.tabHeader.size(); ++i) {
                String line = RccEssentials.CONFIG.customTabList.tabHeader.get(i);
                line = line.replace("{phase}", String.valueOf(phase));
                if (i > 0) {
                    headerComponent = headerComponent.appendNewline();
                }
                headerComponent = headerComponent.append(miniMessage.deserialize((Object)line));
            }
            TextComponent footerComponent = Component.empty();
            for (int i = 0; i < RccEssentials.CONFIG.customTabList.tabFooter.size(); ++i) {
                String line = RccEssentials.CONFIG.customTabList.tabFooter.get(i);
                line = line.replace("{phase}", String.valueOf(phase));
                if (i > 0) {
                    footerComponent = footerComponent.appendNewline();
                }
                footerComponent = footerComponent.append(miniMessage.deserialize((Object)line));
            }
            class_2561 parsedHeader = Placeholders.parseText((class_2561)Components.toText((Component)headerComponent), (PlaceholderContext)playerContext);
            class_2561 parsedFooter = Placeholders.parseText((class_2561)Components.toText((Component)footerComponent), (PlaceholderContext)playerContext);
            Audience audience = RccEssentials.getInstance().adventure().player(player.method_5667());
            audience.sendPlayerListHeaderAndFooter((ComponentLike)parsedHeader, (ComponentLike)parsedFooter);
        });
    }

    static {
        miniMessage = MiniMessage.miniMessage();
        scheduledFuture = null;
    }
}

