/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.database;

import cc.reconnected.server.RccServer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.types.MetaNode;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    public static final String nodePrefix = "rcc";
    private final User lpUser;
    private final UUID uuid;
    @Nullable
    private String name;
    private Set<MetaNode> rawNodes;
    private Map<String, String> nodes;

    private static LuckPerms luckPerms() {
        return RccServer.getInstance().luckPerms();
    }

    private PlayerData(UUID uuid, User lpUser) {
        this.uuid = uuid;
        this.lpUser = lpUser;
        this.refreshNodes();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getUsername() {
        String username = this.get("username");
        if (username == null) {
            return this.name;
        }
        return username;
    }

    public String getEffectiveName() {
        String effName = this.getUsername();
        if (effName == null) {
            return this.uuid.toString();
        }
        return effName;
    }

    public void refreshNodes() {
        this.rawNodes = this.lpUser.getNodes(NodeType.META).parallelStream().filter(node -> node.getMetaKey().startsWith("rcc.")).collect(Collectors.toSet());
        this.nodes = this.rawNodes.stream().collect(Collectors.toMap(MetaNode::getMetaKey, MetaNode::getMetaValue));
    }

    public CompletableFuture<Void> set(String key, @Nullable String value) {
        ScopedNode node = PlayerData.meta(key, value).build();
        return PlayerData.luckPerms().getUserManager().modifyUser(this.uuid, user -> {
            user.data().clear(NodeType.META.predicate(mn -> mn.getMetaKey().equals(key)));
            user.data().add((Node)node);
            this.refreshNodes();
        });
    }

    @Nullable
    public String get(String key) {
        if (!this.nodes.containsKey("rcc." + key)) {
            return null;
        }
        return this.nodes.get("rcc." + key);
    }

    @Nullable
    public MetaNode getNode(String key) {
        return this.rawNodes.stream().filter(rawNode -> rawNode.getMetaKey().equals(key)).findFirst().orElse(null);
    }

    public CompletableFuture<Void> setBoolean(String key, boolean value) {
        return this.set(key, Boolean.toString(value));
    }

    public boolean getBoolean(String key) {
        if (!this.nodes.containsKey("rcc." + key)) {
            return false;
        }
        return Boolean.parseBoolean(this.nodes.get("rcc." + key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (!this.nodes.containsKey("rcc." + key)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.nodes.get("rcc." + key));
    }

    public CompletableFuture<Void> setDate(String key, Date date) {
        String dateString = DateTimeFormatter.ISO_INSTANT.format(date.toInstant());
        return this.set(key, dateString);
    }

    public Date getDate(String key) {
        if (!this.nodes.containsKey("rcc." + key)) {
            return null;
        }
        String dateString = this.nodes.get("rcc." + key);
        TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(dateString);
        return Date.from(Instant.from(ta));
    }

    public CompletableFuture<Void> delete(String key) {
        return PlayerData.luckPerms().getUserManager().modifyUser(this.uuid, user -> user.data().clear(NodeType.META.predicate(mn -> mn.getMetaKey().equals("rcc." + key))));
    }

    public String getPrimaryGroup() {
        return this.lpUser.getPrimaryGroup();
    }

    public static PlayerData getPlayer(UUID uuid) {
        LuckPerms lp = PlayerData.luckPerms();
        UserManager userManager = lp.getUserManager();
        CompletableFuture userFuture = userManager.loadUser(uuid);
        User lpUser = (User)userFuture.join();
        PlayerData playerData = new PlayerData(uuid, lpUser);
        playerData.name = lpUser.getUsername();
        return playerData;
    }

    public static PlayerData getPlayer(class_3222 player) {
        User user = PlayerData.luckPerms().getPlayerAdapter(class_3222.class).getUser((Object)player);
        PlayerData playerData = new PlayerData(player.method_5667(), user);
        playerData.name = player.method_5820();
        return playerData;
    }

    public static NodeBuilder<?, ?> node(String key) {
        return Node.builder((String)("rcc." + key));
    }

    public static NodeBuilder<?, ?> meta(String key, String value) {
        return MetaNode.builder((String)("rcc." + key), (String)value);
    }

    public static class KEYS {
        public static final String username = "username";
        public static final String discordId = "discord_id";
        public static final String isBot = "is_bot";
        public static final String isAlt = "is_alt";
        public static final String pronouns = "pronouns";
        public static final String firstJoinedDate = "first_joined_date";
        public static final String supporterLevel = "supporter_level";
        public static final String activeTime = "active_time";
    }
}

