/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.collections;

import io.sc3.plethora.core.collections.SortedCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class SortedMultimap<K, V> {
    private final Comparator<V> comparator;
    private final HashMap<K, SortedCollection<V>> items = new HashMap();

    public SortedMultimap(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    public void clear() {
        this.items.clear();
    }

    public void put(K key, V value) {
        SortedCollection<V> targetItems = this.items.get(key);
        if (targetItems == null) {
            targetItems = SortedCollection.create(this.comparator);
            this.items.put(key, targetItems);
        }
        targetItems.add(value);
    }

    public Collection<V> get(K key) {
        Collection result = this.items.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    public static <K, V> SortedMultimap<K, V> create(Comparator<V> comparator) {
        return new SortedMultimap<K, V>(comparator);
    }

    public Map<K, Collection<V>> items() {
        return Collections.unmodifiableMap(this.items);
    }

    public int size() {
        int size = 0;
        for (SortedCollection<V> collection : this.items.values()) {
            size += collection.size();
        }
        return size;
    }
}

