/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.neural;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.util.ComponentMap;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.core.executor.TaskRunner;
import io.sc3.plethora.gameplay.neural.NeuralHelpers;
import io.sc3.plethora.gameplay.neural.NeuralPocketAccess;
import io.sc3.plethora.util.Helpers;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001f\u001a\u00020\u001e2\b\b\u0001\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R4\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R \u00100\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R$\u00104\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R8\u0010:\u001a&\u0012\f\u0012\n 9*\u0004\u0018\u00010\u001b0\u001b 9*\u0012\u0012\f\u0012\n 9*\u0004\u0018\u00010\u001b0\u001b\u0018\u000108088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lio/sc3/plethora/gameplay/neural/NeuralComputer;", "Ldan200/computercraft/shared/computer/core/ServerComputer;", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "", "computerId", "", "label", "Ldan200/computercraft/shared/util/ComponentMap;", "baseComponents", "<init>", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;ILjava/lang/String;Ldan200/computercraft/shared/util/ComponentMap;)V", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2487;", "getModuleData", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_2487;", "", "markModuleDataDirty", "()V", "nbt", "readModuleData", "(Lnet/minecraft/class_2487;)V", "Lnet/minecraft/class_1309;", "owner", "Lnet/minecraft/class_1799;", "neuralStack", "dirtyStatus", "", "update", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1799;I)Z", "Lio/sc3/plethora/gameplay/neural/NeuralPocketAccess;", "access", "Lio/sc3/plethora/gameplay/neural/NeuralPocketAccess;", "Ljava/lang/ref/WeakReference;", "<set-?>", "entity", "Ljava/lang/ref/WeakReference;", "getEntity", "()Ljava/lang/ref/WeakReference;", "Lio/sc3/plethora/core/executor/TaskRunner;", "executor", "Lio/sc3/plethora/core/executor/TaskRunner;", "getExecutor", "()Lio/sc3/plethora/core/executor/TaskRunner;", "", "moduleData", "Ljava/util/Map;", "moduleDataDirty", "Z", "moduleHash", "I", "getModuleHash", "()I", "Lnet/minecraft/class_2371;", "kotlin.jvm.PlatformType", "stacks", "Lnet/minecraft/class_2371;", "Plethora-Fabric"})
@SourceDebugExtension(value={"SMAP\nNeuralComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NeuralComputer.kt\nio/sc3/plethora/gameplay/neural/NeuralComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class NeuralComputer
extends ServerComputer {
    @Nullable
    private WeakReference<class_1309> entity;
    private final class_2371<class_1799> stacks;
    private int moduleHash;
    @NotNull
    private final Map<class_2960, class_2487> moduleData;
    private boolean moduleDataDirty;
    @NotNull
    private final TaskRunner executor;
    @NotNull
    private final NeuralPocketAccess access;

    public NeuralComputer(@NotNull class_3218 world, @NotNull class_2338 pos, int computerId, @Nullable String label, @Nullable ComponentMap baseComponents) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(world, pos, computerId, label, ComputerFamily.ADVANCED, 39, 13, baseComponents);
        this.stacks = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
        this.moduleData = new HashMap();
        this.executor = new TaskRunner();
        this.access = new NeuralPocketAccess(this);
    }

    @Nullable
    public final WeakReference<class_1309> getEntity() {
        return this.entity;
    }

    public final int getModuleHash() {
        return this.moduleHash;
    }

    @NotNull
    public final TaskRunner getExecutor() {
        return this.executor;
    }

    public final void readModuleData(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        for (String key : nbt.method_10541()) {
            class_2487 class_24872;
            Map<class_2960, class_2487> map = this.moduleData;
            class_2960 class_29602 = new class_2960(key);
            Intrinsics.checkNotNullExpressionValue((Object)nbt.method_10562(key), (String)"getCompound(...)");
            map.put(class_29602, class_24872);
        }
    }

    @Nullable
    public final class_2487 getModuleData(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        class_2487 nbt = null;
        nbt = this.moduleData.get(id);
        if (nbt == null) {
            class_2487 class_24872;
            Map<class_2960, class_2487> map = this.moduleData;
            class_2487 it = class_24872 = new class_2487();
            boolean bl = false;
            nbt = it;
            map.put(id, class_24872);
        }
        return nbt;
    }

    public final void markModuleDataDirty() {
        this.moduleDataDirty = true;
    }

    public final boolean update(@Nonnull @NotNull class_1309 owner, @Nonnull @NotNull class_1799 neuralStack, int dirtyStatus) {
        int slot;
        class_1309 existing;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)neuralStack, (String)"neuralStack");
        int dirty = dirtyStatus;
        if (this.entity == null) {
            v0 = null;
        } else {
            WeakReference<class_1309> weakReference = this.entity;
            Intrinsics.checkNotNull(weakReference);
            v0 = existing = (class_1309)weakReference.get();
        }
        if (existing != owner) {
            dirty = -1;
            this.entity = owner.method_5805() ? new WeakReference<class_1309>(owner) : null;
        }
        class_1937 class_19372 = owner.method_5770();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
        this.setPosition((class_3218)class_19372, owner.method_24515());
        if (dirty != 0) {
            this.stacks.clear();
            class_1262.method_5429((class_2487)neuralStack.method_7948(), this.stacks);
            this.moduleHash = Helpers.hashStacks(this.stacks.subList(5, 10));
        }
        for (slot = 0; slot < 5; ++slot) {
            IPeripheral peripheral;
            UpgradeData upgrade;
            ComputerSide side;
            Object object = this.stacks.get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            class_1799 stack = (class_1799)object;
            if (stack.method_7960() || PocketUpgrades.instance().get(stack) == null || this.getPeripheral(side = ComputerSide.valueOf((int)(slot < 2 ? slot : slot + 1))) == null) continue;
            ((IPocketUpgrade)upgrade.upgrade()).update((IPocketAccess)this.access, peripheral);
        }
        if (dirty != 0) {
            for (slot = 0; slot < 5; ++slot) {
                if ((dirty & 1 << slot) != 1 << slot) continue;
                try {
                    IPeripheral newPeripheral = NeuralHelpers.buildPeripheral(this.access, (class_1799)this.stacks.get(slot));
                    this.setPeripheral(ComputerSide.valueOf((int)(slot < 2 ? slot : slot + 1)), newPeripheral);
                    continue;
                }
                catch (Exception e) {
                    Plethora.log.error("Failed to build peripheral for slot " + slot, (Throwable)e);
                }
            }
            if (dirty >> 5 != 0) {
                try {
                    this.setPeripheral(ComputerSide.BACK, (IPeripheral)NeuralHelpers.buildModules(this, this.stacks, (class_1297)owner));
                }
                catch (Exception e) {
                    Plethora.log.error("Failed to build peripheral for modules", (Throwable)e);
                }
            }
        }
        this.executor.update();
        if (this.moduleDataDirty) {
            this.moduleDataDirty = false;
            class_2487 nbt = new class_2487();
            for (Map.Entry<class_2960, class_2487> entry : this.moduleData.entrySet()) {
                class_2960 key = entry.getKey();
                class_2487 value = entry.getValue();
                nbt.method_10566(key.toString(), (class_2520)value);
            }
            neuralStack.method_7948().method_10566("module_data", (class_2520)nbt);
            return true;
        }
        return false;
    }
}

