/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.text.pagination;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.sc3.text.TextExtKt;
import io.sc3.text.pagination.ActivePagination;
import io.sc3.text.pagination.IterablePagination;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBa\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018Rh\u0010\u001b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \u001a*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u0005 \u001a**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \u001a*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u0005\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lio/sc3/text/pagination/IterablePagination;", "Lio/sc3/text/pagination/ActivePagination;", "Lnet/minecraft/class_2168;", "src", "", "", "Lnet/minecraft/class_2561;", "", "counts", "title", "header", "footer", "padding", "linesPerPage", "<init>", "(Lnet/minecraft/class_2168;Ljava/lang/Iterable;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;I)V", "page", "", "hasNext", "(I)Z", "hasPrevious", "lines", "(I)Ljava/lang/Iterable;", "totalPages", "()I", "Lcom/google/common/collect/PeekingIterator;", "kotlin.jvm.PlatformType", "countIterator", "Lcom/google/common/collect/PeekingIterator;", "lastPage", "I", "Companion", "sc-text"})
public final class IterablePagination
extends ActivePagination {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final PeekingIterator<Map.Entry<class_2561, Integer>> countIterator;
    private int lastPage;
    @NotNull
    private static final SimpleCommandExceptionType PAGE_END_EXCEPTION = new SimpleCommandExceptionType((Message)TextExtKt.of("End of pagination reached.", new class_124[0]));
    @NotNull
    private static final DynamicCommandExceptionType PAGE_TOO_LOW_EXCEPTION = new DynamicCommandExceptionType(IterablePagination::PAGE_TOO_LOW_EXCEPTION$lambda$1);
    @NotNull
    private static final SimpleCommandExceptionType PAGE_BACKWARDS_EXCEPTION = new SimpleCommandExceptionType((Message)TextExtKt.of("You cannot go to the previous page in this pagination.", new class_124[0]));

    public IterablePagination(@NotNull class_2168 src, @NotNull Iterable<? extends Map.Entry<? extends class_2561, Integer>> counts2, @Nullable class_2561 title, @Nullable class_2561 header, @Nullable class_2561 footer, @NotNull class_2561 padding, int linesPerPage) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(counts2, (String)"counts");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        super(src, title, header, footer, padding, linesPerPage);
        this.countIterator = Iterators.peekingIterator(counts2.iterator());
        this.lastPage = 1;
    }

    public /* synthetic */ IterablePagination(class_2168 class_21682, Iterable iterable, class_2561 class_25612, class_2561 class_25613, class_2561 class_25614, class_2561 class_25615, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            class_25612 = null;
        }
        if ((n2 & 8) != 0) {
            class_25613 = null;
        }
        if ((n2 & 0x10) != 0) {
            class_25614 = null;
        }
        if ((n2 & 0x20) != 0) {
            class_25615 = (class_2561)TextExtKt.of("=", new class_124[0]);
        }
        if ((n2 & 0x40) != 0) {
            n = 20;
        }
        this(class_21682, iterable, class_25612, class_25613, class_25614, class_25615, n);
    }

    @Override
    @NotNull
    public Iterable<class_2561> lines(int page) {
        Map.Entry next;
        if (!this.countIterator.hasNext()) {
            CommandSyntaxException commandSyntaxException = PAGE_END_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        if (page < 1) {
            CommandSyntaxException commandSyntaxException = PAGE_TOO_LOW_EXCEPTION.create((Object)page);
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        if (page < this.lastPage) {
            CommandSyntaxException commandSyntaxException = PAGE_BACKWARDS_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        if (page > this.lastPage + 1) {
            this.lines(page - 1);
        }
        this.lastPage = page;
        if (this.getContentLinesPerPage() <= 0) {
            ArrayList arrayList = Lists.newArrayList((Iterator)Iterators.transform((Iterator)((Iterator)this.countIterator), arg_0 -> IterablePagination.lines$lambda$0(lines.1.INSTANCE, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            return arrayList;
        }
        ArrayList out = new ArrayList(this.getContentLinesPerPage());
        for (int addedLines = 0; addedLines <= this.getContentLinesPerPage(); addedLines += ((Number)next.getValue()).intValue()) {
            if (!this.countIterator.hasNext()) {
                if (page <= 1) break;
                this.padPage(out, addedLines, false);
                break;
            }
            if (addedLines + ((Number)((Map.Entry)this.countIterator.peek()).getValue()).intValue() > this.getContentLinesPerPage()) {
                this.padPage(out, addedLines, true);
                break;
            }
            next = (Map.Entry)this.countIterator.next();
            out.add(next.getKey());
        }
        return out;
    }

    @Override
    public boolean hasPrevious(int page) {
        return false;
    }

    @Override
    public boolean hasNext(int page) {
        return page == this.getCurrentPage() && this.countIterator.hasNext();
    }

    @Override
    public int totalPages() {
        return -1;
    }

    private static final class_2561 lines$lambda$0(Function1 $tmp0, Object input) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (class_2561)$tmp0.invoke(input);
    }

    private static final Message PAGE_TOO_LOW_EXCEPTION$lambda$1(Object it) {
        return (Message)TextExtKt.of("Page " + it + " does not exist.", new class_124[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/sc3/text/pagination/IterablePagination$Companion;", "", "<init>", "()V", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "PAGE_BACKWARDS_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "PAGE_END_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "PAGE_TOO_LOW_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "sc-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

