/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.text.pagination;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.MapMaker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.sc3.text.TextExtKt;
import io.sc3.text.pagination.ActivePagination;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_5242;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0016\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000e0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lio/sc3/text/pagination/PaginationHandler;", "", "<init>", "()V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "", "last", "Lio/sc3/text/pagination/ActivePagination;", "pagination", "(Lcom/mojang/brigadier/context/CommandContext;Z)Lio/sc3/text/pagination/ActivePagination;", "src", "create", "Lio/sc3/text/pagination/PaginationHandler$SourcePaginations;", "paginationState", "(Lnet/minecraft/class_2168;Z)Lio/sc3/text/pagination/PaginationHandler$SourcePaginations;", "Lcom/mojang/brigadier/CommandDispatcher;", "dispatcher", "", "register$sc_text", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "register", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "NO_PAGINATIONS_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "PAGINATION_NOT_FOUND_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "Ljava/util/concurrent/ConcurrentMap;", "activePaginations", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/google/common/cache/Cache;", "Ljava/util/UUID;", "playerPaginations", "Lcom/google/common/cache/Cache;", "SourcePaginations", "sc-text"})
public final class PaginationHandler {
    @NotNull
    public static final PaginationHandler INSTANCE = new PaginationHandler();
    @NotNull
    private static final SimpleCommandExceptionType NO_PAGINATIONS_EXCEPTION = new SimpleCommandExceptionType((Message)TextExtKt.of("No active paginations found.", new class_124[0]));
    @NotNull
    private static final DynamicCommandExceptionType PAGINATION_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(PaginationHandler::PAGINATION_NOT_FOUND_EXCEPTION$lambda$0);
    @NotNull
    private static final ConcurrentMap<class_2168, SourcePaginations> activePaginations;
    @NotNull
    private static final Cache<UUID, SourcePaginations> playerPaginations;

    private PaginationHandler() {
    }

    @NotNull
    public final SourcePaginations paginationState(@NotNull class_2168 src, boolean create) {
        SourcePaginations sourcePaginations;
        UUID uuid;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        class_1297 class_12972 = src.method_9228();
        UUID uUID = uuid = class_12972 != null ? class_12972.method_5667() : null;
        if (src.method_43737() && uuid != null) {
            Object object = playerPaginations.get((Object)uuid, () -> PaginationHandler.paginationState$lambda$1(create));
            Intrinsics.checkNotNull((Object)object);
            sourcePaginations = (SourcePaginations)object;
        } else {
            SourcePaginations existing;
            SourcePaginations out = (SourcePaginations)activePaginations.get(src);
            if (out == null && create && (existing = activePaginations.putIfAbsent(src, out = new SourcePaginations())) != null) {
                out = existing;
            }
            if ((sourcePaginations = out) == null) {
                CommandSyntaxException commandSyntaxException = NO_PAGINATIONS_EXCEPTION.create();
                Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
        }
        return sourcePaginations;
    }

    public final void register$sc_text(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sc-text:pagination").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pagination-id", (ArgumentType)((ArgumentType)class_5242.method_27643())).suggests(PaginationHandler::register$lambda$2).then(class_2170.method_9247((String)"next").executes(PaginationHandler::register$lambda$3))).then(class_2170.method_9247((String)"prev").executes(PaginationHandler::register$lambda$4))).then(class_2170.method_9244((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer())).executes(PaginationHandler::register$lambda$5)))).then(class_2170.method_9247((String)"next").executes(PaginationHandler::register$lambda$6))).then(class_2170.method_9247((String)"prev").executes(PaginationHandler::register$lambda$7))).then(class_2170.method_9244((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer())).executes(PaginationHandler::register$lambda$8)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"pagination").redirect((CommandNode)node));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"page").redirect((CommandNode)node));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sc-text:page").redirect((CommandNode)node));
    }

    private final ActivePagination pagination(CommandContext<class_2168> ctx, boolean last) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        SourcePaginations state = this.paginationState((class_2168)object, false);
        UUID uUID = last ? state.getLastUuid() : class_5242.method_27645(ctx, (String)"pagination-id");
        if (uUID == null) {
            CommandSyntaxException commandSyntaxException = NO_PAGINATIONS_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        UUID id = uUID;
        ActivePagination activePagination = state.pagination(id);
        if (activePagination == null) {
            CommandSyntaxException commandSyntaxException = PAGINATION_NOT_FOUND_EXCEPTION.create((Object)id.toString());
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        return activePagination;
    }

    static /* synthetic */ ActivePagination pagination$default(PaginationHandler paginationHandler, CommandContext commandContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return paginationHandler.pagination((CommandContext<class_2168>)commandContext, bl);
    }

    private static final Message PAGINATION_NOT_FOUND_EXCEPTION$lambda$0(Object it) {
        return (Message)TextExtKt.of("Paginations " + it + " not found.", new class_124[0]);
    }

    private static final SourcePaginations paginationState$lambda$1(boolean $create) {
        return $create ? new SourcePaginations() : null;
    }

    private static final CompletableFuture register$lambda$2(CommandContext ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return class_2172.method_9265((Iterable)INSTANCE.paginationState((class_2168)object, false).keysString(), (SuggestionsBuilder)builder);
    }

    private static final int register$lambda$3(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        PaginationHandler.pagination$default(INSTANCE, it, false, 2, null).nextPage();
        return 1;
    }

    private static final int register$lambda$4(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        PaginationHandler.pagination$default(INSTANCE, it, false, 2, null).previousPage();
        return 1;
    }

    private static final int register$lambda$5(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        PaginationHandler.pagination$default(INSTANCE, it, false, 2, null).specificPage(IntegerArgumentType.getInteger((CommandContext)it, (String)"page"));
        return 1;
    }

    private static final int register$lambda$6(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.pagination((CommandContext<class_2168>)it, true).nextPage();
        return 1;
    }

    private static final int register$lambda$7(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.pagination((CommandContext<class_2168>)it, true).previousPage();
        return 1;
    }

    private static final int register$lambda$8(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.pagination((CommandContext<class_2168>)it, true).specificPage(IntegerArgumentType.getInteger((CommandContext)it, (String)"page"));
        return 1;
    }

    static {
        ConcurrentMap concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        activePaginations = concurrentMap;
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        playerPaginations = cache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/sc3/text/pagination/PaginationHandler$SourcePaginations;", "", "<init>", "()V", "", "Ljava/util/UUID;", "keys", "()Ljava/util/Set;", "", "keysString", "id", "Lio/sc3/text/pagination/ActivePagination;", "pagination", "(Ljava/util/UUID;)Lio/sc3/text/pagination/ActivePagination;", "", "put", "(Lio/sc3/text/pagination/ActivePagination;)V", "lastUuid", "Ljava/util/UUID;", "getLastUuid", "()Ljava/util/UUID;", "setLastUuid", "(Ljava/util/UUID;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "paginations", "Ljava/util/concurrent/ConcurrentHashMap;", "sc-text"})
    @SourceDebugExtension(value={"SMAP\nPaginationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginationHandler.kt\nio/sc3/text/pagination/PaginationHandler$SourcePaginations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n*S KotlinDebug\n*F\n+ 1 PaginationHandler.kt\nio/sc3/text/pagination/PaginationHandler$SourcePaginations\n*L\n92#1:96\n92#1:97,3\n*E\n"})
    public static final class SourcePaginations {
        @NotNull
        private final ConcurrentHashMap<UUID, ActivePagination> paginations = new ConcurrentHashMap();
        @Nullable
        private UUID lastUuid;

        @Nullable
        public final UUID getLastUuid() {
            return this.lastUuid;
        }

        public final void setLastUuid(@Nullable UUID uUID) {
            this.lastUuid = uUID;
        }

        @Nullable
        public final ActivePagination pagination(@NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.paginations.get(id);
        }

        public final void put(@NotNull ActivePagination pagination) {
            Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
            this.paginations.compute(pagination.getId$sc_text(), (arg_0, arg_1) -> SourcePaginations.put$lambda$0((Function2)new Function2<UUID, ActivePagination, ActivePagination>(this, pagination){
                final /* synthetic */ SourcePaginations this$0;
                final /* synthetic */ ActivePagination $pagination;
                {
                    this.this$0 = $receiver;
                    this.$pagination = $pagination;
                    super(2);
                }

                @Nullable
                public final ActivePagination invoke(@NotNull UUID uUID, @Nullable ActivePagination activePagination) {
                    Intrinsics.checkNotNullParameter((Object)uUID, (String)"<anonymous parameter 0>");
                    this.this$0.setLastUuid(this.$pagination.getId$sc_text());
                    return this.$pagination;
                }
            }, arg_0, arg_1));
        }

        @NotNull
        public final Set<UUID> keys() {
            Set set = this.paginations.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            return CollectionsKt.toSet((Iterable)set);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> keysString() {
            void $this$mapTo$iv$iv;
            Set set = this.paginations.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private static final ActivePagination put$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ActivePagination)$tmp0.invoke(p0, p1);
        }
    }
}

