/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.core;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.api.events.BossBarEvents;
import cc.reconnected.server.api.events.RccEvents;
import cc.reconnected.server.api.events.RestartEvents;
import cc.reconnected.server.core.BossBarManager;
import cc.reconnected.server.util.Components;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AutoRestart {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static BossBarManager.TimeBar restartBar = null;
    private static Key notificationKey;
    private static ScheduledFuture<?> currentSchedule;

    public static void register() {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        RccEvents.READY.register((server, luckPerms) -> {
            if (RccServer.CONFIG.autoRestart.enableAutoRestart) {
                AutoRestart.scheduleNextRestart();
            }
        });
        BossBarEvents.PROGRESS.register((timeBar, server) -> {
            if (restartBar == null || !timeBar.getUuid().equals(restartBar.getUuid())) {
                return;
            }
            ArrayList<Integer> notificationTimes = RccServer.CONFIG.autoRestart.restartNotifications;
            int remainingSeconds = restartBar.getRemainingSeconds();
            if (notificationTimes.contains(remainingSeconds)) {
                AutoRestart.notifyRestart(server, restartBar);
            }
        });
        BossBarEvents.END.register((timeBar, server) -> {
            if (restartBar == null || !timeBar.getUuid().equals(restartBar.getUuid())) {
                return;
            }
            class_5250 text = Components.toText(miniMessage.deserialize((Object)RccServer.CONFIG.autoRestart.restartKickMessage));
            server.method_3760().method_14571().forEach(player -> player.field_13987.method_14367((class_2561)text));
            scheduler.shutdownNow();
            server.method_3747(false);
        });
        AutoRestart.setup();
        RccEvents.RELOAD.register(instance -> AutoRestart.setup());
    }

    private static void setup() {
        String soundName = RccServer.CONFIG.autoRestart.restartSound;
        try {
            notificationKey = Key.key((String)soundName);
        }
        catch (InvalidKeyException e) {
            RccServer.LOGGER.error("Invalid restart notification sound name", (Throwable)e);
            notificationKey = Key.key((String)"minecraft", (String)"block.note_block.bell");
        }
    }

    public static void schedule(int seconds, String message) {
        restartBar = BossBarManager.getInstance().startTimeBar(message, seconds, class_1259.class_1260.field_5784, class_1259.class_1261.field_5790, true);
        ((RestartEvents.Schedule)RestartEvents.SCHEDULED.invoker()).onSchedule(restartBar);
    }

    public static boolean isScheduled() {
        return restartBar != null || currentSchedule != null && !currentSchedule.isCancelled();
    }

    public static void cancel() {
        if (restartBar != null) {
            BossBarManager.getInstance().cancelTimeBar(restartBar);
            ((RestartEvents.Cancel)RestartEvents.CANCELED.invoker()).onCancel(restartBar);
            restartBar = null;
        }
        if (currentSchedule != null) {
            currentSchedule.cancel(false);
            currentSchedule = null;
        }
    }

    private static void notifyRestart(MinecraftServer server, BossBarManager.TimeBar bar) {
        RccServer rcc = RccServer.getInstance();
        Audience audience = rcc.adventure().players();
        Sound sound = Sound.sound((Key)notificationKey, (Sound.Source)Sound.Source.MASTER, (float)10.0f, (float)RccServer.CONFIG.autoRestart.restartSoundPitch);
        audience.playSound(sound, Sound.Emitter.self());
        Component comp = bar.parseLabel(RccServer.CONFIG.autoRestart.restartChatMessage);
        rcc.broadcastComponent(server, comp);
    }

    @Nullable
    public static Long scheduleNextRestart() {
        Long delay = AutoRestart.getNextDelay();
        if (delay == null) {
            return null;
        }
        int barTime = 600;
        long barStartTime = delay - (long)barTime;
        currentSchedule = scheduler.schedule(() -> AutoRestart.schedule(barTime, RccServer.CONFIG.autoRestart.restartBarLabel), barStartTime, TimeUnit.SECONDS);
        RccServer.LOGGER.info("Restart scheduled for in {} seconds", (Object)delay);
        return delay;
    }

    @Nullable
    private static Long getNextDelay() {
        ArrayList<String> restartTimeStrings = RccServer.CONFIG.autoRestart.restartAt;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextRunTime = null;
        long shortestDelay = Long.MAX_VALUE;
        for (String timeString : restartTimeStrings) {
            long delay;
            LocalTime targetTime = LocalTime.parse(timeString);
            LocalDateTime targetDateTime = now.with(targetTime);
            if (targetDateTime.isBefore(now)) {
                targetDateTime = targetDateTime.plusDays(1L);
            }
            if ((delay = Duration.between(now, targetDateTime).toSeconds()) >= shortestDelay) continue;
            shortestDelay = delay;
            nextRunTime = targetDateTime;
        }
        if (nextRunTime != null) {
            return shortestDelay;
        }
        return null;
    }

    static {
        currentSchedule = null;
    }
}

