/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.client;

import com.mojang.authlib.GameProfile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Utils {
    public static final Pattern VANILLA = Pattern.compile("^<(?<user>.+)> (?<text>.*)$");
    public static final Pattern MODERN = Pattern.compile("^(?<user>.+): (?<text>.*)$");
    public static final Pattern USERNAME = Pattern.compile("[^A-Za-z0-9_]");

    public static boolean isMentioning(String input) {
        ChatMessage message = Utils.parseMessage(input);
        GameProfile profile = class_310.method_1551().method_1548().method_1677();
        String username = profile.getName().toLowerCase();
        if (message.chat) {
            if (message.user.toLowerCase().equals(username)) {
                return false;
            }
            return message.message.toLowerCase().contains(username);
        }
        return false;
    }

    public static ChatMessage parseMessage(String input) {
        ChatMessage message;
        if (VANILLA.matcher(input).matches()) {
            ChatMessage message2 = Utils.extract(VANILLA, input);
            if (message2 != null) {
                return message2;
            }
        } else if (MODERN.matcher(input).matches() && (message = Utils.extract(MODERN, input)) != null) {
            return message;
        }
        return new ChatMessage("System", input, false);
    }

    public static ChatMessage extract(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String user = matcher.group("user");
            String text = matcher.group("text");
            user = user.replaceAll(USERNAME.pattern(), "");
            return new ChatMessage(user, text, true);
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public record ChatMessage(String user, String message, boolean chat) {
    }
}

