/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.fasterxml.jackson.databind;

import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonGenerator;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.Version;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.Versioned;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JavaType;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonMappingException;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonSerializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.ObjectWriter;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.SerializationConfig;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.SerializationFeature;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.SerializerProvider;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;

public class SequenceWriter
implements Versioned,
Closeable,
Flushable {
    protected final DefaultSerializerProvider _provider;
    protected final SerializationConfig _config;
    protected final JsonGenerator _generator;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final TypeSerializer _typeSerializer;
    protected final boolean _closeGenerator;
    protected final boolean _cfgFlush;
    protected final boolean _cfgCloseCloseable;
    protected PropertySerializerMap _dynamicSerializers;
    protected boolean _openArray;
    protected boolean _closed;

    public SequenceWriter(DefaultSerializerProvider prov, JsonGenerator gen, boolean closeGenerator, ObjectWriter.Prefetch prefetch) throws IOException {
        this._provider = prov;
        this._generator = gen;
        this._closeGenerator = closeGenerator;
        this._rootSerializer = prefetch.getValueSerializer();
        this._typeSerializer = prefetch.getTypeSerializer();
        this._config = prov.getConfig();
        this._cfgFlush = this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        this._cfgCloseCloseable = this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE);
        this._dynamicSerializers = PropertySerializerMap.emptyForRootValues();
    }

    public SequenceWriter init(boolean wrapInArray) throws IOException {
        if (wrapInArray) {
            this._generator.writeStartArray();
            this._openArray = true;
        }
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public SequenceWriter write(Object value2) throws IOException {
        Class<?> type;
        if (value2 == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && value2 instanceof Closeable) {
            return this._writeCloseableValue(value2);
        }
        JsonSerializer<Object> ser = this._rootSerializer;
        if (ser == null && (ser = this._dynamicSerializers.serializerFor(type = value2.getClass())) == null) {
            ser = this._findAndAddDynamic(type);
        }
        this._provider.serializeValue(this._generator, value2, null, ser);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter write(Object value2, JavaType type) throws IOException {
        if (value2 == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && value2 instanceof Closeable) {
            return this._writeCloseableValue(value2, type);
        }
        JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type.getRawClass());
        if (ser == null) {
            ser = this._findAndAddDynamic(type);
        }
        this._provider.serializeValue(this._generator, value2, type, ser);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter writeAll(Object[] value2) throws IOException {
        int len = value2.length;
        for (int i = 0; i < len; ++i) {
            this.write(value2[i]);
        }
        return this;
    }

    public <C extends Collection<?>> SequenceWriter writeAll(C container) throws IOException {
        for (Object value2 : container) {
            this.write(value2);
        }
        return this;
    }

    public SequenceWriter writeAll(Iterable<?> iterable) throws IOException {
        for (Object value2 : iterable) {
            this.write(value2);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (!this._closed) {
            this._generator.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._openArray) {
                this._openArray = false;
                this._generator.writeEndArray();
            }
            if (this._closeGenerator) {
                this._generator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object value2) throws IOException {
        Closeable toClose = (Closeable)value2;
        try {
            Class<?> type;
            JsonSerializer<Object> ser = this._rootSerializer;
            if (ser == null && (ser = this._dynamicSerializers.serializerFor(type = value2.getClass())) == null) {
                ser = this._findAndAddDynamic(type);
            }
            this._provider.serializeValue(this._generator, value2, null, ser);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceWriter _writeCloseableValue(Object value2, JavaType type) throws IOException {
        Closeable toClose = (Closeable)value2;
        try {
            JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type.getRawClass());
            if (ser == null) {
                ser = this._findAndAddDynamic(type);
            }
            this._provider.serializeValue(this._generator, value2, type, ser);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(Class<?> type) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(type, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer(type, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer(type, null)));
        this._dynamicSerializers = result.map;
        return result.serializer;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(JavaType type) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer(type, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer(type, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer(type, null)));
        this._dynamicSerializers = result.map;
        return result.serializer;
    }
}

