/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.fasterxml.jackson.datatype.jsr310.ser;

import com.github.quiltservertools.libs.com.fasterxml.jackson.annotation.JsonFormat;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonGenerator;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonToken;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.type.WritableTypeId;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.SerializerProvider;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310FormattedSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    protected LocalDateTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalDateTimeSerializer(DateTimeFormatter f) {
        super(LocalDateTime.class, f);
    }

    private LocalDateTimeSerializer(LocalDateTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter f) {
        super(base, useTimestamp, useNanoseconds, f, null);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalDateTime> withFormat(Boolean useTimestamp, DateTimeFormatter f, JsonFormat.Shape shape) {
        return new LocalDateTimeSerializer(this, useTimestamp, this._useNanoseconds, f);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }

    @Override
    public void serialize(LocalDateTime value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            g.writeStartArray();
            this._serializeAsArrayContents(value2, g, provider);
            g.writeEndArray();
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g.writeString(value2.format(dtf));
        }
    }

    @Override
    public void serializeWithType(LocalDateTime value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value2, this.serializationShape(provider)));
        if (typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value2, g, provider);
        } else {
            DateTimeFormatter dtf = this._formatter;
            if (dtf == null) {
                dtf = this._defaultFormatter();
            }
            g.writeString(value2.format(dtf));
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private final void _serializeAsArrayContents(LocalDateTime value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeNumber(value2.getYear());
        g.writeNumber(value2.getMonthValue());
        g.writeNumber(value2.getDayOfMonth());
        g.writeNumber(value2.getHour());
        g.writeNumber(value2.getMinute());
        int secs = value2.getSecond();
        int nanos = value2.getNano();
        if (secs > 0 || nanos > 0) {
            g.writeNumber(secs);
            if (nanos > 0) {
                if (this.useNanoseconds(provider)) {
                    g.writeNumber(nanos);
                } else {
                    g.writeNumber(value2.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        return this.useTimestamp(provider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new LocalDateTimeSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter);
    }
}

