/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.DatabaseConnectionAutoRegistration;
import org.jetbrains.exposed.sql.DatabaseKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLNGDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 W2\u00020\u0001:\u0001WB/\b\u0002\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\u0014\u001a\u00028\u0000\"\u0004\b\u0000\u0010\r2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0002\b\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R!\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\"\u001a\u0004\b#\u0010$R*\u0010&\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00178\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001b\u0010/\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010\fR\u001b\u00102\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010\fR\u001b\u00107\u001a\u0002038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010-\u001a\u0004\b5\u00106R\u001b\u0010\u0016\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010-\u001a\u0004\b9\u0010:R\u001b\u0010=\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010-\u001a\u0004\b<\u0010)R\u001b\u0010@\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010-\u001a\u0004\b?\u0010)R\u001b\u0010C\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010-\u001a\u0004\bB\u0010)R\u001b\u0010H\u001a\u00020D8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010-\u001a\u0004\bF\u0010GR(\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010I\u001a\u0004\bJ\u0010KR$\u0010L\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00178\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bL\u0010'\u001a\u0004\bM\u0010)R\"\u0010N\u001a\u00020\u001a8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\"\u0010T\u001a\u00020\u00178\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010'\u001a\u0004\bU\u0010)\"\u0004\bV\u0010+\u00a8\u0006X"}, d2={"Lorg/jetbrains/exposed/sql/Database;", "", "", "resolvedVendor", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "config", "Lkotlin/Function0;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connector", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function0;)V", "toString", "()Ljava/lang/String;", "T", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "body", "metadata$exposed_core", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "metadata", "Ljava/math/BigDecimal;", "version", "", "isVersionCovers", "(Ljava/math/BigDecimal;)Z", "", "size", "defaultFetchSize", "(I)Lorg/jetbrains/exposed/sql/Database;", "Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "getConfig", "()Lorg/jetbrains/exposed/sql/DatabaseConfig;", "Lkotlin/jvm/functions/Function0;", "getConnector", "()Lkotlin/jvm/functions/Function0;", "value", "useNestedTransactions", "Z", "getUseNestedTransactions", "()Z", "setUseNestedTransactions", "(Z)V", "url$delegate", "Lkotlin/Lazy;", "getUrl", "url", "vendor$delegate", "getVendor", "vendor", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect$delegate", "getDialect", "()Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect", "version$delegate", "getVersion", "()Ljava/math/BigDecimal;", "supportsAlterTableWithAddColumn$delegate", "getSupportsAlterTableWithAddColumn", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn$delegate", "getSupportsAlterTableWithDropColumn", "supportsAlterTableWithDropColumn", "supportsMultipleResultSets$delegate", "getSupportsMultipleResultSets", "supportsMultipleResultSets", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager", "Ljava/lang/Integer;", "getDefaultFetchSize", "()Ljava/lang/Integer;", "connectsViaDataSource", "getConnectsViaDataSource$exposed_core", "dataSourceIsolationLevel", "I", "getDataSourceIsolationLevel$exposed_core", "()I", "setDataSourceIsolationLevel$exposed_core", "(I)V", "dataSourceReadOnly", "getDataSourceReadOnly$exposed_core", "setDataSourceReadOnly$exposed_core", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\norg/jetbrains/exposed/sql/Database\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n1#2:341\n*E\n"})
public final class Database {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String resolvedVendor;
    @NotNull
    private final DatabaseConfig config;
    @NotNull
    private final Function0<ExposedConnection<?>> connector;
    private boolean useNestedTransactions;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy vendor$delegate;
    @NotNull
    private final Lazy dialect$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithDropColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private Integer defaultFetchSize;
    private boolean connectsViaDataSource;
    private int dataSourceIsolationLevel;
    private boolean dataSourceReadOnly;
    @NotNull
    private static final ConcurrentHashMap<String, Function0<DatabaseDialect>> dialects = new ConcurrentHashMap();
    @NotNull
    private static final Lazy<DatabaseConnectionAutoRegistration> connectionInstanceImpl$delegate = LazyKt.lazy(Database::connectionInstanceImpl_delegate$lambda$16);
    @NotNull
    private static final Map<String, String> driverMapping;
    @NotNull
    private static final Map<String, String> dialectMapping;

    private Database(String resolvedVendor, DatabaseConfig config, Function0<? extends ExposedConnection<?>> connector) {
        this.resolvedVendor = resolvedVendor;
        this.config = config;
        this.connector = connector;
        this.useNestedTransactions = this.config.getUseNestedTransactions();
        this.url$delegate = LazyKt.lazy(() -> Database.url_delegate$lambda$2(this));
        this.vendor$delegate = LazyKt.lazy(() -> Database.vendor_delegate$lambda$4(this));
        this.dialect$delegate = LazyKt.lazy(() -> Database.dialect_delegate$lambda$5(this));
        this.version$delegate = LazyKt.lazy(() -> Database.version_delegate$lambda$7(this));
        this.supportsAlterTableWithAddColumn$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsAlterTableWithAddColumn_delegate$lambda$9(this));
        this.supportsAlterTableWithDropColumn$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsAlterTableWithDropColumn_delegate$lambda$11(this));
        this.supportsMultipleResultSets$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsMultipleResultSets_delegate$lambda$13(this));
        this.identifierManager$delegate = LazyKt.lazy(() -> Database.identifierManager_delegate$lambda$15(this));
        this.defaultFetchSize = this.config.getDefaultFetchSize();
        this.dataSourceIsolationLevel = -1;
    }

    /* synthetic */ Database(String string, DatabaseConfig databaseConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, databaseConfig, function0);
    }

    @NotNull
    public final DatabaseConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Function0<ExposedConnection<?>> getConnector() {
        return this.connector;
    }

    public final boolean getUseNestedTransactions() {
        return this.useNestedTransactions;
    }

    @Deprecated(message="Use DatabaseConfig to define the useNestedTransactions", level=DeprecationLevel.ERROR)
    @TestOnly
    public final void setUseNestedTransactions(boolean bl) {
        this.useNestedTransactions = bl;
    }

    @NotNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                stringBuilder = new StringBuilder().append("ExposedDatabase[").append(this.hashCode()).append("](").append(this.resolvedVendor);
                object = this.config.getExplicitDialect();
                if (object == null) break block2;
                DatabaseDialect it = object;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = ", dialect=" + it;
                stringBuilder = stringBuilder2;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return stringBuilder.append((String)object).append(')').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T metadata$exposed_core(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        T t;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Transaction transaction = TransactionManager.Companion.currentOrNull();
        if (transaction == null) {
            T t2;
            try (ExposedConnection connection = (ExposedConnection)this.connector.invoke();){
                t2 = connection.metadata(body);
            }
            t = t2;
        } else {
            t = transaction.getConnection().metadata(body);
        }
        return t;
    }

    @NotNull
    public final String getUrl() {
        Lazy lazy2 = this.url$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final String getVendor() {
        Lazy lazy2 = this.vendor$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final DatabaseDialect getDialect() {
        Lazy lazy2 = this.dialect$delegate;
        return (DatabaseDialect)lazy2.getValue();
    }

    @NotNull
    public final BigDecimal getVersion() {
        Lazy lazy2 = this.version$delegate;
        return (BigDecimal)lazy2.getValue();
    }

    public final boolean isVersionCovers(@NotNull BigDecimal version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.getVersion().compareTo(version) >= 0;
    }

    public final boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy2 = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    public final boolean getSupportsAlterTableWithDropColumn() {
        Lazy lazy2 = this.supportsAlterTableWithDropColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    public final boolean getSupportsMultipleResultSets() {
        Lazy lazy2 = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy2.getValue();
    }

    @NotNull
    public final IdentifierManagerApi getIdentifierManager() {
        Lazy lazy2 = this.identifierManager$delegate;
        return (IdentifierManagerApi)lazy2.getValue();
    }

    @Nullable
    public final Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Deprecated(message="Use DatabaseConfig to define the defaultFetchSize", level=DeprecationLevel.ERROR)
    @TestOnly
    @NotNull
    public final Database defaultFetchSize(int size) {
        this.defaultFetchSize = size;
        return this;
    }

    public final boolean getConnectsViaDataSource$exposed_core() {
        return this.connectsViaDataSource;
    }

    public final int getDataSourceIsolationLevel$exposed_core() {
        return this.dataSourceIsolationLevel;
    }

    public final void setDataSourceIsolationLevel$exposed_core(int n) {
        this.dataSourceIsolationLevel = n;
    }

    public final boolean getDataSourceReadOnly$exposed_core() {
        return this.dataSourceReadOnly;
    }

    public final void setDataSourceReadOnly$exposed_core(boolean bl) {
        this.dataSourceReadOnly = bl;
    }

    private static final String url_delegate$lambda$2$lambda$1(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getUrl();
    }

    private static final String url_delegate$lambda$2(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (String)this$0.metadata$exposed_core(Database::url_delegate$lambda$2$lambda$1);
    }

    private static final String vendor_delegate$lambda$4$lambda$3(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getDatabaseDialectName();
    }

    private static final String vendor_delegate$lambda$4(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.resolvedVendor;
        if (string == null) {
            string = (String)this$0.metadata$exposed_core(Database::vendor_delegate$lambda$4$lambda$3);
        }
        return string;
    }

    private static final DatabaseDialect dialect_delegate$lambda$5(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.config.getExplicitDialect();
        if (databaseDialect == null) {
            String string = this$0.getVendor().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Function0<DatabaseDialect> function0 = dialects.get(string);
            databaseDialect = function0 != null ? (DatabaseDialect)function0.invoke() : null;
            if (databaseDialect == null) {
                throw new IllegalStateException(("No dialect registered for " + DatabaseKt.getName(this$0) + ". URL=" + this$0.getUrl()).toString());
            }
        }
        return databaseDialect;
    }

    private static final BigDecimal version_delegate$lambda$7$lambda$6(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getVersion();
    }

    private static final BigDecimal version_delegate$lambda$7(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (BigDecimal)this$0.metadata$exposed_core(Database::version_delegate$lambda$7$lambda$6);
    }

    private static final boolean supportsAlterTableWithAddColumn_delegate$lambda$9$lambda$8(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsAlterTableWithAddColumn();
    }

    private static final boolean supportsAlterTableWithAddColumn_delegate$lambda$9(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Boolean)this$0.metadata$exposed_core(Database::supportsAlterTableWithAddColumn_delegate$lambda$9$lambda$8);
    }

    private static final boolean supportsAlterTableWithDropColumn_delegate$lambda$11$lambda$10(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsAlterTableWithDropColumn();
    }

    private static final boolean supportsAlterTableWithDropColumn_delegate$lambda$11(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Boolean)this$0.metadata$exposed_core(Database::supportsAlterTableWithDropColumn_delegate$lambda$11$lambda$10);
    }

    private static final boolean supportsMultipleResultSets_delegate$lambda$13$lambda$12(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsMultipleResultSets();
    }

    private static final boolean supportsMultipleResultSets_delegate$lambda$13(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Boolean)this$0.metadata$exposed_core(Database::supportsMultipleResultSets_delegate$lambda$13$lambda$12);
    }

    private static final IdentifierManagerApi identifierManager_delegate$lambda$15$lambda$14(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getIdentifierManager();
    }

    private static final IdentifierManagerApi identifierManager_delegate$lambda$15(Database this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (IdentifierManagerApi)this$0.metadata$exposed_core(Database::identifierManager_delegate$lambda$15$lambda$14);
    }

    private static final DatabaseConnectionAutoRegistration connectionInstanceImpl_delegate$lambda$16() {
        ServiceLoader<DatabaseConnectionAutoRegistration> serviceLoader = ServiceLoader.load(DatabaseConnectionAutoRegistration.class, Database.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = (DatabaseConnectionAutoRegistration)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (databaseConnectionAutoRegistration == null) {
            throw new IllegalStateException(("Can't load implementation for " + Reflection.getOrCreateKotlinClass(DatabaseConnectionAutoRegistration.class).getSimpleName()).toString());
        }
        return databaseConnectionAutoRegistration;
    }

    private static final DatabaseDialect _init_$lambda$17() {
        return new H2Dialect();
    }

    private static final DatabaseDialect _init_$lambda$18() {
        return new MysqlDialect();
    }

    private static final DatabaseDialect _init_$lambda$19() {
        return new PostgreSQLDialect(null, 1, null);
    }

    private static final DatabaseDialect _init_$lambda$20() {
        return new PostgreSQLNGDialect();
    }

    private static final DatabaseDialect _init_$lambda$21() {
        return new SQLiteDialect();
    }

    private static final DatabaseDialect _init_$lambda$22() {
        return new OracleDialect();
    }

    private static final DatabaseDialect _init_$lambda$23() {
        return new SQLServerDialect();
    }

    private static final DatabaseDialect _init_$lambda$24() {
        return new MariaDBDialect();
    }

    public /* synthetic */ Database(String resolvedVendor, DatabaseConfig config, Function0 connector, DefaultConstructorMarker $constructor_marker) {
        this(resolvedVendor, config, connector);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)"org.h2.Driver"), TuplesKt.to((Object)"jdbc:postgresql", (Object)"org.postgresql.Driver"), TuplesKt.to((Object)"jdbc:pgsql", (Object)"com.impossibl.postgres.jdbc.PGDriver"), TuplesKt.to((Object)"jdbc:mysql", (Object)"com.mysql.cj.jdbc.Driver"), TuplesKt.to((Object)"jdbc:mariadb", (Object)"org.mariadb.jdbc.Driver"), TuplesKt.to((Object)"jdbc:oracle", (Object)"oracle.jdbc.OracleDriver"), TuplesKt.to((Object)"jdbc:sqlite", (Object)"org.sqlite.JDBC"), TuplesKt.to((Object)"jdbc:sqlserver", (Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver")};
        driverMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)H2Dialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:postgresql", (Object)PostgreSQLDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:pgsql", (Object)PostgreSQLNGDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:mysql", (Object)MysqlDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:mariadb", (Object)MariaDBDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:oracle", (Object)OracleDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:sqlite", (Object)SQLiteDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:sqlserver", (Object)SQLServerDialect.Companion.getDialectName())};
        dialectMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        Companion.registerDialect(H2Dialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$17));
        Companion.registerDialect(MysqlDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$18));
        Companion.registerDialect(PostgreSQLDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$19));
        Companion.registerDialect(PostgreSQLNGDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$20));
        Companion.registerDialect(SQLiteDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$21));
        Companion.registerDialect(OracleDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$22));
        Companion.registerDialect(SQLServerDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$23));
        Companion.registerDialect(MariaDBDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$24));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJe\u0010\u001b\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u00162\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJW\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001d2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u00162\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016\u00a2\u0006\u0004\b \u0010!JY\u0010#\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\"2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u00162\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016H\u0007\u00a2\u0006\u0004\b#\u0010$JG\u0010 \u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016\u00a2\u0006\u0004\b \u0010%Ju\u0010 \u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u00042\b\b\u0002\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00042\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u00162\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0016\u00a2\u0006\u0004\b \u0010*J\u0015\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020\u0018\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b1\u00100R,\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u001b\u0010;\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R \u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R \u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010>\u00a8\u0006@"}, d2={"Lorg/jetbrains/exposed/sql/Database$Companion;", "", "<init>", "()V", "", "prefix", "Lkotlin/Function0;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect", "", "registerDialect", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "driverClassName", "registerJdbcDriver", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "explicitVendor", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "config", "Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;", "connectionAutoRegistration", "Ljava/sql/Connection;", "getNewConnection", "Lkotlin/Function1;", "setupConnection", "Lorg/jetbrains/exposed/sql/Database;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "manager", "doConnect", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "Ljavax/sql/DataSource;", "datasource", "databaseConfig", "connect", "(Ljavax/sql/DataSource;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "Ljavax/sql/ConnectionPoolDataSource;", "connectPool", "(Ljavax/sql/ConnectionPoolDataSource;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "url", "driver", "user", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "db", "", "getDefaultIsolationLevel", "(Lorg/jetbrains/exposed/sql/Database;)I", "getDriver", "(Ljava/lang/String;)Ljava/lang/String;", "getDialectName", "Ljava/util/concurrent/ConcurrentHashMap;", "dialects", "Ljava/util/concurrent/ConcurrentHashMap;", "getDialects$exposed_core", "()Ljava/util/concurrent/ConcurrentHashMap;", "connectionInstanceImpl$delegate", "Lkotlin/Lazy;", "getConnectionInstanceImpl", "()Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;", "connectionInstanceImpl", "", "driverMapping", "Ljava/util/Map;", "dialectMapping", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\norg/jetbrains/exposed/sql/Database$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n295#2,2:341\n295#2,2:343\n1#3:345\n*S KotlinDebug\n*F\n+ 1 Database.kt\norg/jetbrains/exposed/sql/Database$Companion\n*L\n323#1:341,2\n328#1:343,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentHashMap<String, Function0<DatabaseDialect>> getDialects$exposed_core() {
            return dialects;
        }

        private final DatabaseConnectionAutoRegistration getConnectionInstanceImpl() {
            Lazy lazy2 = connectionInstanceImpl$delegate;
            return (DatabaseConnectionAutoRegistration)lazy2.getValue();
        }

        public final void registerDialect(@NotNull String prefix2, @NotNull Function0<? extends DatabaseDialect> dialect) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            Intrinsics.checkNotNullParameter(dialect, (String)"dialect");
            Map map2 = this.getDialects$exposed_core();
            String string = prefix2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map2.put(string, dialect);
        }

        public final void registerJdbcDriver(@NotNull String prefix2, @NotNull String driverClassName, @NotNull String dialect) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            driverMapping.put(prefix2, driverClassName);
            dialectMapping.put(prefix2, dialect);
        }

        private final Database doConnect(String explicitVendor, DatabaseConfig config, DatabaseConnectionAutoRegistration connectionAutoRegistration, Function0<? extends Connection> getNewConnection, Function1<? super Connection, Unit> setupConnection, Function1<? super Database, ? extends TransactionManager> manager) {
            Database database;
            DatabaseConfig databaseConfig = config;
            if (databaseConfig == null) {
                databaseConfig = DatabaseConfig.Companion.invoke$default(DatabaseConfig.Companion, null, 1, null);
            }
            Database $this$doConnect_u24lambda_u244 = database = new Database(explicitVendor, databaseConfig, () -> Companion.doConnect$lambda$3(connectionAutoRegistration, getNewConnection, setupConnection), null);
            boolean bl = false;
            TransactionManager.Companion.registerManager($this$doConnect_u24lambda_u244, (TransactionManager)manager.invoke((Object)$this$doConnect_u24lambda_u244));
            return database;
        }

        static /* synthetic */ Database doConnect$default(Companion companion, String string, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = Companion::doConnect$lambda$0;
            }
            if ((n & 0x20) != 0) {
                function12 = Companion::doConnect$lambda$1;
            }
            return companion.doConnect(string, databaseConfig, databaseConnectionAutoRegistration, (Function0<? extends Connection>)function0, (Function1<? super Connection, Unit>)function1, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connect(@NotNull DataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Database database;
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Database $this$connect_u24lambda_u248 = database = this.doConnect(null, databaseConfig, connectionAutoRegistration, (Function0<? extends Connection>)((Function0)() -> Companion.connect$lambda$7(datasource)), setupConnection, manager);
            boolean bl = false;
            $this$connect_u24lambda_u248.connectsViaDataSource = true;
            return database;
        }

        public static /* synthetic */ Database connect$default(Companion companion, DataSource dataSource, Function1 function1, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Companion::connect$lambda$5;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 0x10) != 0) {
                function12 = Companion::connect$lambda$6;
            }
            return companion.connect(dataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @Deprecated(message="Use Database.connect() with a connection pool DataSource instead. This may be removed in future releases.", level=DeprecationLevel.ERROR)
        @NotNull
        public final Database connectPool(@NotNull ConnectionPoolDataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return this.doConnect(null, databaseConfig, connectionAutoRegistration, (Function0<? extends Connection>)((Function0)() -> Companion.connectPool$lambda$11(datasource)), setupConnection, manager);
        }

        public static /* synthetic */ Database connectPool$default(Companion companion, ConnectionPoolDataSource connectionPoolDataSource, Function1 function1, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Companion::connectPool$lambda$9;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 0x10) != 0) {
                function12 = Companion::connectPool$lambda$10;
            }
            return companion.connectPool(connectionPoolDataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connect(@NotNull Function0<? extends Connection> getNewConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(getNewConnection, (String)"getNewConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return org.jetbrains.exposed.sql.Database$Companion.doConnect$default(this, null, databaseConfig, connectionAutoRegistration, getNewConnection, null, manager, 16, null);
        }

        public static /* synthetic */ Database connect$default(Companion companion, Function0 function0, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                databaseConfig = null;
            }
            if ((n & 4) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 8) != 0) {
                function1 = Companion::connect$lambda$12;
            }
            return companion.connect((Function0<? extends Connection>)function0, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManager>)function1);
        }

        @NotNull
        public final Database connect(@NotNull String url2, @NotNull String driver, @NotNull String user, @NotNull String password, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Class.forName(driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String string = this.getDialectName(url2);
            if (string == null) {
                throw new IllegalStateException(("Can't resolve dialect for connection: " + url2).toString());
            }
            String dialectName = string;
            return this.doConnect(dialectName, databaseConfig, connectionAutoRegistration, (Function0<? extends Connection>)((Function0)() -> Companion.connect$lambda$15(url2, user, password)), setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, String string, String string2, String string3, String string4, Function1 function1, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = companion.getDriver(string);
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                function1 = Companion::connect$lambda$13;
            }
            if ((n & 0x20) != 0) {
                databaseConfig = null;
            }
            if ((n & 0x40) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 0x80) != 0) {
                function12 = Companion::connect$lambda$14;
            }
            return companion.connect(string, string2, string3, string4, (Function1<? super Connection, Unit>)function1, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        public final int getDefaultIsolationLevel(@NotNull Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            DatabaseDialect databaseDialect = db.getDialect();
            return databaseDialect instanceof SQLiteDialect ? 8 : (databaseDialect instanceof MysqlDialect ? 4 : 2);
        }

        private final String getDriver(String url2) {
            String string;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = driverMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix2 = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url2, (String)prefix2, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry == null || (string = (String)entry.getValue()) == null) {
                throw new IllegalStateException(("Database driver not found for " + url2).toString());
            }
            return string;
        }

        @Nullable
        public final String getDialectName(@NotNull String url2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
                Iterable $this$firstOrNull$iv = dialectMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix2 = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url2, (String)prefix2, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null ? (String)entry.getValue() : null;
        }

        private static final Unit doConnect$lambda$0(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ThreadLocalTransactionManager doConnect$lambda$1(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ThreadLocalTransactionManager(it, null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final ExposedConnection doConnect$lambda$3(DatabaseConnectionAutoRegistration $connectionAutoRegistration, Function0 $getNewConnection, Function1 $setupConnection) {
            void $this$doConnect_u24lambda_u243_u24lambda_u242;
            Intrinsics.checkNotNullParameter((Object)$connectionAutoRegistration, (String)"$connectionAutoRegistration");
            Intrinsics.checkNotNullParameter((Object)$getNewConnection, (String)"$getNewConnection");
            Intrinsics.checkNotNullParameter((Object)$setupConnection, (String)"$setupConnection");
            Object object = $getNewConnection.invoke();
            Connection connection = (Connection)object;
            DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = $connectionAutoRegistration;
            boolean bl = false;
            $setupConnection.invoke((Object)$this$doConnect_u24lambda_u243_u24lambda_u242);
            return (ExposedConnection)databaseConnectionAutoRegistration.invoke(object);
        }

        private static final Unit connect$lambda$5(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ThreadLocalTransactionManager connect$lambda$6(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ThreadLocalTransactionManager(it, null, 2, null);
        }

        private static final Connection connect$lambda$7(DataSource $datasource) {
            Intrinsics.checkNotNullParameter((Object)$datasource, (String)"$datasource");
            Connection connection = $datasource.getConnection();
            Intrinsics.checkNotNull((Object)connection);
            return connection;
        }

        private static final Unit connectPool$lambda$9(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ThreadLocalTransactionManager connectPool$lambda$10(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ThreadLocalTransactionManager(it, null, 2, null);
        }

        private static final Connection connectPool$lambda$11(ConnectionPoolDataSource $datasource) {
            Intrinsics.checkNotNullParameter((Object)$datasource, (String)"$datasource");
            Connection connection = $datasource.getPooledConnection().getConnection();
            Intrinsics.checkNotNull((Object)connection);
            return connection;
        }

        private static final ThreadLocalTransactionManager connect$lambda$12(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ThreadLocalTransactionManager(it, null, 2, null);
        }

        private static final Unit connect$lambda$13(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ThreadLocalTransactionManager connect$lambda$14(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ThreadLocalTransactionManager(it, null, 2, null);
        }

        private static final Connection connect$lambda$15(String $url, String $user, String $password) {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            Intrinsics.checkNotNullParameter((Object)$user, (String)"$user");
            Intrinsics.checkNotNullParameter((Object)$password, (String)"$password");
            Connection connection = DriverManager.getConnection($url, $user, $password);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
            return connection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

