/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Intersect;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SetOperation;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/Except;", "Lorg/jetbrains/exposed/sql/SetOperation;", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "firstStatement", "secondStatement", "<init>", "(Lorg/jetbrains/exposed/sql/AbstractQuery;Lorg/jetbrains/exposed/sql/AbstractQuery;)V", "Lorg/jetbrains/exposed/sql/Intersect;", "copy", "()Lorg/jetbrains/exposed/sql/Intersect;", "", "value", "withDistinct", "(Z)Lorg/jetbrains/exposed/sql/SetOperation;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "builder", "", "prepareStatementSQL", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "", "getOperationName", "()Ljava/lang/String;", "operationName", "exposed-core"})
public final class Except
extends SetOperation {
    public Except(@NotNull AbstractQuery<?> firstStatement, @NotNull AbstractQuery<?> secondStatement) {
        Intrinsics.checkNotNullParameter(firstStatement, (String)"firstStatement");
        Intrinsics.checkNotNullParameter(secondStatement, (String)"secondStatement");
        super("EXCEPT", firstStatement, secondStatement, null);
    }

    @Override
    @NotNull
    public String getOperationName() {
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect || H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "MINUS" : "EXCEPT";
    }

    @NotNull
    public Intersect copy() {
        Intersect intersect;
        Intersect it = intersect = new Intersect(this.getFirstStatement(), this.getSecondStatement());
        boolean bl = false;
        this.copyTo((AbstractQuery)it);
        return intersect;
    }

    @Override
    @NotNull
    public SetOperation withDistinct(boolean value2) {
        return this;
    }

    @Override
    protected void prepareStatementSQL(@NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect && !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect)) {
            throw new UnsupportedByDialectException(this.getOperationName() + " is unsupported", DatabaseDialectKt.getCurrentDialect());
        }
        super.prepareStatementSQL(builder);
    }
}

