/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ExplainResultRow;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\r\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001%B%\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000f\u001a\u00020\u0004*\u00020\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0014\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00110\u00010\u0001H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!R\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\"R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/ExplainQuery;", "", "Lorg/jetbrains/exposed/sql/ExplainResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "", "analyze", "", "options", "internalStatement", "<init>", "(ZLjava/lang/String;Lorg/jetbrains/exposed/sql/statements/Statement;)V", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/sql/ResultSet;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "prepared", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;Z)Ljava/lang/String;", "", "iterator", "()Ljava/util/Iterator;", "Z", "getAnalyze", "()Z", "Ljava/lang/String;", "getOptions", "()Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "ResultIterator", "exposed-core"})
public class ExplainQuery
extends Statement<ResultSet>
implements Iterable<ExplainResultRow>,
KMappedMarker {
    private final boolean analyze;
    @Nullable
    private final String options;
    @NotNull
    private final Statement<?> internalStatement;

    public ExplainQuery(boolean analyze, @Nullable String options2, @NotNull Statement<?> internalStatement) {
        Intrinsics.checkNotNullParameter(internalStatement, (String)"internalStatement");
        super(StatementType.SHOW, CollectionsKt.emptyList());
        this.analyze = analyze;
        this.options = options2;
        this.internalStatement = internalStatement;
    }

    public final boolean getAnalyze() {
        return this.analyze;
    }

    @Nullable
    public final String getOptions() {
        return this.options;
    }

    private final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    @Override
    @NotNull
    public ResultSet executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return $this$executeInternal.executeQuery();
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.internalStatement.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String internalSql = this.internalStatement.prepareSQL(transaction, prepared2);
        return transaction.getDb().getDialect().getFunctionProvider().explain(this.analyze, this.options, internalSql, transaction);
    }

    @Override
    @NotNull
    public Iterator<ExplainResultRow> iterator() {
        Object t = this.getTransaction().exec(this);
        Intrinsics.checkNotNull(t);
        ResultIterator resultIterator = new ResultIterator((ResultSet)t);
        return ((Iterable)new Iterable<ExplainResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            public Iterator<ExplainResultRow> iterator() {
                boolean bl = false;
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/ExplainQuery$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ExplainResultRow;", "Ljava/sql/ResultSet;", "rs", "<init>", "(Lorg/jetbrains/exposed/sql/ExplainQuery;Ljava/sql/ResultSet;)V", "", "hasNext", "()Z", "next", "()Lorg/jetbrains/exposed/sql/ExplainResultRow;", "Ljava/sql/ResultSet;", "", "", "", "fieldIndex", "Ljava/util/Map;", "value", "Z", "setHasNext", "(Z)V", "exposed-core"})
    private final class ResultIterator
    implements Iterator<ExplainResultRow>,
    KMappedMarker {
        @NotNull
        private final ResultSet rs;
        @NotNull
        private final Map<String, Integer> fieldIndex;
        private boolean hasNext;

        /*
         * WARNING - void declaration
         */
        public ResultIterator(ResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            this.rs = rs;
            int n = this.rs.getMetaData().getColumnCount();
            ResultIterator resultIterator = this;
            ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
            int n2 = 0;
            while (n2 < n) {
                void i;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Pair> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(TuplesKt.to((Object)this.rs.getMetaData().getColumnName((int)(i + true)), (Object)((int)i)));
            }
            resultIterator.fieldIndex = MapsKt.toMap((Iterable)arrayList);
            this.setHasNext(this.rs.next());
        }

        private final void setHasNext(boolean value2) {
            this.hasNext = value2;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                this.rs.close();
                java.sql.Statement statement2 = statement;
                if (statement2 != null) {
                    statement2.close();
                }
                Transaction transaction = ExplainQuery.this.getTransaction();
                int n = transaction.getOpenResultSetsCount$exposed_core();
                transaction.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NotNull
        public ExplainResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ExplainResultRow result = ExplainResultRow.Companion.create(this.rs, this.fieldIndex);
            this.setHasNext(this.rs.next());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

