/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/Duration;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "value", "nonNullValueToString", "(Ljava/time/Duration;)Ljava/lang/String;", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/Duration;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "notNullValueToDB", "(Ljava/time/Duration;)Ljava/lang/Object;", "Companion", "exposed-java-time"})
@SourceDebugExtension(value={"SMAP\nJavaDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDateColumnType.kt\norg/jetbrains/exposed/sql/javatime/JavaDurationColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n1#2:510\n*E\n"})
public final class JavaDurationColumnType
extends ColumnType<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavaDurationColumnType INSTANCE = new JavaDurationColumnType();

    public JavaDurationColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().longType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Duration value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "" + '\'' + value2.toNanos() + '\'';
    }

    @Override
    @NotNull
    public Duration valueFromDB(@NotNull Object value2) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof Long) {
            Duration duration2 = Duration.ofNanos(((Number)value2).longValue());
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofNanos(...)");
        } else if (object instanceof Number) {
            Duration duration3 = Duration.ofNanos(((Number)value2).longValue());
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofNanos(...)");
        } else if (object instanceof String) {
            Duration duration4 = Duration.parse((CharSequence)value2);
            duration = duration4;
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"parse(...)");
        } else {
            duration = this.valueFromDB(value2.toString());
        }
        return duration;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Long l = rs.getLong(index);
        long it = ((Number)l).longValue();
        boolean bl = false;
        return rs.getObject(index) != null ? l : null;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Duration value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2.toNanos();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaDurationColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

