/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertSelectStatement;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/sql/statements/ReplaceSelectStatement;", "Lorg/jetbrains/exposed/sql/statements/InsertSelectStatement;", "", "Lorg/jetbrains/exposed/sql/Column;", "columns", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "selectQuery", "<init>", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/AbstractQuery;)V", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "prepared", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;Z)Ljava/lang/String;", "exposed-core"})
public class ReplaceSelectStatement
extends InsertSelectStatement {
    public ReplaceSelectStatement(@NotNull List<? extends Column<?>> columns, @NotNull AbstractQuery<?> selectQuery) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(selectQuery, (String)"selectQuery");
        super(columns, selectQuery, false, 4, null);
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        FunctionProvider functionProvider;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String querySql = this.getSelectQuery().prepareSQL(transaction, prepared2);
        DatabaseDialect dialect = transaction.getDb().getDialect();
        H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode(dialect);
        switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
            case 1: 
            case 2: {
                functionProvider = new MysqlFunctionProvider();
                break;
            }
            default: {
                functionProvider = dialect.getFunctionProvider();
            }
        }
        FunctionProvider functionProvider2 = functionProvider;
        return functionProvider2.replace((Table)CollectionsKt.single(this.getTargets()), this.getColumns(), querySql, transaction, prepared2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.MySQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.MariaDB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

