/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u000f\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001*B-\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0015\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00120\u00010\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010!R!\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010\u000f\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lorg/jetbrains/exposed/sql/statements/ReturningStatement;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "Lorg/jetbrains/exposed/sql/Expression;", "returningExpressions", "mainStatement", "<init>", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Lorg/jetbrains/exposed/sql/statements/Statement;)V", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/sql/ResultSet;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "", "prepared", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;Z)Ljava/lang/String;", "", "iterator", "()Ljava/util/Iterator;", "Lorg/jetbrains/exposed/sql/Table;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "Ljava/util/List;", "getReturningExpressions", "()Ljava/util/List;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "getMainStatement", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "ResultIterator", "exposed-core"})
public class ReturningStatement
extends Statement<ResultSet>
implements Iterable<ResultRow>,
KMappedMarker {
    @NotNull
    private final Table table;
    @NotNull
    private final List<Expression<?>> returningExpressions;
    @NotNull
    private final Statement<?> mainStatement;

    public ReturningStatement(@NotNull Table table, @NotNull List<? extends Expression<?>> returningExpressions, @NotNull Statement<?> mainStatement) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(returningExpressions, (String)"returningExpressions");
        Intrinsics.checkNotNullParameter(mainStatement, (String)"mainStatement");
        super(mainStatement.getType(), CollectionsKt.listOf((Object)table));
        this.table = table;
        this.returningExpressions = returningExpressions;
        this.mainStatement = mainStatement;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final List<Expression<?>> getReturningExpressions() {
        return this.returningExpressions;
    }

    @NotNull
    public final Statement<?> getMainStatement() {
        return this.mainStatement;
    }

    @NotNull
    protected final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    @Override
    @NotNull
    public ResultSet executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return $this$executeInternal.executeQuery();
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.mainStatement.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String mainSql = this.mainStatement.prepareSQL(transaction, prepared2);
        return transaction.getDb().getDialect().getFunctionProvider().returning(mainSql, this.returningExpressions, transaction);
    }

    @Override
    @NotNull
    public Iterator<ResultRow> iterator() {
        Object t = this.getTransaction().exec(this);
        Intrinsics.checkNotNull(t);
        ResultIterator resultIterator = new ResultIterator((ResultSet)t);
        return ((Iterable)new Iterable<ResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            public Iterator<ResultRow> iterator() {
                boolean bl = false;
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00078\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b\b\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/statements/ReturningStatement$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "Ljava/sql/ResultSet;", "rs", "<init>", "(Lorg/jetbrains/exposed/sql/statements/ReturningStatement;Ljava/sql/ResultSet;)V", "", "hasNext", "()Z", "next", "()Lorg/jetbrains/exposed/sql/ResultRow;", "Ljava/sql/ResultSet;", "getRs", "()Ljava/sql/ResultSet;", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "fieldIndex", "Ljava/util/Map;", "getFieldIndex", "()Ljava/util/Map;", "value", "Z", "setHasNext", "(Z)V", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nReturningStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturningStatement.kt\norg/jetbrains/exposed/sql/statements/ReturningStatement$ResultIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1216#2,2:70\n1246#2,4:72\n*S KotlinDebug\n*F\n+ 1 ReturningStatement.kt\norg/jetbrains/exposed/sql/statements/ReturningStatement$ResultIterator\n*L\n42#1:70,2\n42#1:72,4\n*E\n"})
    private final class ResultIterator
    implements Iterator<ResultRow>,
    KMappedMarker {
        @NotNull
        private final ResultSet rs;
        @NotNull
        private final Map<Expression<?>, Integer> fieldIndex;
        private boolean hasNext;

        /*
         * WARNING - void declaration
         */
        public ResultIterator(ResultSet rs) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            this.rs = rs;
            Iterable iterable = CollectionsKt.withIndex((Iterable)ReturningStatement.this.getReturningExpressions());
            ResultIterator resultIterator = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var6_7 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                IndexedValue it = (IndexedValue)element$iv$iv;
                Expression expression = (Expression)it.getValue();
                boolean bl2 = false;
                Integer n = it.getIndex();
                map2.put(expression, n);
            }
            resultIterator.fieldIndex = destination$iv$iv;
            this.setHasNext(this.rs.next());
        }

        @NotNull
        public final ResultSet getRs() {
            return this.rs;
        }

        @NotNull
        public final Map<Expression<?>, Integer> getFieldIndex() {
            return this.fieldIndex;
        }

        private final void setHasNext(boolean value2) {
            this.hasNext = value2;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                this.rs.close();
                java.sql.Statement statement2 = statement;
                if (statement2 != null) {
                    statement2.close();
                }
                Transaction transaction = ReturningStatement.this.getTransaction();
                int n = transaction.getOpenResultSetsCount$exposed_core();
                transaction.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NotNull
        public ResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ResultRow result = ResultRow.Companion.create(this.rs, this.fieldIndex);
            this.setHasNext(this.rs.next());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

