/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u0004\u0018\u00018\u0000*\u00020\n2\u0006\u0010\f\u001a\u00020\u000bH&\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH&\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0017\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00150\u00140\u0014H&\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010 \u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00050\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u000f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b'\u0010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/statements/Statement;", "T", "", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "type", "", "Lorg/jetbrains/exposed/sql/Table;", "targets", "<init>", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "", "prepared", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;Z)Ljava/lang/String;", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "arguments", "()Ljava/lang/Iterable;", "sql", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "execute", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executeIn$exposed_core", "(Lorg/jetbrains/exposed/sql/Transaction;)Lkotlin/Pair;", "executeIn", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "getType", "()Lorg/jetbrains/exposed/sql/statements/StatementType;", "Ljava/util/List;", "getTargets", "()Ljava/util/List;", "isAlwaysBatch", "Z", "()Z", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Statement.kt\norg/jetbrains/exposed/sql/statements/Statement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1557#2:230\n1628#2,2:231\n1863#2,2:233\n1863#2,2:235\n1630#2:237\n1863#2,2:238\n1863#2,2:240\n1872#2,3:242\n1863#2,2:245\n1863#2,2:247\n1863#2,2:249\n*S KotlinDebug\n*F\n+ 1 Statement.kt\norg/jetbrains/exposed/sql/statements/Statement\n*L\n65#1:230\n65#1:231,2\n67#1:233,2\n68#1:235,2\n65#1:237\n73#1:238,2\n74#1:240,2\n85#1:242,3\n95#1:245,2\n104#1:247,2\n105#1:249,2\n*E\n"})
public abstract class Statement<T> {
    @NotNull
    private final StatementType type;
    @NotNull
    private final List<Table> targets;
    private final boolean isAlwaysBatch;

    public Statement(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.type = type;
        this.targets = targets;
    }

    @NotNull
    public final StatementType getType() {
        return this.type;
    }

    @NotNull
    public final List<Table> getTargets() {
        return this.targets;
    }

    @Nullable
    public abstract T executeInternal(@NotNull PreparedStatementApi var1, @NotNull Transaction var2);

    @NotNull
    public abstract String prepareSQL(@NotNull Transaction var1, boolean var2);

    public static /* synthetic */ String prepareSQL$default(Statement statement, Transaction transaction, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareSQL");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return statement.prepareSQL(transaction, bl);
    }

    @NotNull
    public abstract Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments();

    @NotNull
    public PreparedStatementApi prepared(@NotNull Transaction transaction, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return transaction.getConnection().prepareStatement(sql, false);
    }

    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Nullable
    public final T execute(@NotNull Transaction transaction) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (transaction.getBlockStatementExecution$exposed_core()) {
            transaction.setExplainStatement$exposed_core(this);
            t = null;
        } else {
            t = transaction.exec(this);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<T, List<StatementContext>> executeIn$exposed_core(@NotNull Transaction transaction) {
        T $i$f$forEach4;
        Object $this$forEach$iv;
        StatementInterceptor it;
        List list2;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments = this.arguments();
        if (CollectionsKt.any(arguments)) {
            void $this$mapTo$iv$iv;
            Iterable<Iterable<Pair<IColumnType<?>, Object>>> $this$map$iv = arguments;
            boolean $i$f$map = false;
            Iterable<Iterable<Pair<IColumnType<?>, Object>>> iterable = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementInterceptor it2;
                void args;
                Iterable iterable2 = (Iterable)item$iv$iv;
                Iterator iterator2 = destination$iv$iv;
                boolean bl = false;
                StatementContext context = new StatementContext(this, (Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>>)args);
                Iterable $this$forEach$iv2 = Transaction.Companion.getGlobalInterceptors$exposed_core();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it2 = (GlobalStatementInterceptor)element$iv;
                    boolean bl2 = false;
                    it2.beforeExecution(transaction, context);
                }
                $this$forEach$iv2 = transaction.getInterceptors$exposed_core();
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it2 = (StatementInterceptor)element$iv;
                    boolean bl3 = false;
                    it2.beforeExecution(transaction, context);
                }
                iterator2.add((StatementContext)context);
            }
            list2 = (List)((Object)destination$iv$iv);
        } else {
            StatementContext context = new StatementContext(this, CollectionsKt.emptyList());
            Iterable $this$forEach$iv3 = Transaction.Companion.getGlobalInterceptors$exposed_core();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (GlobalStatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction, context);
            }
            $this$forEach$iv3 = transaction.getInterceptors$exposed_core();
            $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (StatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction, context);
            }
            list2 = CollectionsKt.listOf((Object)context);
        }
        List contexts = list2;
        try {
            $this$forEach$iv = this.prepared(transaction, Statement.prepareSQL$default(this, transaction, false, 2, null));
            PreparedStatementApi $this$executeIn_u24lambda_u245 = $this$forEach$iv;
            boolean bl = false;
            $this$executeIn_u24lambda_u245.setTimeout(transaction.getQueryTimeout());
        }
        catch (SQLException e) {
            throw new ExposedSQLException(e, contexts, transaction);
        }
        PreparedStatementApi statement = $this$forEach$iv;
        Iterable $this$forEachIndexed$iv = contexts;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int bl;
            if ((bl = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StatementContext context = (StatementContext)item$iv;
            boolean bl4 = false;
            statement.fillParameters(context.getArgs());
            if (contexts.size() <= 1 && !this.isAlwaysBatch()) continue;
            statement.addBatch();
        }
        if (!transaction.getDb().getSupportsMultipleResultSets()) {
            transaction.closeExecutedStatements();
        }
        transaction.setCurrentStatement(statement);
        $this$forEach$iv = transaction.getInterceptors$exposed_core();
        boolean $i$f$forEach4 = false;
        Iterator index$iv22 = $this$forEach$iv.iterator();
        while (index$iv22.hasNext()) {
            Iterator element$iv = index$iv22.next();
            it = (StatementInterceptor)((Object)element$iv);
            boolean bl = false;
            it.afterStatementPrepared(transaction, statement);
        }
        try {
            $i$f$forEach4 = this.executeInternal(statement, transaction);
        }
        catch (SQLException cause) {
            throw new ExposedSQLException(cause, contexts, transaction);
        }
        T result = $i$f$forEach4;
        transaction.setCurrentStatement(null);
        transaction.getExecutedStatements$exposed_core().add(statement);
        Iterable $this$forEach$iv4 = Transaction.Companion.getGlobalInterceptors$exposed_core();
        boolean $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv4) {
            GlobalStatementInterceptor it3 = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it3.afterExecution(transaction, contexts, statement);
        }
        $this$forEach$iv4 = transaction.getInterceptors$exposed_core();
        $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv4) {
            StatementInterceptor it4 = (StatementInterceptor)element$iv;
            boolean bl = false;
            it4.afterExecution(transaction, contexts, statement);
        }
        return TuplesKt.to(result, (Object)contexts);
    }
}

