/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.CompositeID;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.CompositeColumn;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.NullableColumnWithTransform;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u000b\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\u00020\u000f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J,\u0010\u0014\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0013\u001a\u00028\u0001H\u0097\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J6\u0010\u0014\u001a\u00020\u000f\"\b\b\u0001\u0010\u0012*\u00020\u00162\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00170\n2\u0006\u0010\u0013\u001a\u00028\u0001H\u0087\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0015J:\u0010\u0014\u001a\u00020\u000f\"\b\b\u0001\u0010\u0012*\u00020\u00162\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00170\n2\b\u0010\u0013\u001a\u0004\u0018\u00018\u0001H\u0087\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0015JR\u0010\u0014\u001a\u00020\u000f\"\n\b\u0001\u0010\u0012*\u0004\u0018\u00010\u0016\"\u000e\b\u0002\u0010\u001a*\b\u0012\u0004\u0012\u00028\u00010\u0017\"\u000e\b\u0003\u0010\u001c*\b\u0012\u0004\u0012\u00028\u00010\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\n2\u0006\u0010\u0013\u001a\u00028\u0003H\u0087\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJH\u0010\u0014\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u0012*\u0004\u0018\u00018\u0001\"\u000e\b\u0003\u0010\u001c*\b\u0012\u0004\u0012\u00028\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0013\u001a\u00028\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u001eJ,\u0010\u0014\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0013\u001a\u00020\u001fH\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010 J,\u0010\u0014\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0013\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\"J\u0013\u0010$\u001a\u00020\u000f*\u00020#H\u0002\u00a2\u0006\u0004\b$\u0010%J=\u0010&\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u0012*\u0004\u0018\u00018\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016\u00a2\u0006\u0004\b&\u0010\u001eJN\u0010&\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u0012*\u0004\u0018\u00018\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u001d\u0010\u0013\u001a\u0019\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u001b0'\u00a2\u0006\u0002\b)H\u0016\u00a2\u0006\u0004\b&\u0010*R,\u0010,\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160+8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\"\u00100\u001a\u00020\f8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00066"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "type", "", "Lorg/jetbrains/exposed/sql/Table;", "targets", "<init>", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "Lorg/jetbrains/exposed/sql/Column;", "column", "", "contains", "(Lorg/jetbrains/exposed/sql/Column;)Z", "", "checkThatExpressionWasNotSetInPreviousBatch", "(Lorg/jetbrains/exposed/sql/Column;)V", "S", "value", "set", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "", "Lorg/jetbrains/exposed/dao/id/EntityID;", "setWithEntityIdValue", "setWithNullableEntityIdValue", "ID", "Lorg/jetbrains/exposed/sql/Expression;", "E", "setWithEntityIdExpression", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Expression;)V", "Lorg/jetbrains/exposed/sql/Query;", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Query;)V", "Lorg/jetbrains/exposed/sql/CompositeColumn;", "(Lorg/jetbrains/exposed/sql/CompositeColumn;Ljava/lang/Object;)V", "Lorg/jetbrains/exposed/dao/id/CompositeID;", "setComponentValues", "(Lorg/jetbrains/exposed/dao/id/CompositeID;)V", "update", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/Column;Lkotlin/jvm/functions/Function1;)V", "", "values", "Ljava/util/Map;", "getValues", "()Ljava/util/Map;", "hasBatchedValues", "Z", "getHasBatchedValues", "()Z", "setHasBatchedValues", "(Z)V", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nUpdateBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateBuilder.kt\norg/jetbrains/exposed/sql/statements/UpdateBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n1#2:109\n216#3,2:110\n216#3,2:112\n*S KotlinDebug\n*F\n+ 1 UpdateBuilder.kt\norg/jetbrains/exposed/sql/statements/UpdateBuilder\n*L\n82#1:110,2\n89#1:112,2\n*E\n"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    @NotNull
    private final Map<Column<?>, Object> values;
    private boolean hasBatchedValues;

    public UpdateBuilder(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(type, targets);
        this.values = new LinkedHashMap();
    }

    @NotNull
    protected final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    public boolean contains(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.values.containsKey(column);
    }

    protected final boolean getHasBatchedValues() {
        return this.hasBatchedValues;
    }

    protected final void setHasBatchedValues(boolean bl) {
        this.hasBatchedValues = bl;
    }

    private final void checkThatExpressionWasNotSetInPreviousBatch(Column<?> column) {
        if (!(!this.values.containsKey(column) || !this.hasBatchedValues)) {
            boolean bl = false;
            String string = column + " is already initialized in a batch";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @LowPriorityInOverloadResolution
    public <S> void set(@NotNull Column<S> column, S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType() instanceof NullableColumnWithTransform || column.getColumnType().getNullable() || value2 != null && !(value2 instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        if (ColumnTypeKt.isEntityIdentifier(column)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type org.jetbrains.exposed.dao.id.EntityID<*>");
            if (((EntityID)value2).getValue() instanceof CompositeID) {
                Object t = ((EntityID)value2).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.exposed.dao.id.CompositeID");
                this.setComponentValues((CompositeID)t);
                return;
            }
        }
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    @JvmName(name="setWithEntityIdValue")
    public final <S> void setWithEntityIdValue(@NotNull Column<EntityID<S>> column, @NotNull S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (value2 instanceof CompositeID) {
            this.setComponentValues((CompositeID)value2);
        } else {
            DdlAware ddlAware = column.getForeignKey();
            if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
                ddlAware = column.getTable();
            }
            Intrinsics.checkNotNull((Object)ddlAware, (String)"null cannot be cast to non-null type org.jetbrains.exposed.dao.id.IdTable<S of org.jetbrains.exposed.sql.statements.UpdateBuilder.set>");
            EntityID<S> entityId = new EntityID<S>(value2, (IdTable)ddlAware);
            column.getColumnType().validateValueBeforeUpdate(entityId);
            this.values.put(column, entityId);
        }
    }

    @JvmName(name="setWithNullableEntityIdValue")
    public final <S> void setWithNullableEntityIdValue(@NotNull Column<EntityID<S>> column, @Nullable S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType().getNullable() || value2 != null)) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        if (value2 instanceof CompositeID) {
            this.setComponentValues((CompositeID)value2);
        } else {
            EntityID<S> entityID;
            S s = value2;
            if (s != null) {
                S it = s;
                boolean bl = false;
                DdlAware ddlAware = column.getForeignKey();
                if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
                    ddlAware = column.getTable();
                }
                Intrinsics.checkNotNull((Object)ddlAware, (String)"null cannot be cast to non-null type org.jetbrains.exposed.dao.id.IdTable<S of org.jetbrains.exposed.sql.statements.UpdateBuilder.set$lambda$3>");
                entityID = new EntityID<S>(it, (IdTable)ddlAware);
            } else {
                entityID = null;
            }
            EntityID<S> entityId = entityID;
            column.getColumnType().validateValueBeforeUpdate(entityId);
            this.values.put(column, entityId);
        }
    }

    @JvmName(name="setWithEntityIdExpression")
    public final <S, ID extends EntityID<S>, E extends Expression<S>> void setWithEntityIdExpression(@NotNull Column<ID> column, @NotNull E value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (!(column.getColumnType().getNullable() || !(value2 instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, value2);
    }

    public <T, S extends T, E extends Expression<S>> void set(@NotNull Column<T> column, @NotNull E value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.update(column, value2);
    }

    public <S> void set(@NotNull Column<S> column, @NotNull Query value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.update(column, AliasKt.wrapAsExpression(value2));
    }

    public <S> void set(@NotNull CompositeColumn<S> column, S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Map<Column<?>, Object> $this$forEach$iv = column.getRealColumnsWithValues(value2);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            Column<?> realColumn = entry.getKey();
            Object itsValue = entry.getValue();
            Intrinsics.checkNotNull(realColumn, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.Column<kotlin.Any?>");
            this.set(realColumn, (Expression)itsValue);
        }
    }

    private final void setComponentValues(CompositeID $this$setComponentValues) {
        Map<Column<?>, Object> $this$forEach$iv = $this$setComponentValues.getValues$exposed_core();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            Column<?> idColumn = entry.getKey();
            Object idValue = entry.getValue();
            Intrinsics.checkNotNull(idColumn, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.Column<kotlin.Any?>");
            this.set(idColumn, (Expression)idValue);
        }
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Expression<S> value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, value2);
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Function1<? super SqlExpressionBuilder, ? extends Expression<S>> value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.update(column, (Expression)value2.invoke((Object)SqlExpressionBuilder.INSTANCE));
    }
}

