/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ.\u0010\u0010\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u001bJ\u001d\u0010\u001e\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020!H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010$\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\t\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R$\u0010/\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00102\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u0014\u00103\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R$\u00108\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b5\u00104\"\u0004\b6\u00107R$\u0010;\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u00104\"\u0004\b:\u00107R*\u0010=\u001a\u00020<2\u0006\u0010*\u001a\u00020<8V@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001b\u0010\u0010\u001a\u00020C8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\u00a8\u0006H"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "connection", "<init>", "(Ljava/sql/Connection;)V", "", "commit", "()V", "rollback", "close", "T", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "body", "metadata", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "sql", "", "returnKeys", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "prepareStatement", "(Ljava/lang/String;Z)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "columns", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "sqls", "executeInBatch", "(Ljava/util/List;)V", "name", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "setSavepoint", "(Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "savepoint", "releaseSavepoint", "(Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;)V", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "value", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "catalog", "getSchema", "setSchema", "schema", "isClosed", "()Z", "getAutoCommit", "setAutoCommit", "(Z)V", "autoCommit", "getReadOnly", "setReadOnly", "readOnly", "", "transactionIsolation", "I", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "getMetadata", "()Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcConnectionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1557#2:146\n1628#2,3:147\n2632#2,3:150\n*S KotlinDebug\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n*L\n88#1:146\n88#1:147,3\n94#1:150,3\n*E\n"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    @NotNull
    private final Connection connection;
    private int transactionIsolation;
    @NotNull
    private final Lazy metadata$delegate;

    public JdbcConnectionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.transactionIsolation = -1;
        this.metadata$delegate = LazyKt.lazy(() -> JdbcConnectionImpl.metadata_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public String getCatalog() {
        String string;
        String string2;
        try {
            string2 = this.getConnection().getCatalog();
        }
        catch (Exception exception) {
            string2 = null;
        }
        if ((string = string2) == null && (string = this.getConnection().getMetaData().getUserName()) == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setCatalog(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            this.getConnection().setCatalog(value2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getSchema() {
        String string;
        try {
            string = this.getConnection().getSchema();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    @Override
    public void setSchema(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            this.getConnection().setSchema(value2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void commit() {
        this.getConnection().commit();
    }

    @Override
    public void rollback() {
        this.getConnection().rollback();
    }

    @Override
    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    @Override
    public void close() {
        this.getConnection().close();
    }

    @Override
    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean value2) {
        this.getConnection().setAutoCommit(value2);
    }

    @Override
    public boolean getReadOnly() {
        return this.getConnection().isReadOnly();
    }

    @Override
    public void setReadOnly(boolean value2) {
        this.getConnection().setReadOnly(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() {
        if (this.transactionIsolation == -1) {
            JdbcConnectionImpl jdbcConnectionImpl = this;
            synchronized (jdbcConnectionImpl) {
                boolean bl = false;
                this.transactionIsolation = this.getConnection().getTransactionIsolation();
                Unit unit = Unit.INSTANCE;
            }
        }
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int value2) {
        if (this.transactionIsolation != value2) {
            this.getConnection().setTransactionIsolation(value2);
            this.transactionIsolation = value2;
        }
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy2 = this.metadata$delegate;
        return (JdbcDatabaseMetadataImpl)lazy2.getValue();
    }

    @Override
    public <T> T metadata(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return (T)body.invoke((Object)this.getMetadata());
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, boolean returnKeys) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        int generated = returnKeys ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, generated);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, returnKeys);
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, @NotNull String[] columns) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, columns);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void executeInBatch(@NotNull List<String> sqls) {
        boolean bl;
        List types;
        Object object;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
            Iterable $this$map$iv = sqls;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementType statementType;
                Object v0;
                Collection collection;
                block8: {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = (Iterable)StatementType.getEntries();
                    for (Object t : iterable) {
                        void stmt;
                        StatementType it = (StatementType)((Object)t);
                        boolean bl3 = false;
                        if (!StringsKt.startsWith((String)stmt, (String)it.name(), (boolean)true)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                if ((statementType = (StatementType)v0) == null) {
                    statementType = StatementType.OTHER;
                }
                collection.add(statementType);
            }
            types = (List)destination$iv$iv;
            Iterable $this$none$iv = types;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatementType it = (StatementType)((Object)element$iv);
                    boolean bl4 = false;
                    if (!(it == StatementType.SELECT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = false;
            String $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = "SELECT statements are unsupported in batch execution";
            throw new IllegalStateException($i$a$-check-JdbcConnectionImpl$executeInBatch$32.toString());
        }
        StatementType statementType = (StatementType)((Object)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)types)));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type = statementType;
        object = CollectionsKt.emptyList();
        Statement<Unit> prepStatement2 = new Statement<Unit>(type, this, sqls, (List<? extends Table>)object){
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List<String> $sqls;
            {
                this.this$0 = $receiver;
                this.$sqls = $sqls;
                super($type, $super_call_param$1);
            }

            public PreparedStatementApi prepared(Transaction transaction, String sql) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                PreparedStatementApi originalStatement = super.prepared(transaction, StringsKt.substringBefore$default((String)sql, (char)'\n', null, (int)2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                List<String> list2 = this.$sqls;
                java.sql.Statement $this$prepared_u24lambda_u241 = statement;
                boolean bl = false;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    $this$prepared_u24lambda_u241.addBatch(it);
                }
                java.sql.Statement batchStatement = statement;
                return new PreparedStatementApi(originalStatement, batchStatement){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ PreparedStatementApi $originalStatement;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    {
                        this.$originalStatement = $originalStatement;
                        this.$batchStatement = $batchStatement;
                        this.$$delegate_0 = $originalStatement;
                    }

                    public int fillParameters(Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args) {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$$delegate_0.fillParameters(args);
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public List<StatementResult> executeMultiple() {
                        return this.$$delegate_0.executeMultiple();
                    }

                    public void set(int index, Object value2) {
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.$$delegate_0.set(index, value2);
                    }

                    public void setNull(int index, IColumnType<?> columnType) {
                        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
                        this.$$delegate_0.setNull(index, columnType);
                    }

                    public void setInputStream(int index, InputStream inputStream, boolean setAsBlobObject) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        this.$$delegate_0.setInputStream(index, inputStream, setAsBlobObject);
                    }

                    public void setArray(int index, String type, Object[] array) {
                        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
                        this.$$delegate_0.setArray(index, type, array);
                    }

                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    public void cancel() {
                        this.$$delegate_0.cancel();
                    }

                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    public Integer getTimeout() {
                        return this.$$delegate_0.getTimeout();
                    }

                    public void setTimeout(Integer n) {
                        this.$$delegate_0.setTimeout(n);
                    }

                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                };
            }

            public void executeInternal(PreparedStatementApi $this$executeInternal, Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                $this$executeInternal.executeUpdate();
            }

            public String prepareSQL(Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return CollectionsKt.joinToString$default((Iterable)this.$sqls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }

            public Iterable<Iterable<Pair<ColumnType<?>, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
        };
        prepStatement2.execute(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public ExposedSavepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Savepoint savepoint = this.getConnection().setSavepoint(name);
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"setSavepoint(...)");
        return new JdbcSavepoint(name, savepoint);
    }

    @Override
    public void releaseSavepoint(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    @Override
    public void rollback(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().rollback(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    private static final JdbcDatabaseMetadataImpl metadata_delegate$lambda$1(JdbcConnectionImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.getCatalog();
        DatabaseMetaData databaseMetaData = this$0.getConnection().getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getMetaData(...)");
        return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
    }
}

