/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLNGDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SchemaMetadata;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 p2\u00020\u0001:\u0002qpB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0014\u001a\u00020\u00132\u001a\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\f*\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J5\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\f0\u00112\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u0017*\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002\u00a2\u0006\u0004\b$\u0010#J5\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\f0\u00112\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0004\b&\u0010\u001eJ1\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010'0\u00112\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0004\b(\u0010\u001eJ\u0015\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a2\u0006\u0004\b)\u0010\u0010J/\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\f0\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016\u00a2\u0006\u0004\b+\u0010,J#\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020.2\u0006\u0010-\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b1\u0010\nJ4\u00107\u001a\b\u0012\u0004\u0012\u00028\u000006\"\u0004\b\u0000\u001022\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u000003\u00a2\u0006\u0002\b4H\u0002\u00a2\u0006\u0004\b7\u00108R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00109\u001a\u0004\b:\u0010;R\u001b\u0010@\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u001b\u0010E\u001a\u00020A8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010=\u001a\u0004\bC\u0010DR\u001b\u0010H\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010=\u001a\u0004\bG\u0010?R\u0014\u0010J\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010?R\u001b\u0010M\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010=\u001a\u0004\bL\u0010?R\u001b\u0010R\u001a\u00020N8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010=\u001a\u0004\bP\u0010QR\u001b\u0010W\u001a\u00020S8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010=\u001a\u0004\bU\u0010VR\u001b\u0010Z\u001a\u00020S8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bX\u0010=\u001a\u0004\bY\u0010VR\u001b\u0010]\u001a\u00020S8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010=\u001a\u0004\b\\\u0010VR\u001b\u0010`\u001a\u00020S8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b^\u0010=\u001a\u0004\b_\u0010VR\u001b\u0010e\u001a\u00020a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010=\u001a\u0004\bc\u0010dR\u001e\u0010f\u001a\u0004\u0018\u00010\u00028B@\u0002X\u0082\u000e\u00a2\u0006\f\n\u0004\bf\u0010g\u001a\u0004\bh\u0010?R&\u0010k\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010\u0010R&\u0010n\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\f0m8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010o\u00a8\u0006r"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "", "database", "Ljava/sql/DatabaseMetaData;", "metadata", "<init>", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "", "resetCurrentScheme", "()V", "scheme", "", "tableNamesFor", "(Ljava/lang/String;)Ljava/util/List;", "schemaNames", "()Ljava/util/List;", "", "tableNamesCache", "Lorg/jetbrains/exposed/sql/vendors/SchemaMetadata;", "tableNamesByCurrentSchema", "(Ljava/util/Map;)Lorg/jetbrains/exposed/sql/vendors/SchemaMetadata;", "Ljava/sql/ResultSet;", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "extractColumns", "(Ljava/sql/ResultSet;)Ljava/util/List;", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "columns", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "asColumnMetadata", "(Ljava/sql/ResultSet;)Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "defaultValue", "sanitizedDefault", "(Ljava/lang/String;)Ljava/lang/String;", "extractNullAndStringFromDefaultValue", "Lorg/jetbrains/exposed/sql/Index;", "existingIndices", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "existingPrimaryKeys", "sequences", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableConstraints", "(Ljava/util/List;)Ljava/util/Map;", "table", "Lkotlin/Pair;", "tableCatalogAndSchema", "(Lorg/jetbrains/exposed/sql/Table;)Lkotlin/Pair;", "cleanCache", "T", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "body", "Lkotlin/Lazy;", "lazyMetadata", "(Lkotlin/jvm/functions/Function1;)Lkotlin/Lazy;", "Ljava/sql/DatabaseMetaData;", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "url$delegate", "Lkotlin/Lazy;", "getUrl", "()Ljava/lang/String;", "url", "Ljava/math/BigDecimal;", "version$delegate", "getVersion", "()Ljava/math/BigDecimal;", "version", "databaseDialectName$delegate", "getDatabaseDialectName", "databaseDialectName", "getDatabaseName", "databaseName", "databaseProductVersion$delegate", "getDatabaseProductVersion", "databaseProductVersion", "", "defaultIsolationLevel$delegate", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel", "", "supportsAlterTableWithAddColumn$delegate", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn$delegate", "getSupportsAlterTableWithDropColumn", "supportsAlterTableWithDropColumn", "supportsMultipleResultSets$delegate", "getSupportsMultipleResultSets", "supportsMultipleResultSets", "supportsSelectForUpdate$delegate", "getSupportsSelectForUpdate", "supportsSelectForUpdate", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager", "currentSchema", "Ljava/lang/String;", "getCurrentSchema", "getTableNames", "()Ljava/util/Map;", "tableNames", "getSchemaNames", "Ljava/util/HashMap;", "existingIndicesCache", "Ljava/util/HashMap;", "Companion", "CachableMapWithDefault", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,414:1\n1#2:415\n1#2:485\n1#2:536\n1557#3:416\n1628#3,3:417\n1202#3,2:444\n1230#3,4:446\n3193#3,10:467\n1557#3:477\n1628#3,3:478\n1557#3:481\n1628#3,3:482\n1202#3,2:498\n1230#3,4:500\n1279#3,2:504\n1293#3,2:506\n1485#3:508\n1510#3,3:509\n1513#3,3:519\n1557#3:522\n1628#3,2:523\n2669#3,7:525\n1630#3:532\n1296#3:533\n295#3,2:537\n295#3,2:539\n10606#4:420\n10831#4,3:421\n10834#4,3:431\n9319#4,2:492\n9469#4,4:494\n381#5,7:424\n381#5,3:434\n381#5,7:437\n560#5:450\n545#5,6:451\n384#5,4:488\n381#5,7:512\n136#6,9:457\n216#6:466\n217#6:486\n145#6:487\n72#7,2:534\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n*L\n296#1:485\n58#1:536\n138#1:416\n138#1:417,3\n295#1:444,2\n295#1:446,4\n297#1:467,10\n298#1:477\n298#1:478,3\n304#1:481\n304#1:482,3\n342#1:498,2\n342#1:500,4\n343#1:504,2\n343#1:506,2\n372#1:508\n372#1:509,3\n372#1:519,3\n372#1:522\n372#1:523,2\n372#1:525,7\n372#1:532\n343#1:533\n350#1:537,2\n358#1:539,2\n157#1:420\n157#1:421,3\n157#1:431,3\n315#1:492,2\n315#1:494,4\n157#1:424,7\n253#1:434,3\n290#1:437,7\n296#1:450\n296#1:451,6\n253#1:488,4\n372#1:512,7\n296#1:457,9\n296#1:466\n296#1:486\n296#1:487\n58#1:534,2\n*E\n"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMetaData metadata;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy databaseDialectName$delegate;
    @NotNull
    private final Lazy databaseProductVersion$delegate;
    @NotNull
    private final Lazy defaultIsolationLevel$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithDropColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private String currentSchema;
    @NotNull
    private final HashMap<Table, List<Index>> existingIndicesCache;
    @NotNull
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(@NotNull String database, @NotNull DatabaseMetaData metadata) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(database);
        this.metadata = metadata;
        this.url$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::url_delegate$lambda$0);
        this.version$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::version_delegate$lambda$1);
        this.databaseDialectName$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::databaseDialectName_delegate$lambda$2);
        this.databaseProductVersion$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::databaseProductVersion_delegate$lambda$3);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::defaultIsolationLevel_delegate$lambda$4);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::supportsAlterTableWithAddColumn_delegate$lambda$5);
        this.supportsAlterTableWithDropColumn$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::supportsAlterTableWithDropColumn_delegate$lambda$6);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::supportsMultipleResultSets_delegate$lambda$7);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::supportsSelectForUpdate_delegate$lambda$8);
        this.identifierManager$delegate = this.lazyMetadata(JdbcDatabaseMetadataImpl::identifierManager_delegate$lambda$10);
        this.existingIndicesCache = new HashMap();
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public String getUrl() {
        Lazy lazy2 = this.url$delegate;
        Object object = lazy2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public BigDecimal getVersion() {
        Lazy lazy2 = this.version$delegate;
        return (BigDecimal)lazy2.getValue();
    }

    @Override
    @NotNull
    public String getDatabaseDialectName() {
        Lazy lazy2 = this.databaseDialectName$delegate;
        return (String)lazy2.getValue();
    }

    private final String getDatabaseName() {
        String string;
        String string2 = this.getDatabaseDialectName();
        if (Intrinsics.areEqual((Object)string2, (Object)MysqlDialect.Companion.getDialectName()) || Intrinsics.areEqual((Object)string2, (Object)MariaDBDialect.Companion.getDialectName())) {
            String string3 = this.getCurrentSchema();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            string = this.getDatabase();
        }
        return string;
    }

    @Override
    @NotNull
    public String getDatabaseProductVersion() {
        Lazy lazy2 = this.databaseProductVersion$delegate;
        return (String)lazy2.getValue();
    }

    @Override
    public int getDefaultIsolationLevel() {
        Lazy lazy2 = this.defaultIsolationLevel$delegate;
        return ((Number)lazy2.getValue()).intValue();
    }

    @Override
    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy2 = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsAlterTableWithDropColumn() {
        Lazy lazy2 = this.supportsAlterTableWithDropColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsMultipleResultSets() {
        Lazy lazy2 = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        Lazy lazy2 = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy2 = this.identifierManager$delegate;
        Object object = lazy2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (IdentifierManagerApi)object;
    }

    private final String getCurrentSchema() {
        if (this.currentSchema == null) {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = this.getDatabaseDialectName();
                if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) || Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getCatalog();
                    if (string2 == null) {
                        string2 = "";
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)OracleDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = this.getDatabaseName();
                    }
                } else {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl.currentSchema = string;
        }
        String string = this.currentSchema;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void resetCurrentScheme() {
        this.currentSchema = null;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(this, null, arg_0 -> JdbcDatabaseMetadataImpl._get_tableNames_$lambda$11(this, arg_0), 1, null);
    }

    private final List<String> tableNamesFor(String scheme) {
        String string;
        CharSequence charSequence;
        Pair pair;
        DatabaseMetaData $this$tableNamesFor_u24lambda_u2417 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            pair = TuplesKt.to((Object)scheme, (Object)"%");
        } else if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            CharSequence charSequence2;
            String string2 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string2;
                boolean bl2 = false;
                charSequence2 = this.getDatabaseName();
                string2 = string;
            } else {
                charSequence2 = charSequence;
            }
            pair = TuplesKt.to((Object)string2, (Object)charSequence2);
        } else {
            CharSequence charSequence3;
            String string3 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string3;
                boolean bl3 = false;
                charSequence3 = "%";
                string3 = string;
            } else {
                charSequence3 = charSequence;
            }
            pair = TuplesKt.to((Object)string3, (Object)charSequence3);
        }
        Pair pair2 = pair;
        String catalogName = (String)pair2.component1();
        String schemeName = (String)pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = $this$tableNamesFor_u24lambda_u2417.getTables(catalogName, schemeName, "%", stringArray);
        Intrinsics.checkNotNull((Object)resultSet);
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, arg_0 -> JdbcDatabaseMetadataImpl.tableNamesFor$lambda$17$lambda$16(useCatalogInsteadOfScheme, this, arg_0));
    }

    @Override
    @NotNull
    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> schemaNames() {
        void $this$mapTo$iv$iv;
        List list2;
        DatabaseMetaData $this$schemaNames_u24lambda_u2421 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            ResultSet resultSet = $this$schemaNames_u24lambda_u2421.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"getCatalogs(...)");
            list2 = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, JdbcDatabaseMetadataImpl::schemaNames$lambda$21$lambda$18);
        } else {
            ResultSet resultSet = $this$schemaNames_u24lambda_u2421.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"getSchemas(...)");
            list2 = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, JdbcDatabaseMetadataImpl::schemaNames$lambda$21$lambda$19);
        }
        List schemas = list2;
        Iterable $this$map$iv = schemas;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNull((Object)it);
            collection.add(identifierManagerApi.inProperCase((String)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public SchemaMetadata tableNamesByCurrentSchema(@Nullable Map<String, ? extends List<String>> tableNamesCache) {
        Map<String, List<String>> map2 = tableNamesCache;
        if (map2 == null) {
            map2 = this.getTableNames();
        }
        String string = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string);
        List tablesInSchema = (List)MapsKt.getValue(map2, (Object)string);
        String string2 = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string2);
        return new SchemaMetadata(string2, tablesInSchema);
    }

    private final List<ColumnMetadata> extractColumns(ResultSet $this$extractColumns) {
        List result = new ArrayList();
        while ($this$extractColumns.next()) {
            result.add(this.asColumnMetadata($this$extractColumns));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> columns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        result = new LinkedHashMap<K, V>();
        useSchemaInsteadOfDatabase = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        $this$groupBy$iv = tables;
        $i$f$groupBy = false;
        var7_7 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        var11_13 = ((void)$this$groupByTo$iv$iv).length;
        for (var10_11 = 0; var10_11 < var11_13; ++var10_11) {
            it = element$iv$iv = $this$groupByTo$iv$iv[var10_11];
            $i$a$-groupBy-JdbcDatabaseMetadataImpl$columns$tablesBySchema$1 = false;
            v0 = this.getIdentifierManager();
            v1 = it.getSchemaName();
            if (v1 == null) {
                v2 = this.getCurrentSchema();
                v1 = v2;
                Intrinsics.checkNotNull((Object)v2);
            }
            key$iv$iv = v0.inProperCase(v1);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-ArraysKt___ArraysKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v3 /* !! */  = answer$iv$iv$iv;
            } else {
                v3 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v3 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        tablesBySchema = destination$iv$iv;
        for (Map.Entry<K, V> var6_6 : tablesBySchema.entrySet()) {
            schema = (String)var6_6.getKey();
            schemaTables = (List)var6_6.getValue();
            for (Table table : schemaTables) {
                if (!useSchemaInsteadOfDatabase) ** GOTO lbl-1000
                v4 = this.getCurrentSchema();
                Intrinsics.checkNotNull((Object)v4);
                if (Intrinsics.areEqual((Object)schema, (Object)v4)) lbl-1000:
                // 2 sources

                {
                    v5 = this.getDatabaseName();
                } else {
                    v5 = schema;
                }
                catalog = v5;
                rs = this.metadata.getColumns(catalog, schema, table.nameInDatabaseCaseUnquoted(), "%");
                Intrinsics.checkNotNull((Object)rs);
                columns = this.extractColumns(rs);
                if (!(((Collection)columns).isEmpty() == false)) {
                    throw new IllegalStateException("Check failed.");
                }
                result.put(table, columns);
                rs.close();
            }
        }
        return result;
    }

    private final ColumnMetadata asColumnMetadata(ResultSet $this$asColumnMetadata) {
        Object object;
        String string;
        String string2 = $this$asColumnMetadata.getString("COLUMN_DEF");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = this.sanitizedDefault(it);
        } else {
            string = null;
        }
        String defaultDbValue = string;
        boolean autoIncrement = Intrinsics.areEqual((Object)$this$asColumnMetadata.getString("IS_AUTOINCREMENT"), (Object)"YES");
        int type = $this$asColumnMetadata.getInt("DATA_TYPE");
        String name = $this$asColumnMetadata.getString("COLUMN_NAME");
        boolean nullable = $this$asColumnMetadata.getBoolean("NULLABLE");
        Integer n = $this$asColumnMetadata.getInt("COLUMN_SIZE");
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer size = it != 0 ? n : null;
        Object object2 = $this$asColumnMetadata.getInt("DECIMAL_DIGITS");
        int it22 = ((Number)object2).intValue();
        boolean bl2 = false;
        Integer scale = it22 != 0 ? object2 : null;
        Intrinsics.checkNotNull((Object)name);
        String string3 = name;
        int n2 = type;
        boolean bl3 = nullable;
        Integer n3 = size;
        Integer n4 = scale;
        boolean bl4 = autoIncrement;
        String string4 = defaultDbValue;
        if (string4 != null) {
            Object it22 = object2 = string4;
            boolean bl5 = bl4;
            Integer n5 = n4;
            Integer n6 = n3;
            boolean bl6 = bl3;
            int n7 = n2;
            String string5 = string3;
            boolean bl7 = false;
            boolean bl8 = !autoIncrement;
            string3 = string5;
            n2 = n7;
            bl3 = bl6;
            n3 = n6;
            n4 = n5;
            bl4 = bl5;
            object = bl8 ? object2 : null;
        } else {
            object = null;
        }
        Object object3 = object;
        boolean bl9 = bl4;
        Integer n8 = n4;
        Integer n9 = n3;
        boolean bl10 = bl3;
        int n10 = n2;
        String string6 = string3;
        return new ColumnMetadata(string6, n10, bl10, n9, n8, bl9, (String)object3);
    }

    private final String sanitizedDefault(String defaultValue) {
        String string;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2Mode = H2Kt.getH2Mode(dialect);
        if (dialect instanceof MariaDBDialect || h2Mode == H2Dialect.H2CompatibilityMode.MariaDB) {
            if (StringsKt.startsWith$default((String)defaultValue, (String)"b'", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
            } else {
                string = this.extractNullAndStringFromDefaultValue(defaultValue);
            }
        } else if (dialect instanceof MysqlDialect && Intrinsics.areEqual((Object)defaultValue, (Object)"NULL")) {
            string = defaultValue;
        } else if (dialect instanceof MysqlDialect || h2Mode == H2Dialect.H2CompatibilityMode.MySQL) {
            if (StringsKt.startsWith$default((String)defaultValue, (String)"b'", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
            } else {
                string = this.extractNullAndStringFromDefaultValue(defaultValue);
            }
        } else if (dialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')'};
            string = this.extractNullAndStringFromDefaultValue(StringsKt.trim((String)defaultValue, (char[])cArray));
        } else {
            string = dialect instanceof OracleDialect ? this.extractNullAndStringFromDefaultValue(((Object)StringsKt.trim((CharSequence)defaultValue)).toString()) : this.extractNullAndStringFromDefaultValue(defaultValue);
        }
        return string;
    }

    private final String extractNullAndStringFromDefaultValue(String $this$extractNullAndStringFromDefaultValue) {
        String string;
        if (StringsKt.startsWith$default((String)$this$extractNullAndStringFromDefaultValue, (String)"NULL", (boolean)false, (int)2, null)) {
            string = null;
        } else if (StringsKt.startsWith$default((CharSequence)$this$extractNullAndStringFromDefaultValue, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$extractNullAndStringFromDefaultValue, (char)'\'', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)$this$extractNullAndStringFromDefaultValue, (char[])cArray);
        } else {
            string = $this$extractNullAndStringFromDefaultValue;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        for (Table table : tables) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Column $this$getOrPut$iv;
            Iterable columnName;
            Transaction transaction = TransactionManager.Companion.current();
            Pair<String, String> pair = this.tableCatalogAndSchema(table);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            Map $this$getOrPut$iv2 = this.existingIndicesCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(table);
            if (value$iv != null) continue;
            boolean bl = false;
            ResultSet rs = this.metadata.getPrimaryKeys(catalog, tableSchema, table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            ArrayList names = new ArrayList();
            while (rs.next()) {
                String it;
                if (rs.getString("PK_NAME") == null) continue;
                boolean bl3 = false;
                ((Collection)names).add(it);
            }
            rs.close();
            ArrayList pkNames = names;
            String string = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string);
            String storedIndexTable = Intrinsics.areEqual((Object)tableSchema, (Object)string) && DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? table.nameInDatabaseCase() : table.nameInDatabaseCaseUnquoted();
            rs = this.metadata.getIndexInfo(catalog, tableSchema, storedIndexTable, false, false);
            HashMap tmpIndices = new HashMap();
            while (rs.next()) {
                Object object;
                String indexName;
                String columnNameMetadata;
                if (rs.getString("INDEX_NAME") == null) continue;
                boolean bl4 = false;
                String string2 = rs.getString("COLUMN_NAME");
                if (string2 == null) {
                    DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                    string2 = databaseDialect instanceof MysqlDialect || databaseDialect instanceof SQLiteDialect ? "\"\"" : null;
                }
                if ((columnNameMetadata = string2) == null) continue;
                boolean bl5 = false;
                String column = transaction.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary((String)((Object)columnName));
                boolean isUnique = !rs.getBoolean("NON_UNIQUE");
                Object object2 = rs.getString("FILTER_CONDITION");
                Op.TRUE isPartial = object2 == null || object2.length() == 0 ? null : Op.TRUE.INSTANCE;
                object2 = tmpIndices;
                Triple key$iv = new Triple((Object)indexName, (Object)isUnique, (Object)isPartial);
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv.get(key$iv);
                if (value$iv2 == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((List)object).add(column);
            }
            rs.close();
            Iterable $this$associateBy$iv = table.getColumns();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            columnName = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                $this$getOrPut$iv = (Column)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl7 = false;
                map2.put(transaction.identity((Column<?>)it), element$iv$iv);
            }
            Map tColumns = destination$iv$iv;
            Map $this$filterNot$iv = tmpIndices;
            boolean $i$f$filterNot = false;
            Map capacity$iv22 = $this$filterNot$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator $i$f$associateByTo22 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while ($i$f$associateByTo22.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
                boolean bl8 = false;
                if (pkNames.contains(((Triple)it.getKey()).getFirst())) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filterNot$iv = destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Index index;
                List list2;
                void $this$mapTo$iv$iv;
                Object element$iv2;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl9 = false;
                Map.Entry entry = element$iv$iv;
                boolean bl10 = false;
                Triple index2 = (Triple)entry.getKey();
                List columns = (List)entry.getValue();
                Iterable $this$partition$iv = CollectionsKt.distinct((Iterable)columns);
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $this$partition$iv) {
                    String cn = (String)element$iv2;
                    boolean bl11 = false;
                    boolean bl12 = tColumns.get(cn) == null ? first$iv.add(element$iv2) : second$iv.add(element$iv2);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List functionBased = (List)pair2.component1();
                List columnBased = (List)pair2.component2();
                Iterable $this$map$iv = columnBased;
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cn;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl13 = false;
                    Object v = tColumns.get(cn);
                    Intrinsics.checkNotNull(v);
                    collection.add((Column)v);
                }
                List c = list2 = (List)destination$iv$iv3;
                boolean bl14 = false;
                List list3 = c.size() + functionBased.size() == columns.size() ? list2 : null;
                if (list3 != null) {
                    Collection<LiteralOp<String>> collection;
                    Collection<LiteralOp<String>> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    c = list3;
                    boolean bl15 = false;
                    destination$iv$iv3 = functionBased;
                    Op op = (Op)index2.getThird();
                    Iterator iterator3 = null;
                    String string4 = (String)index2.getFirst();
                    boolean bl16 = (Boolean)index2.getSecond();
                    List list4 = c;
                    boolean $i$f$map2 = false;
                    void var49_73 = $this$map$iv2;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        String string5 = (String)item$iv$iv;
                        collection2 = destination$iv$iv4;
                        boolean bl17 = false;
                        collection2.add(OpKt.stringLiteral((String)it));
                    }
                    collection2 = (List)destination$iv$iv4;
                    List list5 = list4;
                    boolean bl18 = bl16;
                    String string6 = string4;
                    Iterator iterator4 = iterator3;
                    Op op2 = op;
                    Collection<LiteralOp<String>> collection3 = collection2;
                    if (collection3.isEmpty()) {
                        op = op2;
                        iterator3 = iterator4;
                        string4 = string6;
                        bl16 = bl18;
                        list4 = list5;
                        boolean bl19 = false;
                        collection2 = null;
                        list5 = list4;
                        bl18 = bl16;
                        string6 = string4;
                        iterator4 = iterator3;
                        op2 = op;
                        collection = collection2;
                    } else {
                        collection = collection3;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 8;
                    Table table2 = !((Collection)functionBased).isEmpty() ? table : null;
                    List list6 = (List)collection;
                    Op op3 = op2;
                    Iterator iterator5 = iterator4;
                    String string7 = string6;
                    boolean bl20 = bl18;
                    List list7 = list5;
                    index = new Index(list7, bl20, string7, (String)((Object)iterator5), op3, list6, table2, n, defaultConstructorMarker);
                } else {
                    index = null;
                }
                if (index == null) continue;
                Index it$iv$iv = index;
                boolean bl21 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv2;
            $this$getOrPut$iv2.put(table, answer$iv);
        }
        return new HashMap(this.existingIndicesCache);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Table[] $this$associateWith$iv = tables;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        Table[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void table;
            Table element$iv$iv;
            Table table2 = element$iv$iv = $this$associateWithTo$iv$iv[i];
            Table table3 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Pair<String, String> pair = this.tableCatalogAndSchema((Table)table);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            ResultSet rs = this.metadata.getPrimaryKeys(catalog, tableSchema, table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            List columnNames = new ArrayList();
            String pkName = null;
            pkName = "";
            while (rs.next()) {
                if (rs.getString("PK_NAME") != null) {
                    String it;
                    boolean bl3 = false;
                    pkName = it;
                }
                ((Collection)columnNames).add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            PrimaryKeyMetadata primaryKeyMetadata = ((CharSequence)pkName).length() == 0 ? null : new PrimaryKeyMetadata(pkName, columnNames);
            map2.put(table3, primaryKeyMetadata);
        }
        return result$iv;
    }

    @Override
    @NotNull
    public List<String> sequences() {
        List sequences = new ArrayList();
        String[] stringArray = new String[]{"SEQUENCE"};
        ResultSet rs = this.metadata.getTables(null, null, null, stringArray);
        while (rs.next()) {
            String string = rs.getString(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            sequences.add(string);
        }
        return sequences;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(@NotNull List<? extends Table> tables) {
        Map map2;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.nameInDatabaseCaseUnquoted(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Iterable $this$associateWith$iv = allTables.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            List list$iv$iv;
            Object answer$iv$iv$iv;
            ForeignKeyConstraint it;
            Iterable $this$groupByTo$iv$iv;
            void table;
            Object element$iv$iv2;
            element$iv$iv2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            Object v = allTables.get(table);
            Intrinsics.checkNotNull(v);
            Pair<String, String> pair = this.tableCatalogAndSchema((Table)v);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            ResultSet resultSet = this.metadata.getImportedKeys(catalog, this.getIdentifierManager().inProperCase(tableSchema), (String)table);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"getImportedKeys(...)");
            Iterable $this$groupBy$iv = CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate(resultSet, arg_0 -> JdbcDatabaseMetadataImpl.tableConstraints$lambda$52$lambda$49(this, allTables, arg_0)));
            boolean $i$f$groupBy = false;
            Iterable iterable2 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
                Object object;
                it = (ForeignKeyConstraint)element$iv$iv3;
                boolean bl2 = false;
                String key$iv$iv = it.getFkName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv3);
            }
            Iterable $this$map$iv = destination$iv$iv2.values();
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (List)item$iv$iv;
                Object object = destination$iv$iv2;
                boolean bl4 = false;
                Iterable $this$reduce$iv = (Iterable)((Object)it);
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    answer$iv$iv$iv = (ForeignKeyConstraint)iterator$iv.next();
                    ForeignKeyConstraint p0 = (ForeignKeyConstraint)accumulator$iv;
                    boolean bl5 = false;
                    accumulator$iv = p0.plus((ForeignKeyConstraint)p1);
                }
                object.add((ForeignKeyConstraint)accumulator$iv);
            }
            List list2 = (List)destination$iv$iv2;
            map2.put(t, list2);
        }
        return result$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<String, String> tableCatalogAndSchema(Table table) {
        Pair pair;
        IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
        String string = table.getSchemaName();
        if (string == null) {
            String string2 = this.getCurrentSchema();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String tableSchema = identifierManagerApi.inProperCase(string);
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            String string3 = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string3);
            if (!Intrinsics.areEqual((Object)tableSchema, (Object)string3)) {
                pair = TuplesKt.to((Object)tableSchema, (Object)tableSchema);
                return pair;
            }
        }
        pair = TuplesKt.to((Object)this.getDatabaseName(), (Object)tableSchema);
        return pair;
    }

    @Override
    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> body) {
        return LazyKt.lazy(() -> JdbcDatabaseMetadataImpl.lazyMetadata$lambda$53(body, this));
    }

    private static final String url_delegate$lambda$0(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.getURL();
    }

    private static final BigDecimal version_delegate$lambda$1(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return new BigDecimal("" + $this$lazyMetadata.getDatabaseMajorVersion() + '.' + $this$lazyMetadata.getDatabaseMinorVersion());
    }

    /*
     * Unable to fully structure code
     */
    private static final String databaseDialectName_delegate$lambda$2(DatabaseMetaData $this$lazyMetadata) {
        block30: {
            block23: {
                block29: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block28: {
                                        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
                                        var1_1 = $this$lazyMetadata.getDriverName();
                                        if (var1_1 == null) break block23;
                                        switch (var1_1.hashCode()) {
                                            case -2136561961: {
                                                if (!var1_1.equals("H2 JDBC Driver")) {
                                                    ** break;
                                                }
                                                break block24;
                                            }
                                            case 1091927028: {
                                                if (!var1_1.equals("pgjdbc-ng")) {
                                                    ** break;
                                                }
                                                break block25;
                                            }
                                            case 289398428: {
                                                if (var1_1.equals("MariaDB Connector/J")) break;
                                                ** break;
                                            }
                                            case 162283562: {
                                                if (!var1_1.equals("MySQL Connector/J")) {
                                                    ** break;
                                                }
                                                ** GOTO lbl42
                                            }
                                            case 1472082629: {
                                                if (!var1_1.equals("PostgreSQL JDBC - NG")) {
                                                    ** break;
                                                }
                                                break block26;
                                            }
                                            case -1932749247: {
                                                if (!var1_1.equals("PostgreSQL JDBC Driver")) {
                                                    ** break;
                                                }
                                                break block27;
                                            }
                                            case 552031321: {
                                                if (!var1_1.equals("MySQL-AB JDBC Driver")) {
                                                    ** break;
                                                }
                                                ** GOTO lbl42
                                            }
                                            case -677312913: {
                                                if (!var1_1.equals("SQLite JDBC")) {
                                                    ** break;
                                                }
                                                break block28;
                                            }
                                            case -883610261: {
                                                if (!var1_1.equals("Oracle JDBC driver")) {
                                                    ** break;
                                                }
                                                break block29;
                                            }
                                            case -1557335597: {
                                                if (!var1_1.equals("MySQL Connector Java")) ** break;
lbl42:
                                                // 3 sources

                                                v0 = MysqlDialect.Companion.getDialectName();
                                                break block30;
                                            }
                                        }
                                        v0 = MariaDBDialect.Companion.getDialectName();
                                        break block30;
                                    }
                                    v0 = SQLiteDialect.Companion.getDialectName();
                                    break block30;
                                }
                                v0 = H2Dialect.Companion.getDialectName();
                                break block30;
                            }
                            v0 = PostgreSQLNGDialect.Companion.getDialectName();
                            break block30;
                        }
                        v0 = PostgreSQLNGDialect.Companion.getDialectName();
                        break block30;
                    }
                    v0 = PostgreSQLDialect.Companion.getDialectName();
                    break block30;
                }
                v0 = OracleDialect.Companion.getDialectName();
                break block30;
            }
            v1 = $this$lazyMetadata.getDriverName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDriverName(...)");
            if (StringsKt.startsWith$default((String)v1, (String)"Microsoft JDBC Driver ", (boolean)false, (int)2, null)) {
                v0 = SQLServerDialect.Companion.getDialectName();
            } else {
                v2 = $this$lazyMetadata.getURL();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getURL(...)");
                v0 = Database.Companion.getDialectName(v2);
                if (v0 == null) {
                    throw new IllegalStateException(("Unsupported driver " + $this$lazyMetadata.getDriverName() + " detected").toString());
                }
            }
        }
        return v0;
    }

    private static final String databaseProductVersion_delegate$lambda$3(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        String string = $this$lazyMetadata.getDatabaseProductVersion();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final int defaultIsolationLevel_delegate$lambda$4(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.getDefaultTransactionIsolation();
    }

    private static final boolean supportsAlterTableWithAddColumn_delegate$lambda$5(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.supportsAlterTableWithAddColumn();
    }

    private static final boolean supportsAlterTableWithDropColumn_delegate$lambda$6(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.supportsAlterTableWithDropColumn();
    }

    private static final boolean supportsMultipleResultSets_delegate$lambda$7(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.supportsMultipleResultSets();
    }

    private static final boolean supportsSelectForUpdate_delegate$lambda$8(DatabaseMetaData $this$lazyMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        return $this$lazyMetadata.supportsSelectForUpdate();
    }

    /*
     * WARNING - void declaration
     */
    private static final JdbcIdentifierManager identifierManager_delegate$lambda$10(DatabaseMetaData $this$lazyMetadata) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)$this$lazyMetadata, (String)"$this$lazyMetadata");
        ConcurrentMap concurrentMap = identityManagerCache;
        String key$iv = $this$lazyMetadata.getURL();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            JdbcIdentifierManager default$iv = new JdbcIdentifierManager($this$lazyMetadata);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (JdbcIdentifierManager)object;
    }

    private static final List _get_tableNames_$lambda$11(JdbcDatabaseMetadataImpl this$0, String schemeName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
        return this$0.tableNamesFor(schemeName);
    }

    private static final String tableNamesFor$lambda$17$lambda$16(boolean $useCatalogInsteadOfScheme, JdbcDatabaseMetadataImpl this$0, ResultSet $this$iterate) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
        String string3 = $this$iterate.getString("TABLE_NAME");
        Intrinsics.checkNotNull((Object)string3);
        String tableName = string3;
        if ($useCatalogInsteadOfScheme) {
            String string4 = $this$iterate.getString("TABLE_CAT");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string2 = it + '.' + tableName;
            } else {
                string2 = null;
            }
        } else {
            String string5 = $this$iterate.getString("TABLE_SCHEM");
            if (string5 != null) {
                String it = string5;
                boolean bl = false;
                string2 = it + '.' + tableName;
            } else {
                string2 = string = null;
            }
        }
        if (string2 == null) {
            string = tableName;
        }
        String fullTableName = string;
        return this$0.getIdentifierManager().inProperCase(fullTableName);
    }

    private static final String schemaNames$lambda$21$lambda$18(ResultSet $this$iterate) {
        Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
        return $this$iterate.getString("TABLE_CAT");
    }

    private static final String schemaNames$lambda$21$lambda$19(ResultSet $this$iterate) {
        Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
        return $this$iterate.getString("TABLE_SCHEM");
    }

    private static final ForeignKeyConstraint tableConstraints$lambda$52$lambda$49(JdbcDatabaseMetadataImpl this$0, Map $allTables, ResultSet $this$iterate) {
        ReferenceOption referenceOption;
        Object object;
        String constraintName;
        Object fromColumn;
        block15: {
            block14: {
                Object v11;
                block11: {
                    Object object2;
                    block13: {
                        block12: {
                            Object v4;
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$allTables, (String)"$allTables");
                                Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                                String string = $this$iterate.getString("FKTABLE_NAME");
                                Intrinsics.checkNotNull((Object)string);
                                String fromTableName = string;
                                IdentifierManagerApi identifierManagerApi = this$0.getIdentifierManager();
                                String string2 = $this$iterate.getString("FKCOLUMN_NAME");
                                Intrinsics.checkNotNull((Object)string2);
                                String fromColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string2);
                                object2 = (Table)$allTables.get(fromTableName);
                                if (object2 == null || (object2 = ((Table)object2).getColumns()) == null) break block12;
                                Iterable $this$firstOrNull$iv = (Iterable)object2;
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv) {
                                    Column it = (Column)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)this$0.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.getName()), (Object)fromColumnName)) continue;
                                    v4 = element$iv;
                                    break block10;
                                }
                                v4 = null;
                            }
                            if ((object2 = (Column)v4) != null) break block13;
                        }
                        return null;
                    }
                    fromColumn = object2;
                    String string = $this$iterate.getString("FK_NAME");
                    Intrinsics.checkNotNull((Object)string);
                    constraintName = string;
                    String string3 = $this$iterate.getString("PKTABLE_NAME");
                    Intrinsics.checkNotNull((Object)string3);
                    String targetTableName = string3;
                    IdentifierManagerApi identifierManagerApi = this$0.getIdentifierManager();
                    IdentifierManagerApi identifierManagerApi2 = this$0.getIdentifierManager();
                    String string4 = $this$iterate.getString("PKCOLUMN_NAME");
                    Intrinsics.checkNotNull((Object)string4);
                    String targetColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string4));
                    object = (Table)$allTables.get(targetTableName);
                    if (object == null || (object = ((Table)object).getColumns()) == null) break block14;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Column it = (Column)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)this$0.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase()), (Object)targetColumnName)) continue;
                        v11 = element$iv;
                        break block11;
                    }
                    v11 = null;
                }
                if ((object = (Column)v11) != null) break block15;
            }
            return null;
        }
        Object targetColumn = object;
        Object object3 = $this$iterate.getObject("UPDATE_RULE");
        if (object3 != null && (object3 = object3.toString()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null) {
            int it = ((Number)object3).intValue();
            boolean bl = false;
            referenceOption = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(it);
        } else {
            referenceOption = null;
        }
        ReferenceOption constraintUpdateRule = referenceOption;
        ReferenceOption constraintDeleteRule = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc($this$iterate.getInt("DELETE_RULE"));
        return new ForeignKeyConstraint((Column<?>)targetColumn, (Column<?>)fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName);
    }

    private static final Object lazyMetadata$lambda$53(Function1 $body, JdbcDatabaseMetadataImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $body.invoke((Object)this$0.metadata);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B1\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0004\b\u0013\u0010\u000fR \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u000b\u0010 \u001a\u00020\u001f8\u0016X\u0096\u0005R\u0011\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010!8\u0016X\u0096\u0005\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "", "map", "Lkotlin/Function1;", "default", "<init>", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "key", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "containsKey", "(Ljava/lang/Object;)Z", "isEmpty", "()Z", "value", "containsValue", "Ljava/util/Map;", "Lkotlin/jvm/functions/Function1;", "getDefault", "()Lkotlin/jvm/functions/Function1;", "", "", "getEntries", "()Ljava/util/Set;", "entries", "getKeys", "keys", "", "size", "", "values", "exposed-jdbc"})
    @SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,414:1\n381#2,7:415\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n*L\n87#1:415,7\n*E\n"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        @NotNull
        private final Map<K, V> map;
        @NotNull
        private final Function1<K, V> default;
        final /* synthetic */ JdbcDatabaseMetadataImpl this$0;

        public CachableMapWithDefault(@NotNull JdbcDatabaseMetadataImpl this$0, @NotNull Map<K, V> map2, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Intrinsics.checkNotNullParameter(function1, (String)"default");
            this.this$0 = this$0;
            this.map = map2;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map map2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new LinkedHashMap();
            }
            this(jdbcDatabaseMetadataImpl, map2, function1);
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.map.containsValue(value2);
        }

        public int getSize() {
            return this.map.size();
        }

        @NotNull
        public Collection<V> getValues() {
            return this.map.values();
        }

        @NotNull
        public final Function1<K, V> getDefault() {
            return this.default;
        }

        @Override
        @Nullable
        public V get(Object key) {
            Object object;
            Map<Object, Object> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                Object answer$iv = this.default.invoke(key);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            throw new UnsupportedOperationException("The entries field should not be used on CachableMapWithDefault because the lazy population of the collection for missing keys and entries may lead to inconsistencies between calls.");
        }

        @NotNull
        public Set<K> getKeys() {
            throw new UnsupportedOperationException("The keys field should not be used on CachableMapWithDefault because the lazy population of the collection for missing keys and keys may lead to inconsistencies between calls.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "<init>", "()V", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

