/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.IExpressionAlias;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0006J\u001b\u0010\u0019\u001a\u00020\u00042\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "", "binaryType", "()Ljava/lang/String;", "dateTimeType", "timestampWithTimeZoneType", "ubyteType", "ushortType", "uintegerType", "uintegerAutoincType", "ulongType", "ulongAutoincType", "textType", "mediumTextType", "largeTextType", "value", "", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "jsonBType", "Lorg/jetbrains/exposed/sql/Expression;", "e", "processForDefaultValue", "(Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "expression", "Lorg/jetbrains/exposed/sql/SortOrder;", "sortOrder", "", "precessOrderByClause", "(Lorg/jetbrains/exposed/sql/QueryBuilder;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/SortOrder;)V", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nMysqlDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n1#2:481\n*E\n"})
public final class MysqlDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    private MysqlDataTypeProvider() {
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String dateTimeType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        return (mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false) ? "DATETIME(6)" : "DATETIME";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        if (!(mysqlDialect != null ? mysqlDialect.isTimeZoneOffsetSupported() : false)) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("This vendor does not support timestamp with time zone data type");
            databaseDialect = DatabaseDialectKt.getCurrentDialect();
            MariaDBDialect mariaDBDialect = databaseDialect instanceof MariaDBDialect ? (MariaDBDialect)databaseDialect : null;
            if (mariaDBDialect != null) {
                MariaDBDialect mariaDBDialect2 = mariaDBDialect;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                string = "";
                stringBuilder = stringBuilder2;
            } else {
                string = " for this version";
            }
            DatabaseDialect databaseDialect2 = DatabaseDialectKt.getCurrentDialect();
            String string2 = stringBuilder.append(string).toString();
            throw new UnsupportedByDialectException(string2, databaseDialect2);
        }
        return "TIMESTAMP(6)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerAutoincType() {
        return "INT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "BIGINT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String textType() {
        return "text";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    @NotNull
    public String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = value2;
        return Intrinsics.areEqual((Object)string, (Object)"0") ? false : (Intrinsics.areEqual((Object)string, (Object)"1") ? true : Boolean.parseBoolean(value2));
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker) {
            if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) {
                string = super.processForDefaultValue(e);
                return string;
            }
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") < 0) throw new UnsupportedByDialectException("MySQL versions prior to 8.0.13 do not accept default values on JSON columns", DatabaseDialectKt.getCurrentDialect());
            string = '(' + super.processForDefaultValue(e) + ')';
            return string;
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) {
            string = super.processForDefaultValue(e);
            return string;
        }
        if (e instanceof ExpressionWithColumnType && ((ExpressionWithColumnType)e).getColumnType() instanceof IDateColumnType && StringsKt.startsWith$default((String)((ExpressionWithColumnType)e).toString(), (String)"CURRENT_TIMESTAMP", (boolean)false, (int)2, null)) {
            string = super.processForDefaultValue(e);
            return string;
        }
        if (!(e instanceof LiteralOp)) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") >= 0) {
                string = '(' + super.processForDefaultValue(e) + ')';
                return string;
            }
        }
        string = super.processForDefaultValue(e);
        return string;
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                Object object = expression instanceof IExpressionAlias ? (IExpressionAlias)((Object)expression) : null;
                if (object == null || (object = object.getAlias()) == null) {
                    object = expression;
                }
                Expression<?> exp = object;
                String nullExp = sortOrder == SortOrder.ASC_NULLS_LAST ? " IS NULL" : " IS NOT NULL";
                SortOrder order = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.ASC : SortOrder.DESC;
                Object[] objectArray = new Object[]{exp, nullExp, ", ", exp, " ", order.getCode()};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "0x" + hexString;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

