/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010!\n\u0002\b\u0004\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u001b\u0010\n\u001a\u00020\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010#\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010$J#\u0010&\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b&\u0010'R\u001b\u0010+\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0006R\u001b\u0010/\u001a\u00020\u00148@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b-\u0010.R\u001a\u00100\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010\u0006R\u001a\u00103\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b3\u00101\u001a\u0004\b4\u0010\u0006R\u001a\u00105\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b5\u00101\u001a\u0004\b6\u0010\u0006R\u001a\u00107\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b7\u00101\u001a\u0004\b8\u0010\u0006R\u001a\u00109\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b9\u00101\u001a\u0004\b:\u0010\u0006R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00140;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "", "isFractionDateTimeSupported", "()Z", "isTimeZoneOffsetSupported", "Lorg/jetbrains/exposed/sql/Expression;", "e", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "fillConstraintCacheForTables", "(Ljava/util/List;)V", "Lorg/jetbrains/exposed/sql/Index;", "index", "", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "setSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "createSchema", "cascade", "dropSchema", "(Lorg/jetbrains/exposed/sql/Schema;Z)Ljava/lang/String;", "table", "metadataMatchesTable", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/exposed/sql/Table;)Z", "isMysql8$delegate", "Lkotlin/Lazy;", "isMysql8$exposed_core", "isMysql8", "fullVersion$delegate", "getFullVersion$exposed_core", "()Ljava/lang/String;", "fullVersion", "supportsCreateSequence", "Z", "getSupportsCreateSequence", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "", "notAcceptableDefaults", "Ljava/util/List;", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nMysqlDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,480:1\n1202#2,2:481\n1230#2,4:483\n1611#2,9:487\n1863#2:496\n1864#2:498\n1620#2:499\n295#2,2:500\n230#2,2:502\n1246#2,4:513\n1#3:497\n381#4,7:504\n462#4:511\n412#4:512\n*S KotlinDebug\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDialect\n*L\n380#1:481,2\n380#1:483,4\n384#1:487,9\n384#1:496\n384#1:498\n384#1:499\n409#1:500,2\n415#1:502,2\n434#1:513,4\n384#1:497\n420#1:504,7\n434#1:511\n434#1:512\n*E\n"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(MysqlDialect::isMysql8_delegate$lambda$0);
    @NotNull
    private final Lazy fullVersion$delegate = LazyKt.lazy(MysqlDialect::fullVersion_delegate$lambda$2);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;
    @NotNull
    private final List<String> notAcceptableDefaults;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
        Object[] objectArray = new String[]{"CURRENT_DATE()", "CURRENT_DATE"};
        this.notAcceptableDefaults = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy2 = this.isMysql8$delegate;
        return (Boolean)lazy2.getValue();
    }

    @NotNull
    public final String getFullVersion$exposed_core() {
        Lazy lazy2 = this.fullVersion$delegate;
        return (String)lazy2.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    public final boolean isTimeZoneOffsetSupported() {
        return !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) && this.isMysql8$exposed_core();
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect && this.getFullVersion$exposed_core().compareTo("10.2.1") >= 0 || !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) && this.getFullVersion$exposed_core().compareTo("8.0.13") >= 0) {
            return true;
        }
        return !this.notAcceptableDefaults.contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        Object element$iv$iv2;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.nameInDatabaseCaseUnquoted(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Set allTableNames = allTables.keySet();
        String inTableList = CollectionsKt.joinToString$default((Iterable)allTableNames, (CharSequence)"','", (CharSequence)" ku.TABLE_NAME IN ('", (CharSequence)"')", (int)0, null, null, (int)56, null);
        Transaction tr = TransactionManager.Companion.current();
        Iterable $i$f$associateByTo22 = tables;
        object = new StringBuilder().append('\'');
        boolean $i$f$mapNotNull = false;
        element$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Table it = (Table)element$iv$iv3;
            boolean bl2 = false;
            if (it.getSchemaName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        String string = (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        if (string == null) {
            string = this.getDatabase();
        }
        String tableSchema = ((StringBuilder)object).append(string).append('\'').toString();
        HashMap constraintsToLoad = new HashMap();
        Transaction.exec$default(tr, StringsKt.trimIndent((String)("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + tableSchema + "\n                  AND ku.CONSTRAINT_SCHEMA = " + tableSchema + "\n                  AND rc.CONSTRAINT_SCHEMA = " + tableSchema + "\n                  AND " + inTableList + "\n                ORDER BY ku.ORDINAL_POSITION\n            ")), null, null, arg_0 -> MysqlDialect.fillConstraintCacheForTables$lambda$11(allTableNames, this, tr, allTables, constraintsToLoad, arg_0), 6, null);
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, MysqlDialect::createIndex$lambda$12, (int)31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u2413, (String[])stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Override
    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$metadataMatchesTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = StringsKt.replace$default((String)table.getTableNameWithoutScheme$exposed_core(), (String)"`", (String)"", (boolean)false, (int)4, null);
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)nameInDb);
        }
        return bl;
    }

    private static final boolean isMysql8_delegate$lambda$0() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("8.0"));
    }

    private static final String fullVersion_delegate$lambda$2$lambda$1(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getDatabaseProductVersion();
    }

    private static final String fullVersion_delegate$lambda$2() {
        return (String)TransactionManager.Companion.current().getDb().metadata$exposed_core(MysqlDialect::fullVersion_delegate$lambda$2$lambda$1);
    }

    private static final ForeignKeyConstraint fillConstraintCacheForTables$lambda$11$lambda$9$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ForeignKeyConstraint)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit fillConstraintCacheForTables$lambda$11(Set $allTableNames, MysqlDialect this$0, Transaction $tr, Map $allTables, HashMap $constraintsToLoad, ResultSet rs) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object constraintUpdateRule;
        Column column;
        Map fromTableName;
        Intrinsics.checkNotNullParameter((Object)$allTableNames, (String)"$allTableNames");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tr, (String)"$tr");
        Intrinsics.checkNotNullParameter((Object)$allTables, (String)"$allTables");
        Intrinsics.checkNotNullParameter((Object)$constraintsToLoad, (String)"$constraintsToLoad");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        while (rs.next()) {
            String constraintName;
            Object object;
            Object element$iv3;
            Column fromColumn;
            block7: {
                String targetTableName;
                Object v1;
                block6: {
                    Intrinsics.checkNotNull((Object)rs.getString("TABLE_NAME"));
                    if (!$allTableNames.contains(fromTableName)) continue;
                    String string = rs.getString("COLUMN_NAME");
                    Intrinsics.checkNotNull((Object)string);
                    String fromColumnName = this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, $tr);
                    Iterable $this$firstOrNull$iv = ((Table)MapsKt.getValue((Map)$allTables, (Object)fromTableName)).getColumns();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Column it = (Column)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)this$0.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), $tr), (Object)fromColumnName)) continue;
                        v1 = element$iv2;
                        break block6;
                    }
                    v1 = null;
                }
                if ((column = (Column)v1) == null) continue;
                fromColumn = column;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)rs.getString("CONSTRAINT_NAME"));
                Intrinsics.checkNotNull((Object)rs.getString("REFERENCED_TABLE_NAME"));
                String string = rs.getString("REFERENCED_COLUMN_NAME");
                Intrinsics.checkNotNull((Object)string);
                String targetColumnName = this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, $tr);
                Iterable $this$first$iv = ((Table)MapsKt.getValue((Map)$allTables, (Object)targetTableName)).getColumns();
                boolean $i$f$first = false;
                for (Object element$iv3 : $this$first$iv) {
                    Column it = (Column)element$iv3;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)this$0.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), $tr), (Object)targetColumnName)) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Column targetColumn = (Column)element$iv3;
            String string = rs.getString("UPDATE_RULE");
            Intrinsics.checkNotNull((Object)string);
            constraintUpdateRule = ReferenceOption.valueOf(StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null));
            String string2 = rs.getString("DELETE_RULE");
            Intrinsics.checkNotNull((Object)string2);
            ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null));
            Map $this$getOrPut$iv = $constraintsToLoad;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(fromTableName);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(fromTableName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Map)object).merge(constraintName, new ForeignKeyConstraint(targetColumn, fromColumn, (ReferenceOption)((Object)constraintUpdateRule), constraintDeleteRule, constraintName), (arg_0, arg_1) -> MysqlDialect.fillConstraintCacheForTables$lambda$11$lambda$9$lambda$8(fillConstraintCacheForTables.1.2.2.INSTANCE, arg_0, arg_1));
        }
        fromTableName = $constraintsToLoad;
        Map<String, Collection<ForeignKeyConstraint>> map2 = this$0.getColumnConstraintsCache();
        boolean $i$f$mapValues = false;
        column = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            constraintUpdateRule = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl3 = false;
            Map v = (Map)entry.getValue();
            Collection collection = v.values();
            map4.put(k, collection);
        }
        map2.putAll(destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final CharSequence createIndex$lambda$12(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

