/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge.commands;

import cc.reconnected.discordbridge.Bridge;
import cc.reconnected.discordbridge.discord.Client;
import cc.reconnected.server.database.PlayerData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class DiscordCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 environment) {
        LiteralArgumentBuilder commandBase = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"discord").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Join the Discord server via this invite link: ")).method_10852((class_2561)class_2561.method_43470((String)Bridge.CONFIG.inviteLink()).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to open invite"))).method_10958(new class_2558(class_2558.class_2559.field_11749, Bridge.CONFIG.inviteLink())))).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), false);
            return 1;
        })).then(class_2170.method_9247((String)"link").executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"This command can only be executed by players."), false);
                return 1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            PlayerData playerData = PlayerData.getPlayer((class_3222)player);
            if (playerData.get("discord_id") != null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You already linked your Discord profile!").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
                return 1;
            }
            String code = DiscordCommand.generateLinkCode();
            Bridge.linkCodes.put(code, player);
            Component text = ((TextComponent)Component.empty().append((Component)Component.text((String)"Your profile is ready to be linked!"))).appendNewline().appendNewline().append((Component)Component.text((String)"Run ")).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)("/link code:" + code)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy")))).clickEvent(ClickEvent.copyToClipboard((String)("/link code:" + code)))).color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).append((Component)Component.text((String)" on Discord to link your profile!")).color((TextColor)NamedTextColor.GREEN);
            ((class_2168)context.getSource()).sendMessage(text);
            return 1;
        }))).then(class_2170.method_9247((String)"unlink").executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"This command can only be executed by players."), false);
                return 1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            PlayerData playerData = PlayerData.getPlayer((class_3222)player);
            String snowflake = playerData.get("discord_id");
            if (snowflake == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You did not link your profile yet").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
                return 1;
            }
            Client client = Bridge.getInstance().getClient();
            if (client.role() != null) {
                Guild guild = client.guild();
                Member member = guild.getMemberById(snowflake);
                try {
                    guild.removeRoleFromMember((UserSnowflake)member, client.role()).queue();
                }
                catch (InsufficientPermissionException e) {
                    Bridge.LOGGER.error("Could not remove role from player", (Throwable)e);
                }
            }
            Bridge.discordLinks.remove(snowflake);
            playerData.delete("discord_id").join();
            Bridge.getInstance().saveData();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You have unlinked your Discord profile!").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), false);
            return 1;
        }));
        dispatcher.register(commandBase);
    }

    public static String generateLinkCode() {
        String code;
        while (Bridge.linkCodes.containsKey(code = String.format("%06d", DiscordCommand.randomInt(0, 999999)))) {
        }
        return code;
    }

    public static int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }
}

