/*
 * Decompiled with CFR 0.152.
 */
package dev.ashhhleyyy.playerpronouns.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import dev.ashhhleyyy.playerpronouns.api.Pronouns;
import dev.ashhhleyyy.playerpronouns.api.PronounsApi;
import dev.ashhhleyyy.playerpronouns.impl.Config;
import dev.ashhhleyyy.playerpronouns.impl.command.PronounsCommand;
import dev.ashhhleyyy.playerpronouns.impl.data.PronounDatabase;
import dev.ashhhleyyy.playerpronouns.impl.data.PronounList;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5218;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerPronouns
implements ModInitializer,
PronounsApi.PronounReader,
PronounsApi.PronounSetter {
    public static final Logger LOGGER = LoggerFactory.getLogger(PlayerPronouns.class);
    public static final String MOD_ID = "playerpronouns";
    private static final String USER_AGENT = "player-pronouns/1.0 (+https://ashhhleyyy.dev/projects/2021/player-pronouns)";
    private static final Map<String, String> PRONOUNDB_ID_MAP = new HashMap<String, String>(){
        {
            this.put("he", "he/him");
            this.put("it", "it/its");
            this.put("she", "she/her");
            this.put("they", "they/them");
            this.put("any", "any");
            this.put("ask", "ask");
            this.put("avoid", "avoid");
            this.put("other", "other");
        }
    };
    private PronounDatabase pronounDatabase;
    public static Config config;

    public void onInitialize() {
        LOGGER.info("Player Pronouns initialising...");
        config = Config.load();
        PronounList.load(config);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            try {
                Path playerData = server.method_27050(class_5218.field_24182);
                if (!Files.exists(playerData, new LinkOption[0])) {
                    Files.createDirectories(playerData, new FileAttribute[0]);
                }
                this.pronounDatabase = PronounDatabase.load(playerData.resolve("pronouns.dat"));
            }
            catch (IOException e) {
                LOGGER.error("Failed to create/load pronoun database!", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (this.pronounDatabase != null) {
                try {
                    this.pronounDatabase.save();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to save pronoun database!", (Throwable)e);
                }
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (config.enablePronounDBSync()) {
                Pronouns currentPronouns = this.pronounDatabase.get(handler.method_32311().method_5667());
                if (currentPronouns != null && !currentPronouns.remote()) {
                    return;
                }
                String pronounDbUrl = "https://pronoundb.org/api/v2/lookup?platform=minecraft&ids=%s".formatted(handler.method_32311().method_5667());
                try {
                    HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
                    HttpRequest req = HttpRequest.newBuilder().uri(new URI(pronounDbUrl)).header("User-Agent", USER_AGENT).GET().timeout(Duration.ofSeconds(10L)).build();
                    ((CompletableFuture)client.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAcceptAsync(body -> {
                        Pronouns currentPronouns2 = this.pronounDatabase.get(handler.method_32311().method_5667());
                        if (currentPronouns2 != null && !currentPronouns2.remote()) {
                            return;
                        }
                        JsonObject json = class_3518.method_15285((String)body);
                        StringBuilder pronouns = new StringBuilder("unspecified");
                        if (json.has(handler.method_32311().method_5667().toString()) && json.getAsJsonObject(handler.method_32311().method_5667().toString()).getAsJsonObject("sets").has("en")) {
                            JsonArray pronounsList = json.getAsJsonObject(handler.method_32311().method_5667().toString()).getAsJsonObject("sets").getAsJsonArray("en");
                            if (pronounsList.size() == 1) {
                                pronouns = new StringBuilder(PRONOUNDB_ID_MAP.get(pronounsList.get(0).getAsString()));
                            } else {
                                pronouns = new StringBuilder();
                                for (JsonElement prounoun : pronounsList) {
                                    pronouns.append(prounoun.getAsString()).append("/");
                                }
                                pronouns = new StringBuilder(pronouns.substring(0, pronouns.length() - 1));
                            }
                        }
                        if (!"unspecified".contentEquals(pronouns)) {
                            this.setPronouns(handler.method_32311(), new Pronouns(pronouns.toString(), PronounList.get().getCalculatedPronounStrings().get(pronouns.toString()), true));
                        }
                    }, (Executor)server);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, env) -> PronounsCommand.register((CommandDispatcher<class_2168>)dispatcher));
        Placeholders.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"pronouns"), (ctx, argument) -> this.fromContext(ctx, argument, true));
        Placeholders.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"raw_pronouns"), (ctx, argument) -> this.fromContext(ctx, argument, false));
        PronounsApi.initReader(this);
        PronounsApi.initSetter(this);
    }

    private PlaceholderResult fromContext(PlaceholderContext ctx, @Nullable String argument, boolean formatted) {
        if (!ctx.hasPlayer()) {
            return PlaceholderResult.invalid((String)"missing player");
        }
        String defaultMessage = argument != null ? argument : config.getDefaultPlaceholder();
        class_3222 player = ctx.player();
        assert (player != null);
        if (this.pronounDatabase == null) {
            return PlaceholderResult.value((String)defaultMessage);
        }
        Pronouns pronouns = this.pronounDatabase.get(player.method_5667());
        if (pronouns == null) {
            return PlaceholderResult.value((String)defaultMessage);
        }
        if (formatted) {
            return PlaceholderResult.value((class_2561)pronouns.formatted());
        }
        return PlaceholderResult.value((String)pronouns.raw());
    }

    public static void reloadConfig() {
        config = Config.load();
        PronounList.load(config);
    }

    @Override
    public boolean setPronouns(UUID playerId, @Nullable Pronouns pronouns) {
        if (this.pronounDatabase == null) {
            return false;
        }
        this.pronounDatabase.put(playerId, pronouns);
        try {
            this.pronounDatabase.save();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save pronoun database!", (Throwable)e);
        }
        return true;
    }

    @Override
    @Nullable
    public Pronouns getPronouns(class_3222 player) {
        return this.getPronouns(player.method_5667());
    }

    @Override
    @Nullable
    public Pronouns getPronouns(UUID playerId) {
        if (this.pronounDatabase == null) {
            return null;
        }
        return this.pronounDatabase.get(playerId);
    }
}

