/*
 * Decompiled with CFR 0.152.
 */
package dev.ashhhleyyy.playerpronouns.impl.data;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import ct.server.CtServer;
import ct.server.database.PlayerData;
import ct.server.database.PlayerTable;
import dev.ashhhleyyy.playerpronouns.api.Pronouns;
import dev.ashhhleyyy.playerpronouns.impl.data.PronounDatabase;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class PalettePronounDatabase
implements PronounDatabase {
    public static final int VERSION_NUMBER = 1;

    protected PalettePronounDatabase(Path databasePath, Object2ObjectMap<UUID, Pronouns> data) {
    }

    private PalettePronounDatabase() {
    }

    @Override
    public void put(UUID player, @Nullable Pronouns pronouns) {
        PlayerTable table = CtServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player));
        if (pData == null) {
            Logger.getLogger("PlayerPronouns").warning("Player data not found for " + String.valueOf(player));
            return;
        }
        if (pronouns == null) {
            pData.pronouns("");
        } else {
            pData.pronouns(Pronouns.CODEC.encode((Object)pronouns, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).toString());
        }
        table.updatePlayerData(pData);
    }

    @Override
    @Nullable
    public Pronouns get(UUID player) {
        PlayerTable table = CtServer.getInstance().playerTable();
        PlayerData pData = table.getPlayerData(Objects.requireNonNull(player));
        if (pData == null) {
            Logger.getLogger("PlayerPronouns").warning("Player data not found for " + String.valueOf(player));
            return null;
        }
        Pronouns pNouns = null;
        try {
            pNouns = (Pronouns)((Pair)Pronouns.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)pData.pronouns()).getAsJsonObject()).result().orElseThrow()).getFirst();
            Logger.getLogger("PlayerPronouns").info("Pronouns for " + String.valueOf(player) + " are " + pNouns.raw() + "|" + String.valueOf(pNouns.formatted()) + "|" + pNouns.remote());
        }
        catch (RuntimeException e) {
            return null;
        }
        return pNouns;
    }

    @Override
    public synchronized void save() throws IOException {
    }

    public static PalettePronounDatabase load(Path path) throws IOException {
        return new PalettePronounDatabase();
    }
}

