/*
 * Decompiled with CFR 0.152.
 */
package dev.ashhhleyyy.playerpronouns.impl.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.ashhhleyyy.playerpronouns.api.Pronoun;
import dev.ashhhleyyy.playerpronouns.impl.Config;
import dev.ashhhleyyy.playerpronouns.impl.PlayerPronouns;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3545;
import net.minecraft.class_5250;

public class PronounList {
    private static PronounList INSTANCE;
    private final List<Pronoun> defaultSingle;
    private final List<Pronoun> defaultPairs;
    private final List<Pronoun> customSingle;
    private final List<Pronoun> customPairs;
    private final Map<String, class_2561> calculatedPronounStrings;

    public PronounList(List<Pronoun> defaultSingle, List<Pronoun> defaultPairs, List<Pronoun> customSingle, List<Pronoun> customPairs) {
        this.defaultSingle = defaultSingle;
        this.defaultPairs = defaultPairs;
        this.customSingle = new ArrayList<Pronoun>(customSingle);
        this.customPairs = new ArrayList<Pronoun>(customPairs);
        this.calculatedPronounStrings = this.computePossibleCombinations();
    }

    public Map<String, class_2561> getCalculatedPronounStrings() {
        return this.calculatedPronounStrings;
    }

    private Map<String, class_2561> computePossibleCombinations() {
        HashMap<String, class_2561> ret = new HashMap<String, class_2561>();
        for (Pronoun pronoun : this.defaultSingle) {
            ret.put(pronoun.pronoun(), (class_2561)pronoun.toText());
        }
        for (Pronoun pronoun : this.customSingle) {
            ret.put(pronoun.pronoun(), (class_2561)pronoun.toText());
        }
        ArrayList<Pronoun> combinedPairs = new ArrayList<Pronoun>();
        combinedPairs.addAll(this.defaultPairs);
        combinedPairs.addAll(this.customPairs);
        for (int i = 0; i < combinedPairs.size(); ++i) {
            for (int j = 0; j < combinedPairs.size(); ++j) {
                if (i == j) continue;
                Pronoun a = (Pronoun)combinedPairs.get(i);
                Pronoun b = (Pronoun)combinedPairs.get(j);
                class_5250 combined = class_2561.method_43470((String)"");
                combined.method_10852((class_2561)a.toText());
                combined.method_10852((class_2561)class_2561.method_43470((String)"/"));
                combined.method_10852((class_2561)b.toText());
                ret.put(a.pronoun() + "/" + b.pronoun(), (class_2561)combined);
            }
        }
        return ret;
    }

    public static void load(Config config) {
        if (INSTANCE != null) {
            INSTANCE.reload(config);
            return;
        }
        class_3545<List<Pronoun>, List<Pronoun>> defaults = PronounList.loadDefaults();
        INSTANCE = new PronounList((List)defaults.method_15442(), (List)defaults.method_15441(), config.getSingle(), config.getPairs());
    }

    private void reload(Config config) {
        this.customSingle.clear();
        this.customPairs.clear();
        this.customSingle.addAll(config.getSingle());
        this.customPairs.addAll(config.getPairs());
        this.calculatedPronounStrings.clear();
        this.calculatedPronounStrings.putAll(this.computePossibleCombinations());
    }

    public static PronounList get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("PronounList has not been loaded!");
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static class_3545<List<Pronoun>, List<Pronoun>> loadDefaults() {
        try (InputStream is = Objects.requireNonNull(PronounList.class.getResourceAsStream("/default_pronouns.json"));){
            class_3545 class_35452;
            try (InputStreamReader reader = new InputStreamReader(is);){
                JsonObject ele = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonArray jsonSingle = ele.getAsJsonArray("single");
                JsonArray jsonPairs = ele.getAsJsonArray("pairs");
                ArrayList single = new ArrayList();
                ArrayList pairs = new ArrayList();
                jsonSingle.forEach(e -> single.add(new Pronoun(e.getAsString(), class_2583.field_24360)));
                jsonPairs.forEach(e -> pairs.add(new Pronoun(e.getAsString(), class_2583.field_24360)));
                class_35452 = new class_3545(single, pairs);
            }
            return class_35452;
        }
        catch (IOException e2) {
            PlayerPronouns.LOGGER.error("Failed to load default pronouns!", (Throwable)e2);
            return new class_3545(Collections.emptyList(), Collections.emptyList());
        }
    }
}

