/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.cerberus.client;

import cc.reconnected.cerberus.client.ModFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.fabricmc.loader.api.metadata.Person;

@Environment(value=EnvType.CLIENT)
public class ModDefinition {
    private final String id;
    private final String name;
    private final String version;
    private final String description;
    private final String type;
    private final ArrayList<ModPerson> authors = new ArrayList();
    private final ArrayList<ModPerson> contributors = new ArrayList();
    private final ModContact contact;
    private final HashMap<String, String> customValues = new HashMap();
    private final ArrayList<ModDep> dependencies = new ArrayList();
    private final ArrayList<String> provides = new ArrayList();
    private final ArrayList<String> license = new ArrayList();
    private final LinkedHashSet<ModFile> modFiles;
    private final ModOrigin origin;

    public ModDefinition(net.fabricmc.loader.api.metadata.ModOrigin origin, ModMetadata metadata, LinkedHashSet<ModFile> modFiles) {
        this.origin = new ModOrigin(origin.getKind());
        this.id = metadata.getId();
        this.name = metadata.getName();
        this.version = metadata.getVersion().getFriendlyString();
        this.description = metadata.getDescription();
        this.type = metadata.getType();
        metadata.getAuthors().forEach(author -> this.authors.add(new ModPerson((Person)author)));
        this.contact = new ModContact(metadata.getContact());
        metadata.getContributors().forEach(contributor -> this.contributors.add(new ModPerson((Person)contributor)));
        metadata.getDependencies().forEach(dependency -> this.dependencies.add(new ModDep(dependency.getModId(), dependency.getKind())));
        this.provides.addAll(metadata.getProvides());
        this.license.addAll(metadata.getLicense());
        this.modFiles = modFiles;
    }

    public String getName() {
        return this.name;
    }

    @Environment(value=EnvType.CLIENT)
    public class ModOrigin {
        ModOrigin.Kind kind;

        public ModOrigin(ModOrigin.Kind kind) {
            this.kind = kind;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ModContact {
        Map<String, String> information;

        public ModContact(ContactInformation information) {
            this.information = information.asMap();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ModDep {
        ModDependency.Kind kind;
        String modId;

        public ModDep(String modId, ModDependency.Kind kind) {
            this.modId = modId;
            this.kind = kind;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ModPerson {
        String name;
        ModContact contact;

        public ModPerson(Person author) {
            this.name = author.getName();
            this.contact = new ModContact(author.getContact());
        }
    }
}

