/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.TurtleWorldLocation;
import io.sc3.plethora.api.method.IContextBuilder;
import io.sc3.plethora.api.method.IContextFactory;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.IModuleHandler;
import io.sc3.plethora.api.module.SingletonModuleContainer;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.api.reference.Reference;
import io.sc3.plethora.core.AttachableWrapperPeripheral;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.ContextFactory;
import io.sc3.plethora.core.DefaultCostHandler;
import io.sc3.plethora.core.MethodRegistry;
import io.sc3.plethora.core.MethodWrapperPeripheral;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.executor.TaskRunner;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class TurtleUpgradeModule
implements ITurtleUpgrade {
    private final IModuleHandler handler;
    private final class_1799 stack;
    private final String adjective;

    public TurtleUpgradeModule(@Nonnull class_1799 stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        this.handler = handler;
        this.stack = stack;
        this.adjective = adjective;
    }

    @Nonnull
    public IModuleHandler getHandler() {
        return this.handler;
    }

    @Nonnull
    public class_2960 getUpgradeID() {
        return this.handler.getModule();
    }

    @Nonnull
    public String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Nonnull
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.PERIPHERAL;
    }

    @Nonnull
    public class_1799 getCraftingItem() {
        return this.stack;
    }

    protected boolean isBlacklisted() {
        return false;
    }

    public IPeripheral createPeripheral(final @Nonnull ITurtleAccess turtle, final @Nonnull TurtleSide side) {
        AttachableWrapperPeripheral peripheral;
        if (this.isBlacklisted()) {
            return null;
        }
        MethodRegistry registry = MethodRegistry.instance;
        TurtleModuleAccess access = new TurtleModuleAccess(turtle, side, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef2 = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                if (turtle.getUpgrade(side) != TurtleUpgradeModule.this) {
                    throw new LuaException("The upgrade is gone");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                return this.get();
            }
        };
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef2).withCostHandler(DefaultCostHandler.get(turtle))).withModules(container, containerRef2)).addContext("origin", new TurtlePlayerOwnable(turtle))).addContext("origin", new TurtleWorldLocation(turtle))).addContext("origin", turtle, (IReference)Reference.id(turtle));
        this.handler.getAdditionalContext(this.stack, access, (IContextBuilder)((Object)factory));
        class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        if (((List)paired.method_15442()).isEmpty()) {
            return null;
        }
        access.wrapper = peripheral = new AttachableWrapperPeripheral(this.handler.getModule().toString(), (Object)this, paired, new TaskRunner(), ((ContextFactory)factory).getAttachments());
        return peripheral;
    }

    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull class_2350 direction) {
        return TurtleCommandResult.failure((String)"Cannot use tool");
    }

    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof MethodWrapperPeripheral) {
            ((MethodWrapperPeripheral)peripheral).getRunner().update();
        }
    }

    private static final class TurtleModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final ITurtleAccess access;
        private final TurtleSide side;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private TurtleModuleAccess(ITurtleAccess access, TurtleSide side, IModuleHandler handler) {
            this.access = access;
            this.side = side;
            this.location = new TurtleWorldLocation(access);
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.access;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public class_2487 getData() {
            return this.access.getUpgradeNBTData(this.side);
        }

        @Override
        @Nonnull
        public MinecraftServer getServer() {
            return Objects.requireNonNull(this.location.getWorld().method_8503());
        }

        @Override
        public void markDataDirty() {
            this.access.updateUpgradeNBTData(this.side);
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }

    public static class TurtlePlayerOwnable
    implements ConstantReference<TurtlePlayerOwnable>,
    IPlayerOwnable {
        private final ITurtleAccess access;

        public TurtlePlayerOwnable(ITurtleAccess access) {
            this.access = access;
        }

        @Override
        @Nullable
        public GameProfile getOwningProfile() {
            return this.access.getOwningPlayer();
        }

        @Override
        @Nonnull
        public TurtlePlayerOwnable get() {
            return this;
        }

        @Override
        @Nonnull
        public TurtlePlayerOwnable safeGet() {
            return this;
        }
    }
}

