/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.neural;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dev.emi.trinkets.api.SlotReference;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.gameplay.neural.NeuralComputer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class NeuralComputerHandler {
    public static final int WIDTH = 39;
    public static final int HEIGHT = 13;
    private static final String SESSION_ID = "session_id";
    private static final String INSTANCE_ID = "instance_id";
    public static final String COMPUTER_ID = "id";
    public static final String ITEMS = "items";
    public static final String DIRTY = "dirty";
    public static final String MODULE_DATA = "module_data";

    private NeuralComputerHandler() {
    }

    public static NeuralComputer getServer(@Nonnull class_1799 stack, class_1309 owner, @Nonnull SlotReference slot) {
        class_2487 nbt = stack.method_7948();
        ServerComputerRegistry manager = ServerContext.get((MinecraftServer)Objects.requireNonNull(owner.method_5682())).registry();
        int sessionId = manager.getSessionID();
        NeuralComputer neural = null;
        if (nbt.method_10545(SESSION_ID) && nbt.method_25928(INSTANCE_ID)) {
            ServerComputer computer = manager.get(nbt.method_10550(SESSION_ID), nbt.method_25926(INSTANCE_ID));
            if (computer instanceof NeuralComputer) {
                NeuralComputer neuralComputer;
                neural = neuralComputer = (NeuralComputer)computer;
            } else if (computer != null) {
                Plethora.log.error("Computer is not NeuralComputer but " + computer);
            }
        }
        if (neural == null) {
            int computerId = nbt.method_10545(COMPUTER_ID) ? nbt.method_10550(COMPUTER_ID) : ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)owner.method_5682(), (String)"computer");
            String label = stack.method_7938() ? stack.method_7964().getString() : null;
            ServerComputer.Properties neuralProperties = ServerComputer.properties((int)computerId, (ComputerFamily)ComputerFamily.ADVANCED);
            neuralProperties.terminalSize(39, 13);
            neuralProperties.label(label);
            neural = new NeuralComputer((class_3218)owner.method_5770(), owner.method_24515(), neuralProperties);
            neural.readModuleData(nbt.method_10562(MODULE_DATA));
            nbt.method_10569(SESSION_ID, sessionId);
            nbt.method_25927(INSTANCE_ID, neural.register());
            nbt.method_10569(COMPUTER_ID, computerId);
            neural.turnOn();
            slot.inventory().method_5431();
        }
        return neural;
    }

    public static NeuralComputer tryGetServer(@Nonnull class_1799 stack, class_1309 player) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(SESSION_ID) || !nbt.method_25928(INSTANCE_ID)) {
            return null;
        }
        ServerComputerRegistry manager = ServerContext.get((MinecraftServer)Objects.requireNonNull(player.method_5682())).registry();
        ServerComputer computer = manager.get(nbt.method_10550(SESSION_ID), nbt.method_25926(INSTANCE_ID));
        if (computer == null) {
            return null;
        }
        if (computer instanceof NeuralComputer) {
            NeuralComputer neuralComputer = (NeuralComputer)computer;
            return neuralComputer;
        }
        Plethora.log.error("Computer is not NeuralComputer but " + computer);
        return null;
    }
}

