/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.api;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.api.CommandExtension;
import com.github.quiltservertools.ledger.api.DatabaseExtension;
import com.github.quiltservertools.ledger.api.LedgerExtension;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.libs.com.uchuhimo.konf.ConfigSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/github/quiltservertools/ledger/api/ExtensionManager;", "", "<init>", "()V", "Lcom/github/quiltservertools/ledger/api/LedgerExtension;", "extension", "", "registerExtension", "(Lcom/github/quiltservertools/ledger/api/LedgerExtension;)V", "failExtensionRegistration", "Ljava/util/Optional;", "Lcom/github/quiltservertools/ledger/api/DatabaseExtension;", "getDatabaseExtensionOptional", "()Ljava/util/Optional;", "", "extensions", "Ljava/util/List;", "databaseExtension", "Ljava/util/Optional;", "Lcom/github/quiltservertools/ledger/api/CommandExtension;", "commands", "getCommands", "()Ljava/util/List;", "ledger"})
@SourceDebugExtension(value={"SMAP\nExtensionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionManager.kt\ncom/github/quiltservertools/ledger/api/ExtensionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1869#2,2:41\n*S KotlinDebug\n*F\n+ 1 ExtensionManager.kt\ncom/github/quiltservertools/ledger/api/ExtensionManager\n*L\n29#1:41,2\n*E\n"})
public final class ExtensionManager {
    @NotNull
    public static final ExtensionManager INSTANCE = new ExtensionManager();
    @NotNull
    private static final List<LedgerExtension> extensions = new ArrayList();
    @NotNull
    private static Optional<DatabaseExtension> databaseExtension;
    @NotNull
    private static final List<CommandExtension> commands;

    private ExtensionManager() {
    }

    @NotNull
    public final List<CommandExtension> getCommands() {
        return commands;
    }

    public final void registerExtension(@NotNull LedgerExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        extensions.add(extension);
        if (extension instanceof DatabaseExtension) {
            if (databaseExtension.isEmpty()) {
                Optional<LedgerExtension> optional2 = Optional.of(extension);
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
                databaseExtension = optional2;
            } else {
                this.failExtensionRegistration(extension);
            }
        }
        if (extension instanceof CommandExtension) {
            commands.add((CommandExtension)extension);
        }
        Iterable $this$forEach$iv = extension.getConfigSpecs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigSpec it = (ConfigSpec)element$iv;
            boolean bl = false;
            LedgerConfigKt.getConfig().addSpec(it);
        }
    }

    private final void failExtensionRegistration(LedgerExtension extension) {
        Ledger.INSTANCE.getLogger().error("Unable to load extension " + extension.getIdentifier());
    }

    @NotNull
    public final Optional<DatabaseExtension> getDatabaseExtensionOptional() {
        return databaseExtension;
    }

    static {
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        databaseExtension = optional2;
        commands = new ArrayList();
    }
}

