/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.network.packet.receiver;

import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.network.Networking;
import com.github.quiltservertools.ledger.network.packet.Receiver;
import com.github.quiltservertools.ledger.network.packet.handshake.HandshakeContent;
import com.github.quiltservertools.ledger.network.packet.handshake.HandshakePacket;
import com.github.quiltservertools.ledger.network.packet.handshake.ModInfo;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakePacketReceiver;", "Lcom/github/quiltservertools/ledger/network/packet/Receiver;", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_3244;", "handler", "Lnet/minecraft/class_2540;", "buf", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "sender", "", "receive", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;Lnet/minecraft/class_3244;Lnet/minecraft/class_2540;Lnet/fabricmc/fabric/api/networking/v1/PacketSender;)V", "Lnet/minecraft/class_2487;", "nbt", "Ljava/util/Optional;", "Lcom/github/quiltservertools/ledger/network/packet/handshake/ModInfo;", "readInfo", "(Lnet/minecraft/class_2487;)Ljava/util/Optional;", "ledger"})
public final class HandshakePacketReceiver
implements Receiver {
    @Override
    public void receive(@NotNull MinecraftServer server, @NotNull class_3222 player, @NotNull class_3244 handler, @NotNull class_2540 buf, @NotNull PacketSender sender) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        if (!Permissions.check((class_1297)((class_1297)player), (String)"ledger.networking", (int)3)) {
            return;
        }
        class_2487 nbt = buf.method_10798();
        Optional<ModInfo> info2 = this.readInfo(nbt);
        if (info2.isPresent()) {
            String modid = info2.get().getModid();
            String modVersion = info2.get().getVersion();
            String ledgerVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("ledger").get()).getMetadata().getVersion().getFriendlyString();
            if (2 == info2.get().getProtocolVersion()) {
                LedgerKt.logInfo(player.method_5477().getString() + " joined the server with a Ledger compatible client mod");
                LedgerKt.logInfo("Mod: " + modid + ", Version: " + modVersion);
                HandshakePacket packet = new HandshakePacket();
                Intrinsics.checkNotNull((Object)ledgerVersion);
                packet.populate(new HandshakeContent(2, ledgerVersion, CollectionsKt.toList((Iterable)((Iterable)ActionRegistry.INSTANCE.getTypes()))));
                ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getChannel(), (class_2540)packet.getBuf());
                Networking.INSTANCE.enableNetworking(player);
            } else {
                Object[] objectArray = new Object[]{2, info2.get().getProtocolVersion()};
                player.method_7353((class_2561)class_2561.method_43469((String)"text.ledger.network.protocols_mismatched", (Object[])objectArray), false);
                LedgerKt.logInfo(player.method_5477().getString() + " joined the server with a Ledger compatible client mod, but has a mismatched protocol: Ledger protocol version: 2, Client mod protocol version " + info2.get().getProtocolVersion());
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.ledger.network.no_mod_info"), false);
        }
    }

    private final Optional<ModInfo> readInfo(class_2487 nbt) {
        if (nbt == null) {
            Optional<ModInfo> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            return optional2;
        }
        String string = nbt.method_10558("modid");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = nbt.method_10558("version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        Optional<ModInfo> optional3 = Optional.of(new ModInfo(string, string2, nbt.method_10550("protocol_version")));
        Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
        return optional3;
    }
}

