/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao.id;

import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.EntityIDFactory;
import org.jetbrains.exposed.dao.id.IdTable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\b\b\u0000\u0010\u0004*\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/dao/id/EntityIDFunctionProvider;", "", "<init>", "()V", "T", "value", "Lorg/jetbrains/exposed/dao/id/IdTable;", "table", "Lorg/jetbrains/exposed/dao/id/EntityID;", "createEntityID", "(Ljava/lang/Object;Lorg/jetbrains/exposed/dao/id/IdTable;)Lorg/jetbrains/exposed/dao/id/EntityID;", "Lorg/jetbrains/exposed/dao/id/EntityIDFactory;", "factory", "Lorg/jetbrains/exposed/dao/id/EntityIDFactory;", "exposed-core"})
public final class EntityIDFunctionProvider {
    @NotNull
    public static final EntityIDFunctionProvider INSTANCE = new EntityIDFunctionProvider();
    @NotNull
    private static final EntityIDFactory factory;

    private EntityIDFunctionProvider() {
    }

    @NotNull
    public final <T> EntityID<T> createEntityID(@NotNull T value2, @NotNull IdTable<T> table) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        return factory.createEntityID(value2, table);
    }

    static {
        ServiceLoader<EntityIDFactory> serviceLoader = ServiceLoader.load(EntityIDFactory.class, EntityIDFactory.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        EntityIDFactory entityIDFactory = (EntityIDFactory)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (entityIDFactory == null) {
            entityIDFactory = new EntityIDFactory(){

                @Override
                public <T> EntityID<T> createEntityID(T value2, IdTable<T> table) {
                    Intrinsics.checkNotNullParameter(value2, (String)"value");
                    Intrinsics.checkNotNullParameter(table, (String)"table");
                    return new EntityID<T>(value2, table);
                }
            };
        }
        factory = entityIDFactory;
    }
}

