/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "", "useObjectIdentifier", "<init>", "(Z)V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "nonNullValueToString", "(Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;)Ljava/lang/String;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "stmt", "", "setParameter", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;ILjava/lang/Object;)V", "Z", "getUseObjectIdentifier", "()Z", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/BlobColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1411:1\n1#2:1412\n*E\n"})
public final class BlobColumnType
extends ColumnType<ExposedBlob> {
    private final boolean useObjectIdentifier;

    public BlobColumnType(boolean useObjectIdentifier) {
        super(false, 1, null);
        this.useObjectIdentifier = useObjectIdentifier;
    }

    public /* synthetic */ BlobColumnType(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseObjectIdentifier() {
        return this.useObjectIdentifier;
    }

    @Override
    @NotNull
    public String sqlType() {
        String string;
        if (this.useObjectIdentifier && DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            string = "oid";
        } else {
            if (this.useObjectIdentifier) {
                throw new IllegalStateException("Storing BLOBs using OID columns is only supported by PostgreSQL".toString());
            }
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().blobType();
        }
        return string;
    }

    @Override
    @NotNull
    public ExposedBlob valueFromDB(@NotNull Object value2) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)value2;
        } else if (object instanceof InputStream) {
            exposedBlob = new ExposedBlob((InputStream)value2);
        } else if (object instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])value2);
        } else if (object instanceof Blob) {
            InputStream inputStream = ((Blob)value2).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getBinaryStream(...)");
            exposedBlob = new ExposedBlob(inputStream);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull ExposedBlob value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if (object == null || (object = ((H2Dialect)object).getOriginalDataTypeProvider()) == null) {
            object = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
        }
        return ((DataTypeProvider)object).hexToDb(value2.hexString());
    }

    @Override
    @Nullable
    public ExposedBlob readObject(@NotNull ResultSet rs, int index) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
            byte[] byArray = rs.getBytes(index);
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                exposedBlob = new ExposedBlob(p0);
            } else {
                exposedBlob = null;
            }
        } else if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && this.useObjectIdentifier) {
            Object object = rs.getBlob(index);
            if (object != null && (object = object.getBinaryStream()) != null) {
                Object p0 = object;
                boolean bl = false;
                exposedBlob = new ExposedBlob((InputStream)p0);
            } else {
                exposedBlob = null;
            }
        } else {
            InputStream inputStream = rs.getBinaryStream(index);
            if (inputStream != null) {
                InputStream p0 = inputStream;
                boolean bl = false;
                exposedBlob = new ExposedBlob(p0);
            } else {
                exposedBlob = null;
            }
        }
        return exposedBlob;
    }

    @Override
    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value2) {
        Object toSetValue;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Object object = value2 instanceof ExposedBlob ? (ExposedBlob)value2 : null;
        if (object == null || (object = ((ExposedBlob)object).getInputStream()) == null) {
            object = value2;
        }
        if ((toSetValue = object) instanceof InputStream) {
            stmt.setInputStream(index, (InputStream)toSetValue, this.useObjectIdentifier);
        } else if (toSetValue == null || toSetValue instanceof Op.NULL) {
            stmt.setNull(index, this);
        } else {
            super.setParameter(stmt, index, toSetValue);
        }
    }

    public BlobColumnType() {
        this(false, 1, null);
    }
}

