/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.Reader;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\bJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/exposed/sql/StringColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "collate", "<init>", "(Ljava/lang/String;)V", "value", "escape", "(Ljava/lang/String;)Ljava/lang/String;", "escapeAndQuote", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/String;", "nonNullValueToString", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getCollate", "()Ljava/lang/String;", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/StringColumnType\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1411:1\n975#2:1412\n1046#2,3:1413\n*S KotlinDebug\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/StringColumnType\n*L\n771#1:1412\n771#1:1413,3\n*E\n"})
public abstract class StringColumnType
extends ColumnType<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String collate;
    @NotNull
    private static final Map<Character, String> charactersToEscape;

    public StringColumnType(@Nullable String collate) {
        super(false, 1, null);
        this.collate = collate;
    }

    public /* synthetic */ StringColumnType(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Nullable
    public final String getCollate() {
        return this.collate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String escape(@NotNull String value2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        CharSequence $this$map$iv = value2;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = charactersToEscape.get(Character.valueOf((char)it));
            if (object == null) {
                object = Character.valueOf((char)it);
            }
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    protected final String escapeAndQuote(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? '\"' + this.escape(value2) + '\"' : this.escape(value2);
    }

    @Override
    @NotNull
    public String valueFromDB(@NotNull Object value2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof Clob) {
            Reader reader = ((Clob)value2).getCharacterStream();
            Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"getCharacterStream(...)");
            string = TextStreamsKt.readText((Reader)reader);
        } else {
            string = object instanceof byte[] ? new String((byte[])value2, Charsets.UTF_8) : value2.toString();
        }
        return string;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull String value2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        StringBuilder $this$nonNullValueToString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$nonNullValueToString_u24lambda_u241.append('\'');
        $this$nonNullValueToString_u24lambda_u241.append(this.escape(value2));
        $this$nonNullValueToString_u24lambda_u241.append('\'');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.StringColumnType");
        StringColumnType cfr_ignored_0 = (StringColumnType)other;
        return Intrinsics.areEqual((Object)this.collate, (Object)((StringColumnType)other).collate);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        String string = this.collate;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    public StringColumnType() {
        this(null, 1, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\''), (Object)"''"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n")};
        charactersToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/StringColumnType$Companion;", "", "<init>", "()V", "", "", "", "charactersToEscape", "Ljava/util/Map;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

