/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/OffsetDateTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "value", "nonNullValueToString", "(Ljava/time/OffsetDateTime;)Ljava/lang/String;", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/OffsetDateTime;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "notNullValueToDB", "(Ljava/time/OffsetDateTime;)Ljava/lang/Object;", "nonNullValueAsDefaultString", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "Companion", "exposed-java-time"})
public final class JavaOffsetDateTimeColumnType
extends ColumnType<OffsetDateTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaOffsetDateTimeColumnType INSTANCE = new JavaOffsetDateTimeColumnType();

    public JavaOffsetDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampWithTimeZoneType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull OffsetDateTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? '\'' + value2.format(JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof MysqlDialect ? '\'' + value2.format(JavaDateColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof OracleDialect ? JavaDateColumnTypeKt.access$oracleTimestampWithTimezoneLiteral(value2) : '\'' + value2.format(JavaDateColumnTypeKt.access$getDEFAULT_OFFSET_DATE_TIME_FORMATTER()) + '\''));
    }

    @Override
    @NotNull
    public OffsetDateTime valueFromDB(@NotNull Object value2) {
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof OffsetDateTime) {
            offsetDateTime = (OffsetDateTime)value2;
        } else if (object instanceof ZonedDateTime) {
            OffsetDateTime offsetDateTime2 = ((ZonedDateTime)value2).toOffsetDateTime();
            offsetDateTime = offsetDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"toOffsetDateTime(...)");
        } else if (object instanceof String) {
            TemporalAccessor temporalAccessor;
            OffsetDateTime offsetDateTime3 = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? ((temporalAccessor = JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER().parse((CharSequence)value2)).isSupported(ChronoField.OFFSET_SECONDS) ? OffsetDateTime.from(temporalAccessor) : OffsetDateTime.from(LocalDateTime.from(temporalAccessor).atOffset(ZoneOffset.UTC))) : OffsetDateTime.parse((CharSequence)value2);
            Intrinsics.checkNotNull((Object)offsetDateTime3);
            offsetDateTime = offsetDateTime3;
        } else {
            throw new IllegalStateException(("Unexpected value: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        return offsetDateTime;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? super.readObject(rs, index) : (databaseDialect instanceof OracleDialect ? rs.getObject(index, ZonedDateTime.class) : rs.getObject(index, OffsetDateTime.class));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull OffsetDateTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? value2.format(JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : (databaseDialect instanceof MysqlDialect ? value2.format(JavaDateColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) : value2);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull OffsetDateTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof PostgreSQLDialect ? '\'' + value2.format(JavaDateColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + "+00'::timestamp with time zone" : (dialect instanceof H2Dialect && ((H2Dialect)dialect).getH2Mode() == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + value2.format(JavaDateColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : (dialect instanceof MysqlDialect ? '\'' + value2.format(JavaDateColumnTypeKt.access$getMYSQL_FRACTION_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : super.nonNullValueAsDefaultString(value2)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaOffsetDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

