/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryAlias;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0018\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00150\u00140\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001c\u001a\u00020\u001b*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001b*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u001b\u0010!\u001a\u00020\u001b*\u00020\u001a2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010#\u001a\u0004\b$\u0010%R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010(R\u001f\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010)\u001a\u0004\b*\u0010+R,\u00100\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00150,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "", "Lorg/jetbrains/exposed/sql/ColumnSet;", "targetsSet", "limit", "Lorg/jetbrains/exposed/sql/Op;", "", "where", "<init>", "(Lorg/jetbrains/exposed/sql/ColumnSet;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;)V", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "prepared", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;Z)Ljava/lang/String;", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "", "registerWhereArg", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "registerUpdateArgs", "Lorg/jetbrains/exposed/sql/Join;", "join", "registerAdditionalArgs", "(Lorg/jetbrains/exposed/sql/QueryBuilder;Lorg/jetbrains/exposed/sql/Join;)V", "Lorg/jetbrains/exposed/sql/ColumnSet;", "getTargetsSet", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "Ljava/lang/Integer;", "getLimit", "()Ljava/lang/Integer;", "Lorg/jetbrains/exposed/sql/Op;", "getWhere", "()Lorg/jetbrains/exposed/sql/Op;", "", "Lorg/jetbrains/exposed/sql/Column;", "getFirstDataSet", "()Ljava/util/List;", "firstDataSet", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nUpdateStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateStatement.kt\norg/jetbrains/exposed/sql/statements/UpdateStatement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1#2:91\n216#3,2:92\n1863#4,2:94\n*S KotlinDebug\n*F\n+ 1 UpdateStatement.kt\norg/jetbrains/exposed/sql/statements/UpdateStatement\n*L\n80#1:92,2\n84#1:94,2\n*E\n"})
public class UpdateStatement
extends UpdateBuilder<Integer> {
    @NotNull
    private final ColumnSet targetsSet;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Op<Boolean> where;

    public UpdateStatement(@NotNull ColumnSet targetsSet, @Nullable Integer limit, @Nullable Op<Boolean> where) {
        Intrinsics.checkNotNullParameter((Object)targetsSet, (String)"targetsSet");
        super(StatementType.UPDATE, TableKt.targetTables(targetsSet));
        this.targetsSet = targetsSet;
        this.limit = limit;
        this.where = where;
    }

    public /* synthetic */ UpdateStatement(ColumnSet columnSet, Integer n, Op op, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            op = null;
        }
        this(columnSet, n, op);
    }

    @NotNull
    public final ColumnSet getTargetsSet() {
        return this.targetsSet;
    }

    @Nullable
    public final Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList(this.getValues());
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (this.getValues().isEmpty()) {
            return 0;
        }
        return $this$executeInternal.executeUpdate();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (!(!((Collection)this.getFirstDataSet()).isEmpty())) {
            boolean bl = false;
            String string2 = "Can't prepare UPDATE statement without fields to update";
            throw new IllegalArgumentException(string2.toString());
        }
        DatabaseDialect dialect = transaction.getDb().getDialect();
        ColumnSet columnSet = this.targetsSet;
        if (columnSet instanceof Table) {
            string = dialect.getFunctionProvider().update((Table)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction);
        } else if (columnSet instanceof Join) {
            FunctionProvider functionProvider;
            H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode(dialect);
            switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    functionProvider = H2FunctionProvider.INSTANCE;
                    break;
                }
                default: {
                    functionProvider = dialect.getFunctionProvider();
                }
            }
            FunctionProvider functionProvider2 = functionProvider;
            string = functionProvider2.update((Join)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction);
        } else {
            ExceptionsKt.throwUnsupportedException(transaction, "UPDATE with " + Reflection.getOrCreateKotlinClass(this.targetsSet.getClass()).getSimpleName() + " unsupported");
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        QueryBuilder $this$arguments_u24lambda_u241 = new QueryBuilder(true);
        boolean bl = false;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (this.targetsSet instanceof Join && dialect instanceof OracleDialect) {
            this.registerAdditionalArgs($this$arguments_u24lambda_u241, (Join)this.targetsSet);
            this.registerWhereArg($this$arguments_u24lambda_u241);
            this.registerUpdateArgs($this$arguments_u24lambda_u241);
        } else if (this.targetsSet instanceof Join && (dialect instanceof SQLServerDialect || dialect instanceof PostgreSQLDialect)) {
            this.registerUpdateArgs($this$arguments_u24lambda_u241);
            this.registerAdditionalArgs($this$arguments_u24lambda_u241, (Join)this.targetsSet);
            this.registerWhereArg($this$arguments_u24lambda_u241);
        } else if (this.targetsSet instanceof Join) {
            this.registerAdditionalArgs($this$arguments_u24lambda_u241, (Join)this.targetsSet);
            this.registerUpdateArgs($this$arguments_u24lambda_u241);
            this.registerWhereArg($this$arguments_u24lambda_u241);
        } else {
            this.registerUpdateArgs($this$arguments_u24lambda_u241);
            this.registerWhereArg($this$arguments_u24lambda_u241);
        }
        return !((Collection)$this$arguments_u24lambda_u241.getArgs()).isEmpty() ? CollectionsKt.listOf($this$arguments_u24lambda_u241.getArgs()) : CollectionsKt.emptyList();
    }

    private final void registerWhereArg(QueryBuilder $this$registerWhereArg) {
        block0: {
            Op<Boolean> op = this.where;
            if (op == null) break block0;
            op.toQueryBuilder($this$registerWhereArg);
        }
    }

    private final void registerUpdateArgs(QueryBuilder $this$registerUpdateArgs) {
        Map<Column<?>, Object> $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> it = element$iv = iterator2.next();
            boolean bl = false;
            $this$registerUpdateArgs.registerArgument(it.getKey(), it.getValue());
        }
    }

    private final void registerAdditionalArgs(QueryBuilder $this$registerAdditionalArgs, Join join) {
        Iterable $this$forEach$iv = join.getJoinParts$exposed_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Join.JoinPart it = (Join.JoinPart)element$iv;
            boolean bl = false;
            ColumnSet columnSet = it.getJoinPart();
            Object object2 = columnSet instanceof QueryAlias ? (QueryAlias)columnSet : null;
            if (object2 != null && (object2 = ((QueryAlias)object2).getQuery()) != null) {
                ((AbstractQuery)object2).prepareSQL($this$registerAdditionalArgs);
            }
            if ((object = it.getAdditionalConstraint()) == null || (object = (Op)object.invoke((Object)SqlExpressionBuilder.INSTANCE)) == null) continue;
            ((Expression)object).toQueryBuilder($this$registerAdditionalArgs);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.PostgreSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.Oracle.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.SQLServer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

