/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpsertStatement;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u000f2\u00020\u0001:\u0002\u0010\u000fJ.\u0010\u0007\u001a\u00020\u00042\u001d\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0002\b\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f\"\u0004\b\u0000\u0010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpsertBuilder;", "", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "", "Lkotlin/ExtensionFunctionType;", "onUpdate", "storeUpdateValues", "(Lkotlin/jvm/functions/Function2;)V", "T", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "insertValue", "(Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Companion", "InsertValue", "Lorg/jetbrains/exposed/sql/statements/BatchUpsertStatement;", "Lorg/jetbrains/exposed/sql/statements/UpsertStatement;", "exposed-core"})
public interface UpsertBuilder {
    @NotNull
    public static final Companion Companion = org.jetbrains.exposed.sql.statements.UpsertBuilder$Companion.$$INSTANCE;

    public void storeUpdateValues(@NotNull Function2<? super UpsertBuilder, ? super UpdateStatement, Unit> var1);

    @NotNull
    public <T> ExpressionWithColumnType<T> insertValue(@NotNull Column<T> var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpsertBuilder$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "(Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;)Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "exposed-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final FunctionProvider getFunctionProvider(@NotNull DatabaseDialect dialect) {
            FunctionProvider functionProvider;
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            if (dialect instanceof H2Dialect) {
                H2Dialect.H2CompatibilityMode h2CompatibilityMode = ((H2Dialect)dialect).getH2Mode();
                switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                    case 1: 
                    case 2: {
                        functionProvider = MysqlFunctionProvider.INSTANCE.INSTANCE;
                        break;
                    }
                    default: {
                        functionProvider = H2FunctionProvider.INSTANCE;
                        break;
                    }
                }
            } else {
                functionProvider = dialect.getFunctionProvider();
            }
            return functionProvider;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
                try {
                    nArray[H2Dialect.H2CompatibilityMode.MariaDB.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[H2Dialect.H2CompatibilityMode.MySQL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void storeUpdateValues(@NotNull UpsertBuilder $this, @NotNull Function2<? super UpsertBuilder, ? super UpdateStatement, Unit> onUpdate) {
            Intrinsics.checkNotNullParameter(onUpdate, (String)"onUpdate");
            Intrinsics.checkNotNull((Object)$this, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.statements.InsertStatement<*>");
            Object object = new UpdateStatement(((InsertStatement)((Object)$this)).getTable(), null, null, 4, null);
            UpdateStatement $this$storeUpdateValues_u24lambda_u240 = object;
            boolean bl = false;
            onUpdate.invoke((Object)$this, (Object)$this$storeUpdateValues_u24lambda_u240);
            List<Pair<Column<?>, Object>> arguments = ((UpdateStatement)object).getFirstDataSet();
            object = $this;
            if (object instanceof UpsertStatement) {
                MapsKt.putAll(((UpsertStatement)$this).getUpdateValues$exposed_core(), (Iterable)arguments);
            } else if (object instanceof BatchUpsertStatement) {
                MapsKt.putAll(((BatchUpsertStatement)$this).getUpdateValues$exposed_core(), (Iterable)arguments);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        @NotNull
        public static <T> ExpressionWithColumnType<T> insertValue(@NotNull UpsertBuilder $this, @NotNull Column<T> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return new InsertValue<T>(column, column.getColumnType());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B(\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u00058\u0016X\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpsertBuilder$InsertValue;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "<init>", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/IColumnType;)V", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "toQueryBuilder", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "Lorg/jetbrains/exposed/sql/Column;", "getColumn", "()Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/IColumnType;", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-core"})
    private static final class InsertValue<T>
    extends ExpressionWithColumnType<T> {
        @NotNull
        private final Column<T> column;
        @NotNull
        private final IColumnType<T> columnType;

        public InsertValue(@NotNull Column<T> column, @NotNull IColumnType<T> columnType) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
            this.column = column;
            this.columnType = columnType;
        }

        @NotNull
        public final Column<T> getColumn() {
            return this.column;
        }

        @Override
        @NotNull
        public IColumnType<T> getColumnType() {
            return this.columnType;
        }

        @Override
        public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
            Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
            Transaction transaction = TransactionManager.Companion.current();
            FunctionProvider functionProvider = Companion.getFunctionProvider(transaction.getDb().getDialect());
            functionProvider.insertValue(transaction.identity(this.column), queryBuilder);
        }
    }
}

